/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.view.View;
import android.widget.ImageView;
import com.google.android.gms.R;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.media.uicontroller.UIController;
import com.google.android.gms.internal.zzyu;
import java.io.IOException;

public class zzxo
extends UIController {
    private static final zzyu zzaoQ = new zzyu("MuteToggleUIController");
    private final ImageView zzasy;
    private final String zzasK;
    private final String zzasL;
    private final Context zzOZ;
    private final Cast.Listener zzamd;
    private final View.OnClickListener zzasw;

    public zzxo(ImageView imageView, Context context) {
        this.zzasy = imageView;
        this.zzOZ = context.getApplicationContext();
        this.zzasK = this.zzOZ.getString(R.string.cast_mute);
        this.zzasL = this.zzOZ.getString(R.string.cast_unmute);
        this.zzamd = new Cast.Listener(){

            public void onVolumeChanged() {
                zzxo.this.zztx();
            }
        };
        this.zzasw = new View.OnClickListener(){

            public void onClick(View view) {
                CastSession castSession = CastContext.getSharedInstance(zzxo.this.zzOZ).getSessionManager().getCurrentCastSession();
                if (castSession != null && castSession.isConnected()) {
                    try {
                        if (castSession.isMute()) {
                            castSession.setMute(false);
                            zzxo.this.zzal(true);
                        } else {
                            castSession.setMute(true);
                            zzxo.this.zzal(false);
                        }
                    }
                    catch (IOException | IllegalArgumentException exception) {
                        zzaoQ.zzc("Unable to call CastSession.setMute(boolean).", new Object[]{exception});
                    }
                }
            }
        };
    }

    @Override
    public void onSessionConnected(CastSession castSession) {
        super.onSessionConnected(castSession);
        this.zzasy.setOnClickListener(this.zzasw);
        castSession.addCastListener(this.zzamd);
        this.zztx();
    }

    @Override
    public void onSessionEnded() {
        this.zzasy.setOnClickListener(null);
        super.onSessionEnded();
    }

    @Override
    public void onMediaStatusUpdated() {
        this.zzasy.setEnabled(true);
    }

    @Override
    public void onSendingRemoteMediaRequest() {
        this.zzasy.setEnabled(false);
    }

    private void zztx() {
        CastSession castSession = CastContext.getSharedInstance(this.zzOZ).getSessionManager().getCurrentCastSession();
        if (castSession != null && castSession.isConnected()) {
            this.zzasy.setEnabled(true);
            if (castSession.isMute()) {
                this.zzal(false);
            } else {
                this.zzal(true);
            }
        } else {
            this.zzasy.setEnabled(false);
        }
    }

    private void zzal(boolean bl) {
        this.zzasy.setSelected(bl);
        this.zzasy.setContentDescription((CharSequence)(bl ? this.zzasK : this.zzasL));
    }
}

