/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.view.View;
import android.widget.ImageView;
import com.google.android.gms.R;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.uicontroller.UIController;

public class zzxp
extends UIController {
    private final ImageView zzasy;
    private final View zzasN;
    private final boolean zzasO;
    private final Drawable zzasP;
    private final String zzasQ;
    private final Drawable zzasR;
    private final String zzasS;
    private final Drawable zzasT;
    private final String zzasU;
    private final View.OnClickListener zzasw;

    public zzxp(@NonNull ImageView imageView, Context context, @NonNull Drawable drawable2, @NonNull Drawable drawable3, Drawable drawable4, View view, boolean bl) {
        this.zzasy = imageView;
        this.zzasP = drawable2;
        this.zzasR = drawable3;
        this.zzasT = drawable4 != null ? drawable4 : drawable3;
        this.zzasQ = context.getString(R.string.cast_play);
        this.zzasS = context.getString(R.string.cast_pause);
        this.zzasU = context.getString(R.string.cast_stop);
        this.zzasN = view;
        this.zzasO = bl;
        this.zzasw = new View.OnClickListener(){

            public void onClick(View view) {
                RemoteMediaClient remoteMediaClient = zzxp.this.getRemoteMediaClient();
                if (remoteMediaClient != null && remoteMediaClient.hasMediaSession()) {
                    remoteMediaClient.togglePlayback();
                }
            }
        };
    }

    @Override
    public void onSessionConnected(CastSession castSession) {
        super.onSessionConnected(castSession);
        this.zzasy.setOnClickListener(this.zzasw);
        this.zztx();
    }

    @Override
    public void onSessionEnded() {
        this.zzasy.setOnClickListener(null);
        super.onSessionEnded();
    }

    @Override
    public void onMediaStatusUpdated() {
        this.zztx();
    }

    @Override
    public void onSendingRemoteMediaRequest() {
        this.zzam(true);
    }

    private void zztx() {
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession()) {
            return;
        }
        if (remoteMediaClient.isPaused()) {
            this.zza(this.zzasP, this.zzasQ);
        } else if (remoteMediaClient.isPlaying()) {
            if (remoteMediaClient.isLiveStream()) {
                this.zza(this.zzasT, this.zzasU);
            } else {
                this.zza(this.zzasR, this.zzasS);
            }
        } else if (remoteMediaClient.isBuffering()) {
            this.zzam(false);
        } else if (remoteMediaClient.isLoadingNextItem()) {
            this.zzam(true);
        }
    }

    private void zza(Drawable drawable2, String string2) {
        this.zzasy.setImageDrawable(drawable2);
        this.zzasy.setContentDescription((CharSequence)string2);
        this.zzasy.setVisibility(0);
        this.zzasy.setEnabled(true);
        if (this.zzasN != null) {
            this.zzasN.setVisibility(8);
        }
    }

    private void zzam(boolean bl) {
        if (this.zzasN != null) {
            this.zzasN.setVisibility(0);
        }
        this.zzasy.setVisibility(this.zzasO ? 4 : 0);
        this.zzasy.setEnabled(!bl);
    }
}

