/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.os.RemoteException;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.CastStateListener;
import com.google.android.gms.cast.framework.Session;
import com.google.android.gms.cast.framework.SessionManagerListener;
import com.google.android.gms.cast.framework.zzc;
import com.google.android.gms.cast.framework.zzn;
import com.google.android.gms.cast.framework.zzr;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.internal.zzyz;

public class SessionManager {
    private static final zzyz zzapV = new zzyz("SessionManager");
    private final zzn zzaqG;

    public SessionManager(zzn zzn2) {
        this.zzaqG = zzn2;
    }

    public Session getCurrentSession() {
        zzac.zzdj((String)"Must be called from the main thread.");
        try {
            return (Session)zzd.zzF((IObjectWrapper)this.zzaqG.zzsP());
        }
        catch (RemoteException remoteException) {
            zzapV.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getWrappedCurrentSession", zzn.class.getSimpleName()});
            return null;
        }
    }

    public CastSession getCurrentCastSession() {
        zzac.zzdj((String)"Must be called from the main thread.");
        Session session = this.getCurrentSession();
        if (session != null && session instanceof CastSession) {
            return (CastSession)session;
        }
        return null;
    }

    public void endCurrentSession(boolean bl) {
        zzac.zzdj((String)"Must be called from the main thread.");
        try {
            this.zzaqG.zzb(true, bl);
        }
        catch (RemoteException remoteException) {
            zzapV.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"endCurrentSession", zzn.class.getSimpleName()});
        }
    }

    public void addSessionManagerListener(SessionManagerListener<Session> sessionManagerListener) throws NullPointerException {
        zzac.zzdj((String)"Must be called from the main thread.");
        this.addSessionManagerListener(sessionManagerListener, Session.class);
    }

    public <T extends Session> void addSessionManagerListener(SessionManagerListener<T> sessionManagerListener, Class<T> clazz) throws NullPointerException {
        zzac.zzw(sessionManagerListener);
        zzac.zzw(clazz);
        zzac.zzdj((String)"Must be called from the main thread.");
        try {
            this.zzaqG.zza(new zzr<T>(sessionManagerListener, clazz));
        }
        catch (RemoteException remoteException) {
            zzapV.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"addSessionManagerListener", zzn.class.getSimpleName()});
        }
    }

    public void removeSessionManagerListener(SessionManagerListener<Session> sessionManagerListener) {
        zzac.zzdj((String)"Must be called from the main thread.");
        this.removeSessionManagerListener(sessionManagerListener, Session.class);
    }

    public <T extends Session> void removeSessionManagerListener(SessionManagerListener<T> sessionManagerListener, Class clazz) {
        zzac.zzw((Object)clazz);
        zzac.zzdj((String)"Must be called from the main thread.");
        if (sessionManagerListener == null) {
            return;
        }
        try {
            this.zzaqG.zzb(new zzr<T>(sessionManagerListener, clazz));
        }
        catch (RemoteException remoteException) {
            zzapV.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"removeSessionManagerListener", zzn.class.getSimpleName()});
        }
    }

    int getCastState() {
        try {
            return this.zzaqG.getCastState();
        }
        catch (RemoteException remoteException) {
            zzapV.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"addCastStateListener", zzn.class.getSimpleName()});
            return 1;
        }
    }

    void addCastStateListener(CastStateListener castStateListener) throws NullPointerException {
        zzac.zzw((Object)castStateListener);
        try {
            this.zzaqG.zza(new zzc(castStateListener));
        }
        catch (RemoteException remoteException) {
            zzapV.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"addCastStateListener", zzn.class.getSimpleName()});
        }
    }

    void removeCastStateListener(CastStateListener castStateListener) {
        if (castStateListener == null) {
            return;
        }
        try {
            this.zzaqG.zzb(new zzc(castStateListener));
        }
        catch (RemoteException remoteException) {
            zzapV.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"removeCastStateListener", zzn.class.getSimpleName()});
        }
    }

    public IObjectWrapper zzsE() {
        try {
            return this.zzaqG.zzsJ();
        }
        catch (RemoteException remoteException) {
            zzapV.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getWrappedThis", zzn.class.getSimpleName()});
            return null;
        }
    }
}

