/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.internal.featurehighlight;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import com.google.android.gms.R;
import com.google.android.gms.internal.zzblg;
import com.google.android.gms.internal.zzbli;

class zzc
extends Drawable {
    private final Paint zzaqV = new Paint();
    private final Paint zzarv = new Paint();
    private final Rect zzara = new Rect();
    private final int zzarw;
    private final int zzarx;
    private float zzaqW;
    private float zzary = 1.0f;
    private float centerX;
    private float centerY;

    public zzc(Context context) {
        Resources resources = context.getResources();
        this.zzarw = resources.getDimensionPixelSize(R.dimen.cast_libraries_material_featurehighlight_inner_radius);
        this.zzarx = resources.getInteger(R.integer.cast_libraries_material_featurehighlight_pulse_base_alpha);
        this.zzaqV.setAntiAlias(true);
        this.zzaqV.setStyle(Paint.Style.FILL);
        this.zzarv.setAntiAlias(true);
        this.zzarv.setStyle(Paint.Style.FILL);
        this.setColor(-1);
    }

    public void draw(Canvas canvas) {
        canvas.drawCircle(this.centerX, this.centerY, this.zzaqW * this.zzary, this.zzaqV);
    }

    public void setAlpha(int n) {
        this.zzaqV.setAlpha(n);
        this.invalidateSelf();
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.zzaqV.setColorFilter(colorFilter);
        this.invalidateSelf();
    }

    public int getOpacity() {
        return -3;
    }

    public void setColor(@ColorInt int n) {
        this.zzaqV.setColor(n);
        this.zzarv.setColor(n);
        this.invalidateSelf();
    }

    public void zzc(Rect rect) {
        this.zzara.set(rect);
        this.centerX = this.zzara.exactCenterX();
        this.centerY = this.zzara.exactCenterY();
        this.zzaqW = Math.max((float)this.zzarw, Math.max((float)this.zzara.width() / 2.0f, (float)this.zzara.height() / 2.0f));
        this.invalidateSelf();
    }

    public Animator zztk() {
        PropertyValuesHolder propertyValuesHolder = PropertyValuesHolder.ofFloat((String)"scale", (float[])new float[]{0.0f, 1.0f});
        PropertyValuesHolder propertyValuesHolder2 = PropertyValuesHolder.ofFloat((String)"alpha", (float[])new float[]{0.0f, 1.0f});
        ObjectAnimator objectAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this), (PropertyValuesHolder[])new PropertyValuesHolder[]{propertyValuesHolder, propertyValuesHolder2});
        objectAnimator.setInterpolator((TimeInterpolator)zzbli.zzUL());
        return objectAnimator.setDuration(350L);
    }

    public Animator zztl() {
        AnimatorSet animatorSet = new AnimatorSet();
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"scale", (float[])new float[]{1.0f, 1.1f}).setDuration(500L);
        ObjectAnimator objectAnimator2 = ObjectAnimator.ofFloat((Object)((Object)this), (String)"scale", (float[])new float[]{1.1f, 1.0f}).setDuration(500L);
        PropertyValuesHolder propertyValuesHolder = PropertyValuesHolder.ofFloat((String)"pulseScale", (float[])new float[]{1.1f, 2.0f});
        PropertyValuesHolder propertyValuesHolder2 = PropertyValuesHolder.ofFloat((String)"pulseAlpha", (float[])new float[]{1.0f, 0.0f});
        ObjectAnimator objectAnimator3 = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this), (PropertyValuesHolder[])new PropertyValuesHolder[]{propertyValuesHolder, propertyValuesHolder2}).setDuration(500L);
        animatorSet.play((Animator)objectAnimator);
        animatorSet.play((Animator)objectAnimator2).with((Animator)objectAnimator3).after((Animator)objectAnimator);
        animatorSet.setInterpolator((TimeInterpolator)zzbli.zzUN());
        animatorSet.setStartDelay(500L);
        zzblg.zzc((Animator)animatorSet);
        return animatorSet;
    }

    public Animator zztm() {
        return this.zztn();
    }

    public Animator zztn() {
        PropertyValuesHolder propertyValuesHolder = PropertyValuesHolder.ofFloat((String)"scale", (float[])new float[]{0.0f});
        PropertyValuesHolder propertyValuesHolder2 = PropertyValuesHolder.ofFloat((String)"alpha", (float[])new float[]{0.0f});
        PropertyValuesHolder propertyValuesHolder3 = PropertyValuesHolder.ofFloat((String)"pulseScale", (float[])new float[]{0.0f});
        PropertyValuesHolder propertyValuesHolder4 = PropertyValuesHolder.ofFloat((String)"pulseAlpha", (float[])new float[]{0.0f});
        ObjectAnimator objectAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this), (PropertyValuesHolder[])new PropertyValuesHolder[]{propertyValuesHolder, propertyValuesHolder2, propertyValuesHolder3, propertyValuesHolder4});
        objectAnimator.setInterpolator((TimeInterpolator)zzbli.zzUM());
        return objectAnimator.setDuration(200L);
    }
}

