/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.RectF;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Parcelable;
import android.support.v4.media.MediaMetadataCompat;
import android.support.v4.media.session.MediaSessionCompat;
import android.support.v4.media.session.PlaybackStateCompat;
import android.text.TextUtils;
import android.view.KeyEvent;
import com.google.android.gms.R;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaMetadata;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.framework.CastOptions;
import com.google.android.gms.cast.framework.ReconnectionService;
import com.google.android.gms.cast.framework.media.MediaNotificationService;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.common.util.zzt;
import com.google.android.gms.internal.zzxe;
import com.google.android.gms.internal.zzxf;

public class zzxj
implements RemoteMediaClient.Listener {
    private final Context zzPB;
    private final CastOptions zzati;
    private final zzxe zzaqL;
    private final ComponentName zzatj;
    private final zzxf zzatk;
    private final zzxf zzatl;
    private RemoteMediaClient zzaqo;
    private CastDevice zzani;
    private MediaSessionCompat zzatm;
    private MediaSessionCompat.Callback zzatn;
    private boolean zzato;

    public zzxj(Context context, CastOptions castOptions, zzxe zzxe2) {
        this.zzPB = context;
        this.zzati = castOptions;
        this.zzaqL = zzxe2;
        this.zzatj = this.zzati.getCastMediaOptions() != null && !TextUtils.isEmpty((CharSequence)this.zzati.getCastMediaOptions().getExpandedControllerActivityClassName()) ? new ComponentName(this.zzPB, this.zzati.getCastMediaOptions().getExpandedControllerActivityClassName()) : null;
        this.zzatk = new zzxf(this.zzPB);
        this.zzatk.zza(new zzxf.zza(){

            @Override
            public void zzc(Bitmap bitmap) {
                bitmap = zzxj.zzd(bitmap);
                zzxj.this.zza(bitmap, 0);
            }
        });
        this.zzatl = new zzxf(this.zzPB);
        this.zzatl.zza(new zzxf.zza(){

            @Override
            public void zzc(Bitmap bitmap) {
                zzxj.this.zza(bitmap, 3);
            }
        });
    }

    public static Bitmap zzd(Bitmap bitmap) {
        if (bitmap == null) {
            return null;
        }
        int n = bitmap.getWidth();
        int n2 = bitmap.getHeight();
        int n3 = (int)((float)n * 9.0f / 16.0f + 0.5f);
        float f = (n3 - n2) / 2;
        RectF rectF = new RectF(0.0f, f, (float)n, f + (float)n2);
        Bitmap bitmap2 = Bitmap.createBitmap((int)n, (int)n3, (Bitmap.Config)bitmap.getConfig());
        Canvas canvas = new Canvas(bitmap2);
        canvas.drawBitmap(bitmap, null, rectF, null);
        return bitmap2;
    }

    public void zza(RemoteMediaClient remoteMediaClient, CastDevice castDevice) {
        AudioManager audioManager;
        if (this.zzato || this.zzati == null || this.zzati.getCastMediaOptions() == null || remoteMediaClient == null || castDevice == null) {
            return;
        }
        this.zzaqo = remoteMediaClient;
        this.zzaqo.addListener(this);
        this.zzani = castDevice;
        if (!zzt.zzzo()) {
            audioManager = (AudioManager)this.zzPB.getSystemService("audio");
            audioManager.requestAudioFocus(null, 3, 3);
        }
        audioManager = new ComponentName(this.zzPB, this.zzati.getCastMediaOptions().getMediaIntentReceiverClassName());
        Intent intent = new Intent("android.intent.action.MEDIA_BUTTON");
        intent.setComponent((ComponentName)audioManager);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.zzPB, (int)0, (Intent)intent, (int)0);
        this.zzatm = new MediaSessionCompat(this.zzPB, "CastMediaSession", (ComponentName)audioManager, pendingIntent);
        this.zzatm.setFlags(3);
        this.zza(0, null);
        if (this.zzani != null && !TextUtils.isEmpty((CharSequence)this.zzani.getFriendlyName())) {
            this.zzatm.setMetadata(new MediaMetadataCompat.Builder().putString("android.media.metadata.ALBUM_ARTIST", this.zzPB.getResources().getString(R.string.cast_casting_to_device, new Object[]{this.zzani.getFriendlyName()})).build());
        }
        this.zzatn = new MediaSessionCompat.Callback(){

            public boolean onMediaButtonEvent(Intent intent) {
                KeyEvent keyEvent = (KeyEvent)intent.getParcelableExtra("android.intent.extra.KEY_EVENT");
                if (keyEvent != null && (keyEvent.getKeyCode() == 127 || keyEvent.getKeyCode() == 126)) {
                    zzxj.this.zzaqo.togglePlayback();
                }
                return true;
            }

            public void onPlay() {
                zzxj.this.zzaqo.togglePlayback();
            }

            public void onPause() {
                zzxj.this.zzaqo.togglePlayback();
            }
        };
        this.zzatm.setCallback(this.zzatn);
        this.zzatm.setActive(true);
        this.zzaqL.setMediaSessionCompat(this.zzatm);
        this.zzato = true;
        this.zztN();
    }

    public void zzce(int n) {
        if (!this.zzato) {
            return;
        }
        this.zzato = false;
        if (this.zzaqo != null) {
            this.zzaqo.removeListener(this);
        }
        if (!zzt.zzzo()) {
            AudioManager audioManager = (AudioManager)this.zzPB.getSystemService("audio");
            audioManager.abandonAudioFocus(null);
        }
        this.zzaqL.setMediaSessionCompat(null);
        if (this.zzatk != null) {
            this.zzatk.clear();
        }
        if (this.zzatl != null) {
            this.zzatl.clear();
        }
        if (this.zzatm != null) {
            this.zzatm.setSessionActivity(null);
            this.zzatm.setCallback(null);
            this.zzatm.setMetadata(new MediaMetadataCompat.Builder().build());
            this.zza(0, null);
            this.zzatm.setActive(false);
            this.zzatm.release();
            this.zzatm = null;
        }
        this.zzaqo = null;
        this.zzani = null;
        this.zzatn = null;
        this.zztQ();
        if (n == 0) {
            this.zztS();
        }
    }

    public MediaSessionCompat.Token getMediaSessionToken() {
        return this.zzatm == null ? null : this.zzatm.getSessionToken();
    }

    @Override
    public void onQueueStatusUpdated() {
        this.zztN();
    }

    @Override
    public void onStatusUpdated() {
        this.zztN();
    }

    @Override
    public void onMetadataUpdated() {
        this.zztN();
    }

    @Override
    public void onPreloadStatusUpdated() {
        this.zztN();
    }

    @Override
    public void onAdBreakStatusUpdated() {
        this.zztN();
    }

    @Override
    public void onSendingRemoteMediaRequest() {
    }

    private void zztN() {
        int n;
        MediaStatus mediaStatus = this.zzaqo.getMediaStatus();
        MediaInfo mediaInfo = mediaStatus == null ? null : mediaStatus.getMediaInfo();
        MediaMetadata mediaMetadata = mediaInfo == null ? null : mediaInfo.getMetadata();
        boolean bl = false;
        if (mediaStatus == null || mediaInfo == null || mediaMetadata == null) {
            n = 0;
        } else {
            switch (this.zzaqo.getPlayerState()) {
                case 4: {
                    n = 6;
                    break;
                }
                case 2: {
                    n = 3;
                    break;
                }
                case 3: {
                    n = 2;
                    break;
                }
                case 1: {
                    int n2 = mediaStatus.getIdleReason();
                    boolean bl2 = this.zzaqo.isLiveStream() && n2 == 2;
                    int n3 = mediaStatus.getLoadingItemId();
                    boolean bl3 = bl = n3 != 0 && (n2 == 1 || n2 == 3);
                    if (bl2) {
                        n = 2;
                        break;
                    }
                    MediaQueueItem mediaQueueItem = mediaStatus.getQueueItemById(n3);
                    if (mediaQueueItem != null) {
                        mediaInfo = mediaQueueItem.getMedia();
                        n = 6;
                        break;
                    }
                    n = 0;
                    break;
                }
                default: {
                    n = 0;
                }
            }
        }
        this.zza(n, mediaInfo);
        if (n == 0) {
            this.zztQ();
            this.zztS();
        } else {
            this.zztP();
            if (!bl) {
                this.zztR();
            }
        }
    }

    private void zza(int n, MediaInfo mediaInfo) {
        if (n == 0) {
            this.zzatm.setPlaybackState(new PlaybackStateCompat.Builder().setState(0, 0L, 1.0f).build());
            this.zzatm.setMetadata(new MediaMetadataCompat.Builder().build());
        } else {
            this.zzatm.setPlaybackState(new PlaybackStateCompat.Builder().setState(n, 0L, 1.0f).setActions(512L).build());
            this.zzatm.setSessionActivity(this.zztT());
            this.zzb(mediaInfo);
        }
    }

    private void zzb(MediaInfo mediaInfo) {
        MediaMetadata mediaMetadata = mediaInfo.getMetadata();
        MediaMetadataCompat.Builder builder = this.zztO().putString("android.media.metadata.TITLE", mediaMetadata.getString("com.google.android.gms.cast.metadata.TITLE")).putString("android.media.metadata.DISPLAY_TITLE", mediaMetadata.getString("com.google.android.gms.cast.metadata.TITLE")).putString("android.media.metadata.DISPLAY_SUBTITLE", mediaMetadata.getString("com.google.android.gms.cast.metadata.SUBTITLE")).putLong("android.media.metadata.DURATION", mediaInfo.getStreamDuration());
        this.zzatm.setMetadata(builder.build());
        Uri uri = this.zza(mediaMetadata, 0);
        if (uri != null) {
            this.zzatk.zzo(uri);
        } else {
            this.zza((Bitmap)null, 0);
        }
        Uri uri2 = this.zza(mediaMetadata, 3);
        if (uri2 != null) {
            this.zzatl.zzo(uri2);
        } else {
            this.zza((Bitmap)null, 3);
        }
    }

    private void zza(Bitmap bitmap, int n) {
        if (n == 0) {
            if (bitmap != null) {
                this.zzatm.setMetadata(this.zztO().putBitmap("android.media.metadata.DISPLAY_ICON", bitmap).build());
            } else {
                Bitmap bitmap2 = Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                bitmap2.eraseColor(0);
                this.zzatm.setMetadata(this.zztO().putBitmap("android.media.metadata.DISPLAY_ICON", bitmap2).build());
            }
        } else if (n == 3) {
            this.zzatm.setMetadata(this.zztO().putBitmap("android.media.metadata.ALBUM_ART", bitmap).build());
        }
    }

    private Uri zza(MediaMetadata mediaMetadata, int n) {
        WebImage webImage = this.zzati.getCastMediaOptions().getImagePicker() != null ? this.zzati.getCastMediaOptions().getImagePicker().onPickImage(mediaMetadata, n) : (mediaMetadata.hasImages() ? (WebImage)mediaMetadata.getImages().get(0) : null);
        return webImage == null ? null : webImage.getUrl();
    }

    private MediaMetadataCompat.Builder zztO() {
        MediaMetadataCompat mediaMetadataCompat = this.zzatm.getController().getMetadata();
        return mediaMetadataCompat == null ? new MediaMetadataCompat.Builder() : new MediaMetadataCompat.Builder(mediaMetadataCompat);
    }

    private void zztP() {
        if (this.zzati.getCastMediaOptions().getNotificationOptions() == null) {
            return;
        }
        if (this.zzaqo == null) {
            return;
        }
        Intent intent = new Intent(this.zzPB, MediaNotificationService.class);
        intent.setPackage(this.zzPB.getPackageName());
        intent.setAction("com.google.android.gms.cast.framework.action.UPDATE_NOTIFICATION");
        intent.putExtra("extra_media_info", (Parcelable)this.zzaqo.getMediaInfo());
        intent.putExtra("extra_remote_media_client_player_state", this.zzaqo.getPlayerState());
        intent.putExtra("extra_cast_device", (Parcelable)this.zzani);
        intent.putExtra("extra_media_session_token", (Parcelable)this.getMediaSessionToken());
        MediaStatus mediaStatus = this.zzaqo.getMediaStatus();
        if (mediaStatus != null) {
            boolean bl = false;
            boolean bl2 = false;
            switch (mediaStatus.getQueueRepeatMode()) {
                case 1: 
                case 2: 
                case 3: {
                    bl = true;
                    bl2 = true;
                    break;
                }
                default: {
                    Integer n = mediaStatus.getIndexById(mediaStatus.getCurrentItemId());
                    if (n == null) break;
                    if (n > 0) {
                        bl2 = true;
                    }
                    if (n >= mediaStatus.getQueueItemCount() - 1) break;
                    bl = true;
                }
            }
            intent.putExtra("extra_can_skip_next", bl);
            intent.putExtra("extra_can_skip_prev", bl2);
        }
        this.zzPB.startService(intent);
    }

    private void zztQ() {
        if (this.zzati.getCastMediaOptions().getNotificationOptions() == null) {
            return;
        }
        Intent intent = new Intent(this.zzPB, MediaNotificationService.class);
        intent.setPackage(this.zzPB.getPackageName());
        intent.setAction("com.google.android.gms.cast.framework.action.UPDATE_NOTIFICATION");
        this.zzPB.stopService(intent);
    }

    private void zztR() {
        if (!this.zzati.getEnableReconnectionService()) {
            return;
        }
        Intent intent = new Intent(this.zzPB, ReconnectionService.class);
        intent.setPackage(this.zzPB.getPackageName());
        this.zzPB.startService(intent);
    }

    private void zztS() {
        if (!this.zzati.getEnableReconnectionService()) {
            return;
        }
        Intent intent = new Intent(this.zzPB, ReconnectionService.class);
        intent.setPackage(this.zzPB.getPackageName());
        this.zzPB.stopService(intent);
    }

    private PendingIntent zztT() {
        if (this.zzatj == null) {
            return null;
        }
        Intent intent = new Intent();
        intent.setComponent(this.zzatj);
        return PendingIntent.getActivity((Context)this.zzPB, (int)0, (Intent)intent, (int)0x8000000);
    }
}

