/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentTransaction;
import android.view.View;
import com.google.android.gms.R;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaTrack;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.TracksChooserDialogFragment;
import com.google.android.gms.cast.framework.media.uicontroller.UIController;
import java.lang.ref.WeakReference;
import java.util.List;

public class zzxl
extends UIController {
    private final View mView;
    private final WeakReference<Activity> zzatx;
    private final String zzaty;
    private final String zzatz;
    private final View.OnClickListener zzatA;

    public zzxl(View view, Activity activity) {
        this.mView = view;
        this.zzaty = activity.getString(R.string.cast_closed_captions);
        this.zzatz = activity.getString(R.string.cast_closed_captions_unavailable);
        this.zzatx = new WeakReference<Activity>(activity);
        this.zzatA = new View.OnClickListener(){

            public void onClick(View view) {
                Activity activity = (Activity)zzxl.this.zzatx.get();
                if (activity == null) {
                    return;
                }
                RemoteMediaClient remoteMediaClient = zzxl.this.getRemoteMediaClient();
                if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession()) {
                    return;
                }
                if (activity instanceof FragmentActivity) {
                    FragmentActivity fragmentActivity = (FragmentActivity)activity;
                    FragmentTransaction fragmentTransaction = fragmentActivity.getSupportFragmentManager().beginTransaction();
                    Fragment fragment = fragmentActivity.getSupportFragmentManager().findFragmentByTag("TRACKS_CHOOSER_DIALOG_TAG");
                    if (fragment != null) {
                        fragmentTransaction.remove(fragment);
                    }
                    fragmentTransaction.addToBackStack(null);
                    MediaInfo mediaInfo = remoteMediaClient.getMediaInfo();
                    long[] lArray = remoteMediaClient.getMediaStatus().getActiveTrackIds();
                    TracksChooserDialogFragment tracksChooserDialogFragment = TracksChooserDialogFragment.newInstance(mediaInfo, lArray);
                    if (tracksChooserDialogFragment != null) {
                        tracksChooserDialogFragment.show(fragmentTransaction, "TRACKS_CHOOSER_DIALOG_TAG");
                    }
                }
            }
        };
    }

    @Override
    public void onSessionConnected(CastSession castSession) {
        super.onSessionConnected(castSession);
        this.mView.setOnClickListener(this.zzatA);
        this.zztW();
    }

    @Override
    public void onSessionEnded() {
        this.mView.setOnClickListener(null);
        super.onSessionEnded();
    }

    @Override
    public void onMediaStatusUpdated() {
        this.zztW();
    }

    @Override
    public void onSendingRemoteMediaRequest() {
        this.mView.setEnabled(false);
    }

    private void zztW() {
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession() || !this.zzc(remoteMediaClient.getMediaInfo()) || remoteMediaClient.isPlayingAd()) {
            this.mView.setEnabled(false);
            this.mView.setContentDescription((CharSequence)this.zzatz);
        } else {
            this.mView.setEnabled(true);
            this.mView.setContentDescription((CharSequence)this.zzaty);
        }
    }

    private boolean zzc(MediaInfo mediaInfo) {
        if (mediaInfo == null) {
            return false;
        }
        List list = mediaInfo.getMediaTracks();
        if (list == null || list.isEmpty()) {
            return false;
        }
        for (MediaTrack mediaTrack : list) {
            if (mediaTrack.getType() != 2 && mediaTrack.getType() != 1) continue;
            return true;
        }
        return false;
    }
}

