/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import com.google.android.gms.cast.ApplicationMetadata;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.LaunchOptions;
import com.google.android.gms.cast.framework.CastOptions;
import com.google.android.gms.cast.framework.Session;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.zzf;
import com.google.android.gms.cast.framework.zzh;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzwv;
import com.google.android.gms.internal.zzwx;
import com.google.android.gms.internal.zzxj;
import com.google.android.gms.internal.zzyz;
import com.google.android.gms.internal.zzza;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class CastSession
extends Session {
    private static final zzyz zzapV = new zzyz("CastSession");
    private final Context zzPB;
    private final Set<Cast.Listener> zzaqj = new HashSet<Cast.Listener>();
    private final zzh zzaqk;
    private final CastOptions zzaqa;
    private final Cast.CastApi zzaql;
    private final zzwx zzaqm;
    private final zzxj zzaqn;
    private GoogleApiClient zzanE;
    private RemoteMediaClient zzaqo;
    private CastDevice zzaqp;
    private Cast.ApplicationConnectionResult zzaqq;

    public CastSession(Context context, String string2, String string3, CastOptions castOptions, Cast.CastApi castApi, zzwx zzwx2, zzxj zzxj2) {
        super(context, string2, string3);
        this.zzPB = context.getApplicationContext();
        this.zzaqa = castOptions;
        this.zzaql = castApi;
        this.zzaqm = zzwx2;
        this.zzaqn = zzxj2;
        this.zzaqk = zzwv.zza(context, castOptions, this.zzsN(), new zzb());
    }

    @Override
    protected void start(Bundle bundle) {
        this.zzl(bundle);
    }

    @Override
    protected void resume(Bundle bundle) {
        this.zzl(bundle);
    }

    @Override
    protected void end(boolean bl) {
        try {
            this.zzaqk.zzb(bl, 0);
        }
        catch (RemoteException remoteException) {
            zzapV.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"disconnectFromDevice", zzh.class.getSimpleName()});
        }
        this.notifySessionEnded(0);
    }

    public RemoteMediaClient getRemoteMediaClient() {
        zzac.zzdj((String)"Must be called from the main thread.");
        return this.zzaqo;
    }

    public CastDevice getCastDevice() {
        zzac.zzdj((String)"Must be called from the main thread.");
        return this.zzaqp;
    }

    public void requestStatus() throws IOException, IllegalStateException {
        zzac.zzdj((String)"Must be called from the main thread.");
        if (this.zzanE != null) {
            this.zzaql.requestStatus(this.zzanE);
        }
    }

    public int getActiveInputState() throws IllegalStateException {
        zzac.zzdj((String)"Must be called from the main thread.");
        return this.zzanE != null ? this.zzaql.getActiveInputState(this.zzanE) : -1;
    }

    public int getStandbyState() throws IllegalStateException {
        zzac.zzdj((String)"Must be called from the main thread.");
        return this.zzanE != null ? this.zzaql.getStandbyState(this.zzanE) : -1;
    }

    public ApplicationMetadata getApplicationMetadata() throws IllegalStateException {
        zzac.zzdj((String)"Must be called from the main thread.");
        return this.zzanE != null ? this.zzaql.getApplicationMetadata(this.zzanE) : null;
    }

    public String getApplicationStatus() throws IllegalStateException {
        zzac.zzdj((String)"Must be called from the main thread.");
        return this.zzanE != null ? this.zzaql.getApplicationStatus(this.zzanE) : null;
    }

    public void setVolume(double d) throws IOException {
        zzac.zzdj((String)"Must be called from the main thread.");
        if (this.zzanE != null) {
            this.zzaql.setVolume(this.zzanE, d);
        }
    }

    public double getVolume() throws IllegalStateException {
        zzac.zzdj((String)"Must be called from the main thread.");
        return this.zzanE != null ? this.zzaql.getVolume(this.zzanE) : 0.0;
    }

    public void setMute(boolean bl) throws IOException, IllegalStateException {
        zzac.zzdj((String)"Must be called from the main thread.");
        if (this.zzanE != null) {
            this.zzaql.setMute(this.zzanE, bl);
        }
    }

    public boolean isMute() throws IllegalStateException {
        zzac.zzdj((String)"Must be called from the main thread.");
        return this.zzanE != null ? this.zzaql.isMute(this.zzanE) : false;
    }

    public Cast.ApplicationConnectionResult getApplicationConnectionResult() {
        zzac.zzdj((String)"Must be called from the main thread.");
        return this.zzaqq;
    }

    public void setMessageReceivedCallbacks(String string2, Cast.MessageReceivedCallback messageReceivedCallback) throws IOException, IllegalStateException {
        zzac.zzdj((String)"Must be called from the main thread.");
        if (this.zzanE != null) {
            this.zzaql.setMessageReceivedCallbacks(this.zzanE, string2, messageReceivedCallback);
        }
    }

    public void removeMessageReceivedCallbacks(String string2) throws IOException, IllegalArgumentException {
        zzac.zzdj((String)"Must be called from the main thread.");
        if (this.zzanE != null) {
            this.zzaql.removeMessageReceivedCallbacks(this.zzanE, string2);
        }
    }

    public PendingResult<Status> sendMessage(String string2, String string3) {
        zzac.zzdj((String)"Must be called from the main thread.");
        return this.zzanE != null ? this.zzaql.sendMessage(this.zzanE, string2, string3) : null;
    }

    public void addCastListener(Cast.Listener listener) {
        zzac.zzdj((String)"Must be called from the main thread.");
        if (listener != null) {
            this.zzaqj.add(listener);
        }
    }

    public void removeCastListener(Cast.Listener listener) {
        zzac.zzdj((String)"Must be called from the main thread.");
        if (listener != null) {
            this.zzaqj.remove(listener);
        }
    }

    private void zzl(Bundle bundle) {
        this.zzaqp = CastDevice.getFromBundle((Bundle)bundle);
        if (this.zzaqp == null) {
            if (this.isResuming()) {
                this.notifyFailedToResumeSession(8);
            } else {
                this.notifyFailedToStartSession(8);
            }
            return;
        }
        if (this.zzanE != null) {
            this.zzanE.disconnect();
            this.zzanE = null;
        }
        zzapV.zzb("Acquiring a connection to Google Play Services for %s", new Object[]{this.zzaqp});
        zzd zzd2 = new zzd();
        this.zzanE = this.zzaqm.zza(this.zzPB, this.zzaqp, this.zzaqa, new zzc(), zzd2, zzd2);
        this.zzanE.connect();
    }

    private void zzbY(int n) {
        this.zzaqn.zzce(n);
        if (this.zzanE != null) {
            this.zzanE.disconnect();
            this.zzanE = null;
        }
        this.zzaqp = null;
        if (this.zzaqo != null) {
            try {
                this.zzaqo.zzd(null);
            }
            catch (IOException iOException) {
                zzapV.zza((Throwable)iOException, "Exception when setting GoogleApiClient.", new Object[0]);
            }
            this.zzaqo = null;
        }
        this.zzaqq = null;
    }

    @Override
    public long getSessionRemainingTimeMs() {
        zzac.zzdj((String)"Must be called from the main thread.");
        if (this.zzaqo == null) {
            return 0L;
        }
        return this.zzaqo.getStreamDuration() - this.zzaqo.getApproximateStreamPosition();
    }

    private class zzb
    extends zzf.zza {
        private zzb() {
        }

        @Override
        public int zzsB() {
            return 10298208;
        }

        @Override
        public void zzz(String string, String string2) {
            CastSession.this.zzaql.joinApplication(CastSession.this.zzanE, string, string2).setResultCallback((ResultCallback)new zza("joinApplication"));
        }

        @Override
        public void zza(String string, LaunchOptions launchOptions) {
            CastSession.this.zzaql.launchApplication(CastSession.this.zzanE, string, launchOptions).setResultCallback((ResultCallback)new zza("launchApplication"));
        }

        @Override
        public void zzcK(String string) {
            CastSession.this.zzaql.stopApplication(CastSession.this.zzanE, string);
        }

        @Override
        public void zzbY(int n) {
            CastSession.this.zzbY(n);
        }
    }

    private class zza
    implements ResultCallback<Cast.ApplicationConnectionResult> {
        String zzaqr;

        zza(String string) {
            this.zzaqr = string;
        }

        public void zza(@NonNull Cast.ApplicationConnectionResult applicationConnectionResult) {
            block5: {
                CastSession.this.zzaqq = applicationConnectionResult;
                try {
                    if (applicationConnectionResult.getStatus().isSuccess()) {
                        zzapV.zzb("%s() -> success result", new Object[]{this.zzaqr});
                        CastSession.this.zzaqo = new RemoteMediaClient(new zzza(null), CastSession.this.zzaql);
                        try {
                            CastSession.this.zzaqo.zzd(CastSession.this.zzanE);
                            CastSession.this.zzaqo.zztF();
                            CastSession.this.zzaqo.requestStatus();
                            CastSession.this.zzaqn.zza(CastSession.this.zzaqo, CastSession.this.getCastDevice());
                        }
                        catch (IOException iOException) {
                            zzapV.zza((Throwable)iOException, "Exception when setting GoogleApiClient.", new Object[0]);
                            CastSession.this.zzaqo = null;
                        }
                        CastSession.this.zzaqk.zza(applicationConnectionResult.getApplicationMetadata(), applicationConnectionResult.getApplicationStatus(), applicationConnectionResult.getSessionId(), applicationConnectionResult.getWasLaunched());
                        break block5;
                    }
                    zzapV.zzb("%s() -> failure result", new Object[]{this.zzaqr});
                    CastSession.this.zzaqk.zzbZ(applicationConnectionResult.getStatus().getStatusCode());
                }
                catch (RemoteException remoteException) {
                    zzapV.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"methods", zzh.class.getSimpleName()});
                }
            }
        }

        public /* synthetic */ void onResult(@NonNull Result result) {
            this.zza((Cast.ApplicationConnectionResult)result);
        }
    }

    private class zzc
    extends Cast.Listener {
        private zzc() {
        }

        public void onApplicationDisconnected(int n) {
            CastSession.this.zzbY(n);
            CastSession.this.notifySessionEnded(n);
            HashSet hashSet = new HashSet(CastSession.this.zzaqj);
            for (Cast.Listener listener : hashSet) {
                listener.onApplicationDisconnected(n);
            }
        }

        public void onApplicationStatusChanged() {
            HashSet hashSet = new HashSet(CastSession.this.zzaqj);
            for (Cast.Listener listener : hashSet) {
                listener.onApplicationStatusChanged();
            }
        }

        public void onApplicationMetadataChanged(ApplicationMetadata applicationMetadata) {
            HashSet hashSet = new HashSet(CastSession.this.zzaqj);
            for (Cast.Listener listener : hashSet) {
                listener.onApplicationMetadataChanged(applicationMetadata);
            }
        }

        public void onActiveInputStateChanged(int n) {
            HashSet hashSet = new HashSet(CastSession.this.zzaqj);
            for (Cast.Listener listener : hashSet) {
                listener.onActiveInputStateChanged(n);
            }
        }

        public void onStandbyStateChanged(int n) {
            HashSet hashSet = new HashSet(CastSession.this.zzaqj);
            for (Cast.Listener listener : hashSet) {
                listener.onStandbyStateChanged(n);
            }
        }

        public void onVolumeChanged() {
            HashSet hashSet = new HashSet(CastSession.this.zzaqj);
            for (Cast.Listener listener : hashSet) {
                listener.onVolumeChanged();
            }
        }
    }

    private class zzd
    implements GoogleApiClient.ConnectionCallbacks,
    GoogleApiClient.OnConnectionFailedListener {
        private zzd() {
        }

        public void onConnected(Bundle bundle) {
            try {
                if (CastSession.this.zzaqo != null) {
                    try {
                        CastSession.this.zzaqo.zztF();
                        CastSession.this.zzaqo.requestStatus();
                    }
                    catch (IOException iOException) {
                        zzapV.zza((Throwable)iOException, "Exception when setting GoogleApiClient.", new Object[0]);
                        CastSession.this.zzaqo = null;
                    }
                }
                CastSession.this.zzaqk.onConnected(bundle);
            }
            catch (RemoteException remoteException) {
                zzapV.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"onConnected", zzh.class.getSimpleName()});
            }
        }

        public void onConnectionSuspended(int n) {
            try {
                CastSession.this.zzaqk.onConnectionSuspended(n);
            }
            catch (RemoteException remoteException) {
                zzapV.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"onConnectionSuspended", zzh.class.getSimpleName()});
            }
        }

        public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            try {
                CastSession.this.zzaqk.onConnectionFailed(connectionResult);
            }
            catch (RemoteException remoteException) {
                zzapV.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"onConnectionFailed", zzh.class.getSimpleName()});
            }
        }
    }
}

