/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.internal.featurehighlight;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.Nullable;
import android.support.v4.view.GestureDetectorCompat;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.R;
import com.google.android.gms.cast.framework.internal.featurehighlight.zzb;
import com.google.android.gms.cast.framework.internal.featurehighlight.zzc;
import com.google.android.gms.cast.framework.internal.featurehighlight.zzd;
import com.google.android.gms.cast.framework.internal.featurehighlight.zze;
import com.google.android.gms.internal.zzbli;
import com.google.android.gms.internal.zzbln;

public final class zza
extends ViewGroup {
    private final int[] zzaqZ = new int[2];
    private final Rect zzara = new Rect();
    private final Rect zzarb = new Rect();
    private final zze zzarc;
    private final zzc zzard;
    private zzb zzare;
    private View targetView;
    @Nullable
    private View zzarf;
    @Nullable
    private Animator zzarg;
    private final zzd zzarh;
    private final GestureDetectorCompat zzari;
    @Nullable
    private GestureDetectorCompat zzarj;
    private zza zzark;
    private boolean zzarl;

    public zza(Context context) {
        super(context);
        this.setId(R.id.cast_featurehighlight_view);
        this.setWillNotDraw(false);
        this.zzard = new zzc(context);
        this.zzard.setCallback((Drawable.Callback)this);
        this.zzarc = new zze(context);
        this.zzarc.setCallback((Drawable.Callback)this);
        this.zzarh = new zzd(this);
        GestureDetector.SimpleOnGestureListener simpleOnGestureListener = new GestureDetector.SimpleOnGestureListener(){

            public boolean onSingleTapUp(MotionEvent motionEvent) {
                float f;
                float f2 = motionEvent.getX();
                if (!zza.this.zzc(f2, f = motionEvent.getY()) || !zza.this.zzarc.zzd(f2, f)) {
                    zza.this.zzark.dismiss();
                }
                return true;
            }
        };
        this.zzari = new GestureDetectorCompat(context, (GestureDetector.OnGestureListener)simpleOnGestureListener);
        this.zzari.setIsLongpressEnabled(false);
        this.setVisibility(8);
    }

    public void zza(zzb zzb2) {
        this.zzare = zzbln.zzw(zzb2);
        this.addView(zzb2.asView(), 0);
    }

    public void zza(final View view, @Nullable View view2, final boolean bl, final zza zza2) {
        this.targetView = zzbln.zzw(view);
        this.zzarf = view2;
        this.zzark = zzbln.zzw(zza2);
        GestureDetector.SimpleOnGestureListener simpleOnGestureListener = new GestureDetector.SimpleOnGestureListener(this){

            public boolean onSingleTapUp(MotionEvent motionEvent) {
                if (view.getParent() != null) {
                    view.performClick();
                }
                if (bl) {
                    zza2.zztc();
                }
                return true;
            }
        };
        this.zzarj = new GestureDetectorCompat(this.getContext(), (GestureDetector.OnGestureListener)simpleOnGestureListener);
        this.zzarj.setIsLongpressEnabled(false);
        this.setVisibility(4);
    }

    protected void onMeasure(int n, int n2) {
        int n3 = View.MeasureSpec.getSize((int)n);
        int n4 = View.MeasureSpec.getSize((int)n2);
        this.setMeasuredDimension(zza.resolveSize((int)n3, (int)n), zza.resolveSize((int)n4, (int)n2));
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        if (this.targetView == null) {
            throw new IllegalStateException("Target view must be set before layout");
        }
        if (this.targetView.getParent() != null) {
            this.zza(this.zzaqZ, this.targetView);
        }
        this.zzara.set(this.zzaqZ[0], this.zzaqZ[1], this.zzaqZ[0] + this.targetView.getWidth(), this.zzaqZ[1] + this.targetView.getHeight());
        if (this.zzarf != null) {
            this.zza(this.zzaqZ, this.zzarf);
            this.zzarb.set(this.zzaqZ[0], this.zzaqZ[1], this.zzaqZ[0] + this.zzarf.getMeasuredWidth(), this.zzaqZ[1] + this.zzarf.getMeasuredHeight());
        } else {
            this.zzarb.set(n, n2, n3, n4);
        }
        this.zzarc.setBounds(this.zzarb);
        this.zzard.setBounds(this.zzarb);
        this.zzarh.zza(this.zzara, this.zzarb);
    }

    protected void onDraw(Canvas canvas) {
        canvas.save();
        if (this.zzarf != null) {
            canvas.clipRect(this.zzarb);
        }
        this.zzarc.draw(canvas);
        this.zzard.draw(canvas);
        if (this.targetView != null) {
            if (this.targetView.getParent() != null) {
                Bitmap bitmap = Bitmap.createBitmap((int)this.targetView.getWidth(), (int)this.targetView.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas canvas2 = new Canvas(bitmap);
                this.targetView.draw(canvas2);
                int n = this.zzarc.getColor();
                int n2 = Color.red((int)n);
                int n3 = Color.green((int)n);
                int n4 = Color.blue((int)n);
                for (int i = 0; i < bitmap.getHeight(); ++i) {
                    for (int j = 0; j < bitmap.getWidth(); ++j) {
                        int n5 = bitmap.getPixel(j, i);
                        if (Color.alpha((int)n5) == 0) continue;
                        n5 = Color.argb((int)Color.alpha((int)n5), (int)n2, (int)n3, (int)n4);
                        bitmap.setPixel(j, i, n5);
                    }
                }
                canvas.drawBitmap(bitmap, (float)this.zzara.left, (float)this.zzara.top, null);
            }
        } else {
            throw new IllegalStateException("Neither target view nor drawable was set");
        }
        canvas.restore();
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new ViewGroup.MarginLayoutParams(this.getContext(), attributeSet);
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new ViewGroup.MarginLayoutParams(-2, -2);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return new ViewGroup.MarginLayoutParams(layoutParams);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof ViewGroup.MarginLayoutParams;
    }

    protected boolean verifyDrawable(Drawable drawable) {
        return super.verifyDrawable(drawable) || drawable == this.zzarc || drawable == this.zzard || drawable == null;
    }

    public void zzh(final @Nullable Runnable runnable) {
        this.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

            public void onLayoutChange(View view, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
                if (runnable != null) {
                    runnable.run();
                }
                zza.this.zztf();
                zza.this.removeOnLayoutChangeListener(this);
            }
        });
    }

    public void zztf() {
        if (this.targetView == null) {
            throw new IllegalStateException("Target view must be set before animation");
        }
        this.setVisibility(0);
        this.zza(this.zztk());
    }

    public void zzi(@Nullable Runnable runnable) {
        this.zza(this.zzl(runnable));
    }

    public void zzj(@Nullable Runnable runnable) {
        this.zza(this.zzk(runnable));
    }

    public void zzca(@ColorInt int n) {
        this.zzarc.setColor(n);
    }

    @Nullable
    Drawable zztg() {
        return null;
    }

    View zzth() {
        return this.zzare.asView();
    }

    zze zzti() {
        return this.zzarc;
    }

    zzc zztj() {
        return this.zzard;
    }

    private void zza(int[] nArray, View view) {
        this.getLocationInWindow(nArray);
        int n = nArray[0];
        int n2 = nArray[1];
        view.getLocationInWindow(nArray);
        nArray[0] = nArray[0] - n;
        nArray[1] = nArray[1] - n2;
    }

    private void zza(Animator animator) {
        if (this.zzarg != null) {
            this.zzarg.cancel();
        }
        this.zzarg = animator;
        this.zzarg.start();
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        int n = motionEvent.getActionMasked();
        if (n == 0) {
            this.zzarl = this.zzara.contains((int)motionEvent.getX(), (int)motionEvent.getY());
        }
        if (this.zzarl) {
            MotionEvent motionEvent2 = motionEvent;
            if (this.zzarj != null) {
                this.zzarj.onTouchEvent(motionEvent);
                if (n == 1) {
                    motionEvent2 = MotionEvent.obtain((MotionEvent)motionEvent);
                    motionEvent2.setAction(3);
                }
            }
            if (this.targetView.getParent() != null) {
                this.targetView.onTouchEvent(motionEvent2);
            }
        } else {
            this.zzari.onTouchEvent(motionEvent);
        }
        return true;
    }

    private boolean zzc(float f, float f2) {
        return this.zzarb.contains(Math.round(f), Math.round(f2));
    }

    private Animator zztk() {
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)this.zzare.asView(), (String)"alpha", (float[])new float[]{0.0f, 1.0f}).setDuration(350L);
        objectAnimator.setInterpolator((TimeInterpolator)zzbli.zzUO());
        float f = this.zzara.exactCenterX() - this.zzarc.getCenterX();
        float f2 = this.zzara.exactCenterY() - this.zzarc.getCenterY();
        Animator animator = this.zzarc.zze(f, f2);
        Animator animator2 = this.zzard.zztk();
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{objectAnimator, animator, animator2});
        animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animator) {
                zza.this.zzarg = zza.this.zztl();
                zza.this.zzarg.start();
            }
        });
        return animatorSet;
    }

    private Animator zzk(final @Nullable Runnable runnable) {
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)this.zzare.asView(), (String)"alpha", (float[])new float[]{0.0f}).setDuration(200L);
        objectAnimator.setInterpolator((TimeInterpolator)zzbli.zzUP());
        Animator animator = this.zzarc.zztm();
        Animator animator2 = this.zzard.zztm();
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{objectAnimator, animator, animator2});
        animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animator) {
                zza.this.setVisibility(8);
                zza.this.zzarg = null;
                if (runnable != null) {
                    runnable.run();
                }
            }
        });
        return animatorSet;
    }

    private Animator zzl(final @Nullable Runnable runnable) {
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)this.zzare.asView(), (String)"alpha", (float[])new float[]{0.0f}).setDuration(200L);
        objectAnimator.setInterpolator((TimeInterpolator)zzbli.zzUP());
        float f = this.zzara.exactCenterX() - this.zzarc.getCenterX();
        float f2 = this.zzara.exactCenterY() - this.zzarc.getCenterY();
        Animator animator = this.zzarc.zzf(f, f2);
        Animator animator2 = this.zzard.zztn();
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{objectAnimator, animator, animator2});
        animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animator) {
                zza.this.setVisibility(8);
                zza.this.zzarg = null;
                if (runnable != null) {
                    runnable.run();
                }
            }
        });
        return animatorSet;
    }

    private Animator zztl() {
        return this.zzard.zztl();
    }

    public static interface zza {
        public void zztc();

        public void dismiss();
    }
}

