/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.view.View;
import android.widget.ImageView;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.media.CastMediaOptions;
import com.google.android.gms.cast.framework.media.ImageHints;
import com.google.android.gms.cast.framework.media.ImagePicker;
import com.google.android.gms.cast.framework.media.MediaUtils;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.uicontroller.UIController;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.internal.zzxf;

public class zzxn
extends UIController {
    private final ImageView zzatC;
    private final ImageHints zzasZ;
    private final Bitmap zzatG;
    private final View zzatH;
    private final ImagePicker zzarP;
    private final zzxf zzatE;

    public zzxn(ImageView imageView, Context context, @NonNull ImageHints imageHints, int n, View view) {
        this.zzatC = imageView;
        this.zzasZ = imageHints;
        this.zzatG = n != 0 ? BitmapFactory.decodeResource((Resources)context.getResources(), (int)n) : null;
        this.zzatH = view;
        CastMediaOptions castMediaOptions = CastContext.getSharedInstance(context).getCastOptions().getCastMediaOptions();
        this.zzarP = castMediaOptions != null ? castMediaOptions.getImagePicker() : null;
        this.zzatE = new zzxf(context.getApplicationContext());
    }

    @Override
    public void onSessionConnected(CastSession castSession) {
        super.onSessionConnected(castSession);
        this.zzatE.zza(new zzxf.zza(){

            @Override
            public void zzc(Bitmap bitmap) {
                if (bitmap != null) {
                    if (zzxn.this.zzatH != null) {
                        zzxn.this.zzatH.setVisibility(4);
                    }
                    zzxn.this.zzatC.setVisibility(0);
                    zzxn.this.zzatC.setImageBitmap(bitmap);
                }
            }
        });
        this.zztW();
        this.zztV();
    }

    @Override
    public void onSessionEnded() {
        this.zzatE.clear();
        this.zztW();
        super.onSessionEnded();
    }

    @Override
    public void onMediaStatusUpdated() {
        this.zztV();
    }

    private void zztV() {
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession()) {
            this.zztW();
            return;
        }
        Uri uri = this.zzd(remoteMediaClient.getMediaInfo());
        if (uri == null) {
            this.zztW();
        } else {
            this.zzatE.zzo(uri);
        }
    }

    private Uri zzd(MediaInfo mediaInfo) {
        WebImage webImage;
        if (mediaInfo == null) {
            return null;
        }
        if (this.zzarP != null && (webImage = this.zzarP.onPickImage(mediaInfo.getMetadata(), this.zzasZ)) != null && webImage.getUrl() != null) {
            return webImage.getUrl();
        }
        return MediaUtils.getImageUri(mediaInfo, 0);
    }

    private void zztW() {
        if (this.zzatH != null) {
            this.zzatH.setVisibility(0);
            this.zzatC.setVisibility(4);
        }
        if (this.zzatG != null) {
            this.zzatC.setImageBitmap(this.zzatG);
        }
    }
}

