/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.preference.PreferenceManager;
import android.support.annotation.ColorRes;
import android.support.annotation.DimenRes;
import android.support.annotation.StringRes;
import android.support.v7.app.MediaRouteButton;
import android.view.MenuItem;
import android.view.View;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.internal.zzawe;
import com.google.android.gms.internal.zzawi;

public interface IntroductoryOverlay {
    public void show();

    public void remove();

    public static class Builder {
        private Activity mActivity;
        private View zzasn;
        private int zzaso;
        private String zzasp;
        private OnOverlayDismissedListener zzasq;
        private boolean zzasr;
        private float zzass;
        private String zzast;

        @TargetApi(value=11)
        public Builder(Activity activity, MenuItem menuItem) {
            this.mActivity = (Activity)zzbr.zzu((Object)activity);
            this.zzasn = ((MenuItem)zzbr.zzu((Object)menuItem)).getActionView();
        }

        public Builder(Activity activity, MediaRouteButton mediaRouteButton) {
            this.mActivity = (Activity)zzbr.zzu((Object)activity);
            this.zzasn = (View)zzbr.zzu((Object)mediaRouteButton);
        }

        public Builder setOverlayColor(@ColorRes int n) {
            this.zzaso = this.mActivity.getResources().getColor(n);
            return this;
        }

        public Builder setTitleText(String string2) {
            this.zzasp = string2;
            return this;
        }

        public Builder setTitleText(@StringRes int n) {
            this.zzasp = this.mActivity.getResources().getString(n);
            return this;
        }

        public Builder setOnOverlayDismissedListener(OnOverlayDismissedListener onOverlayDismissedListener) {
            this.zzasq = onOverlayDismissedListener;
            return this;
        }

        public Builder setSingleTime() {
            this.zzasr = true;
            return this;
        }

        public Builder setFocusRadiusId(@DimenRes int n) {
            this.zzass = this.mActivity.getResources().getDimension(n);
            return this;
        }

        public Builder setFocusRadius(float f) {
            this.zzass = f;
            return this;
        }

        public Builder setButtonText(String string2) {
            this.zzast = string2;
            return this;
        }

        public Builder setButtonText(@StringRes int n) {
            this.zzast = this.mActivity.getResources().getString(n);
            return this;
        }

        public final Activity getActivity() {
            return this.mActivity;
        }

        public final View zzny() {
            return this.zzasn;
        }

        public final OnOverlayDismissedListener zznz() {
            return this.zzasq;
        }

        public final int zznA() {
            return this.zzaso;
        }

        public final boolean zznB() {
            return this.zzasr;
        }

        public final String zznC() {
            return this.zzasp;
        }

        public final String zznD() {
            return this.zzast;
        }

        public final float zznE() {
            return this.zzass;
        }

        public IntroductoryOverlay build() {
            if (zzs.zzrY()) {
                return new zzawe(this);
            }
            return new zzawi(this);
        }
    }

    public static final class zza {
        public static void zzal(Context context) {
            PreferenceManager.getDefaultSharedPreferences((Context)context).edit().putBoolean("googlecast-introOverlayShown", true).apply();
        }

        public static boolean zzam(Context context) {
            return PreferenceManager.getDefaultSharedPreferences((Context)context).getBoolean("googlecast-introOverlayShown", false);
        }
    }

    public static interface OnOverlayDismissedListener {
        public void onOverlayDismissed();
    }
}

