/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.os.RemoteException;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.CastStateListener;
import com.google.android.gms.cast.framework.Session;
import com.google.android.gms.cast.framework.SessionManagerListener;
import com.google.android.gms.cast.framework.zzaf;
import com.google.android.gms.cast.framework.zzd;
import com.google.android.gms.cast.framework.zzw;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.internal.zzbaa;

public class SessionManager {
    private static final zzbaa zzarM = new zzbaa("SessionManager");
    private final zzw zzasy;

    public SessionManager(zzw zzw2) {
        this.zzasy = zzw2;
    }

    public Session getCurrentSession() {
        zzbr.zzcz((String)"Must be called from the main thread.");
        try {
            return (Session)zzn.zzE((IObjectWrapper)this.zzasy.zznw());
        }
        catch (RemoteException remoteException) {
            zzarM.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getWrappedCurrentSession", zzw.class.getSimpleName()});
            return null;
        }
    }

    public CastSession getCurrentCastSession() {
        zzbr.zzcz((String)"Must be called from the main thread.");
        Session session = this.getCurrentSession();
        if (session != null && session instanceof CastSession) {
            return (CastSession)session;
        }
        return null;
    }

    public void endCurrentSession(boolean bl) {
        zzbr.zzcz((String)"Must be called from the main thread.");
        try {
            this.zzasy.zzb(true, bl);
            return;
        }
        catch (RemoteException remoteException) {
            zzarM.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"endCurrentSession", zzw.class.getSimpleName()});
            return;
        }
    }

    public void addSessionManagerListener(SessionManagerListener<Session> sessionManagerListener) throws NullPointerException {
        zzbr.zzcz((String)"Must be called from the main thread.");
        this.addSessionManagerListener(sessionManagerListener, Session.class);
    }

    public <T extends Session> void addSessionManagerListener(SessionManagerListener<T> sessionManagerListener, Class<T> clazz) throws NullPointerException {
        zzbr.zzu(sessionManagerListener);
        zzbr.zzu(clazz);
        zzbr.zzcz((String)"Must be called from the main thread.");
        try {
            this.zzasy.zza(new zzaf<T>(sessionManagerListener, clazz));
            return;
        }
        catch (RemoteException remoteException) {
            zzarM.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"addSessionManagerListener", zzw.class.getSimpleName()});
            return;
        }
    }

    public void removeSessionManagerListener(SessionManagerListener<Session> sessionManagerListener) {
        zzbr.zzcz((String)"Must be called from the main thread.");
        this.removeSessionManagerListener(sessionManagerListener, Session.class);
    }

    public <T extends Session> void removeSessionManagerListener(SessionManagerListener<T> sessionManagerListener, Class clazz) {
        zzbr.zzu((Object)clazz);
        zzbr.zzcz((String)"Must be called from the main thread.");
        if (sessionManagerListener == null) {
            return;
        }
        try {
            this.zzasy.zzb(new zzaf<T>(sessionManagerListener, clazz));
            return;
        }
        catch (RemoteException remoteException) {
            zzarM.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"removeSessionManagerListener", zzw.class.getSimpleName()});
            return;
        }
    }

    final int getCastState() {
        try {
            return this.zzasy.getCastState();
        }
        catch (RemoteException remoteException) {
            zzarM.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"addCastStateListener", zzw.class.getSimpleName()});
            return 1;
        }
    }

    final void addCastStateListener(CastStateListener castStateListener) throws NullPointerException {
        zzbr.zzu((Object)castStateListener);
        try {
            this.zzasy.zza(new zzd(castStateListener));
            return;
        }
        catch (RemoteException remoteException) {
            zzarM.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"addCastStateListener", zzw.class.getSimpleName()});
            return;
        }
    }

    final void removeCastStateListener(CastStateListener castStateListener) {
        if (castStateListener == null) {
            return;
        }
        try {
            this.zzasy.zzb(new zzd(castStateListener));
            return;
        }
        catch (RemoteException remoteException) {
            zzarM.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"removeCastStateListener", zzw.class.getSimpleName()});
            return;
        }
    }

    public final IObjectWrapper zznn() {
        try {
            return this.zzasy.zzns();
        }
        catch (RemoteException remoteException) {
            zzarM.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getWrappedThis", zzw.class.getSimpleName()});
            return null;
        }
    }
}

