/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.internal.featurehighlight;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.Nullable;
import android.support.v4.view.GestureDetectorCompat;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.R;
import com.google.android.gms.cast.framework.internal.featurehighlight.zzb;
import com.google.android.gms.cast.framework.internal.featurehighlight.zzc;
import com.google.android.gms.cast.framework.internal.featurehighlight.zzd;
import com.google.android.gms.cast.framework.internal.featurehighlight.zze;
import com.google.android.gms.cast.framework.internal.featurehighlight.zzf;
import com.google.android.gms.cast.framework.internal.featurehighlight.zzg;
import com.google.android.gms.cast.framework.internal.featurehighlight.zzh;
import com.google.android.gms.cast.framework.internal.featurehighlight.zzi;
import com.google.android.gms.cast.framework.internal.featurehighlight.zzj;
import com.google.android.gms.cast.framework.internal.featurehighlight.zzk;
import com.google.android.gms.cast.framework.internal.featurehighlight.zzl;
import com.google.android.gms.internal.ix;
import com.google.android.gms.internal.jg;
import com.google.android.gms.internal.jw;

public final class zza
extends ViewGroup {
    private final int[] zzasR = new int[2];
    private final Rect zzasS = new Rect();
    private final Rect zzasT = new Rect();
    private final zzl zzasU;
    private final zzj zzasV;
    private zzi zzasW;
    private View targetView;
    @Nullable
    private View zzasX;
    @Nullable
    private Animator zzasY;
    private final zzk zzasZ;
    private final GestureDetectorCompat zzata;
    @Nullable
    private GestureDetectorCompat zzatb;
    private zzh zzatc;
    private boolean zzatd;

    public zza(Context context) {
        super(context);
        this.setId(R.id.cast_featurehighlight_view);
        this.setWillNotDraw(false);
        this.zzasV = new zzj(context);
        this.zzasV.setCallback((Drawable.Callback)this);
        this.zzasU = new zzl(context);
        this.zzasU.setCallback((Drawable.Callback)this);
        this.zzasZ = new zzk(this);
        zzb zzb2 = new zzb(this);
        this.zzata = new GestureDetectorCompat(context, (GestureDetector.OnGestureListener)zzb2);
        this.zzata.setIsLongpressEnabled(false);
        this.setVisibility(8);
    }

    public final void zza(zzi zzi2) {
        this.zzasW = (zzi)jw.zzu((Object)zzi2);
        this.addView(zzi2.asView(), 0);
    }

    public final void zza(View view, @Nullable View view2, boolean bl, zzh zzh2) {
        this.targetView = (View)jw.zzu((Object)view);
        this.zzasX = null;
        this.zzatc = (zzh)jw.zzu((Object)zzh2);
        zzc zzc2 = new zzc(this, view, true, zzh2);
        this.zzatb = new GestureDetectorCompat(this.getContext(), (GestureDetector.OnGestureListener)zzc2);
        this.zzatb.setIsLongpressEnabled(false);
        this.setVisibility(4);
    }

    protected final void onMeasure(int n, int n2) {
        int n3 = View.MeasureSpec.getSize((int)n);
        int n4 = View.MeasureSpec.getSize((int)n2);
        this.setMeasuredDimension(zza.resolveSize((int)n3, (int)n), zza.resolveSize((int)n4, (int)n2));
    }

    protected final void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        if (this.targetView == null) {
            throw new IllegalStateException("Target view must be set before layout");
        }
        if (this.targetView.getParent() != null) {
            View view = this.targetView;
            int[] nArray = this.zzasR;
            zza zza2 = this;
            zza2.getLocationInWindow(nArray);
            int n5 = nArray[0];
            int n6 = nArray[1];
            view.getLocationInWindow(nArray);
            nArray[0] = nArray[0] - n5;
            nArray[1] = nArray[1] - n6;
        }
        this.zzasS.set(this.zzasR[0], this.zzasR[1], this.zzasR[0] + this.targetView.getWidth(), this.zzasR[1] + this.targetView.getHeight());
        this.zzasT.set(n, n2, n3, n4);
        this.zzasU.setBounds(this.zzasT);
        this.zzasV.setBounds(this.zzasT);
        this.zzasZ.zza(this.zzasS, this.zzasT);
    }

    protected final void onDraw(Canvas canvas) {
        canvas.save();
        this.zzasU.draw(canvas);
        this.zzasV.draw(canvas);
        if (this.targetView != null) {
            if (this.targetView.getParent() != null) {
                Bitmap bitmap = Bitmap.createBitmap((int)this.targetView.getWidth(), (int)this.targetView.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas canvas2 = new Canvas(bitmap);
                this.targetView.draw(canvas2);
                int n = this.zzasU.getColor();
                int n2 = Color.red((int)n);
                int n3 = Color.green((int)n);
                int n4 = Color.blue((int)n);
                for (int i = 0; i < bitmap.getHeight(); ++i) {
                    for (int j = 0; j < bitmap.getWidth(); ++j) {
                        int n5 = bitmap.getPixel(j, i);
                        if (Color.alpha((int)n5) == 0) continue;
                        n5 = Color.argb((int)Color.alpha((int)n5), (int)n2, (int)n3, (int)n4);
                        bitmap.setPixel(j, i, n5);
                    }
                }
                canvas.drawBitmap(bitmap, (float)this.zzasS.left, (float)this.zzasS.top, null);
            }
        } else {
            throw new IllegalStateException("Neither target view nor drawable was set");
        }
        canvas.restore();
    }

    public final ViewGroup.LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new ViewGroup.MarginLayoutParams(this.getContext(), attributeSet);
    }

    protected final ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new ViewGroup.MarginLayoutParams(-2, -2);
    }

    protected final ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return new ViewGroup.MarginLayoutParams(layoutParams);
    }

    protected final boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof ViewGroup.MarginLayoutParams;
    }

    protected final boolean verifyDrawable(Drawable drawable) {
        return super.verifyDrawable(drawable) || drawable == this.zzasU || drawable == this.zzasV || drawable == null;
    }

    public final void zzg(@Nullable Runnable runnable) {
        this.addOnLayoutChangeListener(new zzd(this, null));
    }

    public final void zznL() {
        if (this.targetView == null) {
            throw new IllegalStateException("Target view must be set before animation");
        }
        this.setVisibility(0);
        zza zza2 = this;
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)zza2.zzasW.asView(), (String)"alpha", (float[])new float[]{0.0f, 1.0f}).setDuration(350L);
        objectAnimator.setInterpolator((TimeInterpolator)jg.zzEd());
        float f = zza2.zzasS.exactCenterX() - zza2.zzasU.getCenterX();
        float f2 = zza2.zzasS.exactCenterY() - zza2.zzasU.getCenterY();
        Animator animator = zza2.zzasU.zze(f, f2);
        zzj zzj2 = zza2.zzasV;
        PropertyValuesHolder propertyValuesHolder = PropertyValuesHolder.ofFloat((String)"scale", (float[])new float[]{0.0f, 1.0f});
        PropertyValuesHolder propertyValuesHolder2 = PropertyValuesHolder.ofFloat((String)"alpha", (float[])new float[]{0.0f, 1.0f});
        ObjectAnimator objectAnimator2 = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)zzj2), (PropertyValuesHolder[])new PropertyValuesHolder[]{propertyValuesHolder, propertyValuesHolder2});
        objectAnimator2.setInterpolator((TimeInterpolator)jg.zzEd());
        Animator animator2 = objectAnimator2.setDuration(350L);
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{objectAnimator, animator, animator2});
        animatorSet.addListener((Animator.AnimatorListener)new zze(zza2));
        this.zza((Animator)animatorSet);
    }

    public final void zzh(@Nullable Runnable runnable) {
        float f;
        Runnable runnable2 = runnable;
        zza zza2 = this;
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)zza2.zzasW.asView(), (String)"alpha", (float[])new float[]{0.0f}).setDuration(200L);
        objectAnimator.setInterpolator((TimeInterpolator)jg.zzEe());
        float f2 = zza2.zzasS.exactCenterX() - zza2.zzasU.getCenterX();
        float f3 = f = zza2.zzasS.exactCenterY() - zza2.zzasU.getCenterY();
        float f4 = f2;
        zzl zzl2 = zza2.zzasU;
        PropertyValuesHolder propertyValuesHolder = PropertyValuesHolder.ofFloat((String)"scale", (float[])new float[]{0.0f});
        PropertyValuesHolder propertyValuesHolder2 = PropertyValuesHolder.ofInt((String)"alpha", (int[])new int[]{0});
        PropertyValuesHolder propertyValuesHolder3 = PropertyValuesHolder.ofFloat((String)"translationX", (float[])new float[]{0.0f, f4});
        PropertyValuesHolder propertyValuesHolder4 = PropertyValuesHolder.ofFloat((String)"translationY", (float[])new float[]{0.0f, f3});
        ObjectAnimator objectAnimator2 = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)zzl2), (PropertyValuesHolder[])new PropertyValuesHolder[]{propertyValuesHolder, propertyValuesHolder3, propertyValuesHolder4, propertyValuesHolder2});
        objectAnimator2.setInterpolator((TimeInterpolator)jg.zzEe());
        Animator animator = objectAnimator2.setDuration(200L);
        Animator animator2 = zza2.zzasV.zznQ();
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{objectAnimator, animator, animator2});
        animatorSet.addListener((Animator.AnimatorListener)new zzg(zza2, runnable2));
        this.zza((Animator)animatorSet);
    }

    public final void zzi(@Nullable Runnable runnable) {
        Runnable runnable2 = runnable;
        zza zza2 = this;
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)zza2.zzasW.asView(), (String)"alpha", (float[])new float[]{0.0f}).setDuration(200L);
        objectAnimator.setInterpolator((TimeInterpolator)jg.zzEe());
        zzl zzl2 = zza2.zzasU;
        PropertyValuesHolder propertyValuesHolder = PropertyValuesHolder.ofFloat((String)"scale", (float[])new float[]{1.125f});
        PropertyValuesHolder propertyValuesHolder2 = PropertyValuesHolder.ofInt((String)"alpha", (int[])new int[]{0});
        ObjectAnimator objectAnimator2 = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)zzl2), (PropertyValuesHolder[])new PropertyValuesHolder[]{propertyValuesHolder, propertyValuesHolder2});
        objectAnimator2.setInterpolator((TimeInterpolator)jg.zzEe());
        Animator animator = objectAnimator2.setDuration(200L);
        Animator animator2 = zza2.zzasV.zznQ();
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{objectAnimator, animator, animator2});
        animatorSet.addListener((Animator.AnimatorListener)new zzf(zza2, runnable2));
        this.zza((Animator)animatorSet);
    }

    public final void zzaa(@ColorInt int n) {
        this.zzasU.setColor(n);
    }

    final View zznM() {
        return this.zzasW.asView();
    }

    final zzl zznN() {
        return this.zzasU;
    }

    final zzj zznO() {
        return this.zzasV;
    }

    private final void zza(Animator animator) {
        if (this.zzasY != null) {
            this.zzasY.cancel();
        }
        this.zzasY = animator;
        this.zzasY.start();
    }

    public final boolean onTouchEvent(MotionEvent motionEvent) {
        int n = motionEvent.getActionMasked();
        if (n == 0) {
            this.zzatd = this.zzasS.contains((int)motionEvent.getX(), (int)motionEvent.getY());
        }
        if (this.zzatd) {
            MotionEvent motionEvent2 = motionEvent;
            if (this.zzatb != null) {
                this.zzatb.onTouchEvent(motionEvent);
                if (n == 1) {
                    motionEvent2 = MotionEvent.obtain((MotionEvent)motionEvent);
                    motionEvent2.setAction(3);
                }
            }
            if (this.targetView.getParent() != null) {
                this.targetView.onTouchEvent(motionEvent2);
            }
        } else {
            this.zzata.onTouchEvent(motionEvent);
        }
        return true;
    }

    private final boolean zzc(float f, float f2) {
        return this.zzasT.contains(Math.round(f), Math.round(f2));
    }

    private final Animator zznP() {
        zzj zzj2 = this.zzasV;
        AnimatorSet animatorSet = new AnimatorSet();
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)((Object)zzj2), (String)"scale", (float[])new float[]{1.0f, 1.1f}).setDuration(500L);
        ObjectAnimator objectAnimator2 = ObjectAnimator.ofFloat((Object)((Object)zzj2), (String)"scale", (float[])new float[]{1.1f, 1.0f}).setDuration(500L);
        PropertyValuesHolder propertyValuesHolder = PropertyValuesHolder.ofFloat((String)"pulseScale", (float[])new float[]{1.1f, 2.0f});
        PropertyValuesHolder propertyValuesHolder2 = PropertyValuesHolder.ofFloat((String)"pulseAlpha", (float[])new float[]{1.0f, 0.0f});
        ObjectAnimator objectAnimator3 = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)zzj2), (PropertyValuesHolder[])new PropertyValuesHolder[]{propertyValuesHolder, propertyValuesHolder2}).setDuration(500L);
        animatorSet.play((Animator)objectAnimator);
        animatorSet.play((Animator)objectAnimator2).with((Animator)objectAnimator3).after((Animator)objectAnimator);
        animatorSet.setInterpolator((TimeInterpolator)jg.zzEf());
        animatorSet.setStartDelay(500L);
        ix.zza((Animator)animatorSet, null);
        return animatorSet;
    }

    static /* synthetic */ boolean zza(zza zza2, float f, float f2) {
        return zza2.zzc(f, f2);
    }

    static /* synthetic */ zzl zza(zza zza2) {
        return zza2.zzasU;
    }

    static /* synthetic */ zzh zzb(zza zza2) {
        return zza2.zzatc;
    }

    static /* synthetic */ Animator zza(zza zza2, Animator animator) {
        zza2.zzasY = animator;
        return zza2.zzasY;
    }

    static /* synthetic */ Animator zzc(zza zza2) {
        return zza2.zznP();
    }

    static /* synthetic */ Animator zzd(zza zza2) {
        return zza2.zzasY;
    }
}

