/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import com.google.android.gms.cast.AdBreakInfo;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.cast.framework.media.zzaa;
import com.google.android.gms.cast.framework.media.zzab;
import com.google.android.gms.cast.framework.media.zzac;
import com.google.android.gms.cast.framework.media.zzad;
import com.google.android.gms.cast.framework.media.zzae;
import com.google.android.gms.cast.framework.media.zzaf;
import com.google.android.gms.cast.framework.media.zzag;
import com.google.android.gms.cast.framework.media.zzah;
import com.google.android.gms.cast.framework.media.zzai;
import com.google.android.gms.cast.framework.media.zzi;
import com.google.android.gms.cast.framework.media.zzj;
import com.google.android.gms.cast.framework.media.zzk;
import com.google.android.gms.cast.framework.media.zzl;
import com.google.android.gms.cast.framework.media.zzm;
import com.google.android.gms.cast.framework.media.zzn;
import com.google.android.gms.cast.framework.media.zzo;
import com.google.android.gms.cast.framework.media.zzp;
import com.google.android.gms.cast.framework.media.zzq;
import com.google.android.gms.cast.framework.media.zzr;
import com.google.android.gms.cast.framework.media.zzs;
import com.google.android.gms.cast.framework.media.zzt;
import com.google.android.gms.cast.framework.media.zzu;
import com.google.android.gms.cast.framework.media.zzv;
import com.google.android.gms.cast.framework.media.zzw;
import com.google.android.gms.cast.framework.media.zzx;
import com.google.android.gms.cast.framework.media.zzy;
import com.google.android.gms.cast.framework.media.zzz;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.internal.zzaze;
import com.google.android.gms.internal.zzazj;
import com.google.android.gms.internal.zzbab;
import com.google.android.gms.internal.zzbac;
import com.google.android.gms.internal.zzbae;
import com.google.android.gms.internal.zzbaf;
import com.google.android.gms.internal.zzbck;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONObject;

public class RemoteMediaClient
implements Cast.MessageReceivedCallback {
    private final Object mLock;
    private final Handler mHandler;
    private final zzbab zzaqR;
    private final zza zzauw;
    private final Cast.CastApi zzasd;
    private GoogleApiClient zzXl;
    private final List<Listener> mListeners = new CopyOnWriteArrayList<Listener>();
    private final Map<ProgressListener, zzd> zzaux = new ConcurrentHashMap<ProgressListener, zzd>();
    private final Map<Long, zzd> zzauy = new ConcurrentHashMap<Long, zzd>();
    private ParseAdsInfoCallback zzauz;
    public static final String NAMESPACE = zzbab.NAMESPACE;
    public static final int RESUME_STATE_UNCHANGED = 0;
    public static final int RESUME_STATE_PLAY = 1;
    public static final int RESUME_STATE_PAUSE = 2;
    public static final int STATUS_SUCCEEDED = 0;
    public static final int STATUS_FAILED = 2100;
    public static final int STATUS_REPLACED = 2103;

    public RemoteMediaClient(@NonNull zzbab zzbab2, @NonNull Cast.CastApi castApi) {
        this.mLock = new Object();
        this.mHandler = new Handler(Looper.getMainLooper());
        this.zzauw = new zza();
        this.zzasd = castApi;
        this.zzaqR = (zzbab)zzbr.zzu((Object)zzbab2);
        this.zzaqR.zza((zzbac)new zzi(this));
        this.zzaqR.zza((zzbae)this.zzauw);
    }

    public final void zzc(GoogleApiClient googleApiClient) throws IOException {
        if (this.zzXl == googleApiClient) {
            return;
        }
        if (this.zzXl != null) {
            this.zzaqR.zzox();
            this.zzasd.removeMessageReceivedCallbacks(this.zzXl, this.getNamespace());
            this.zzauw.zzb(null);
            this.mHandler.removeCallbacksAndMessages(null);
        }
        this.zzXl = googleApiClient;
        if (this.zzXl != null) {
            this.zzauw.zzb(this.zzXl);
        }
    }

    public final void zznV() throws IOException {
        if (this.zzXl != null) {
            this.zzasd.setMessageReceivedCallbacks(this.zzXl, this.getNamespace(), (Cast.MessageReceivedCallback)this);
        }
    }

    public PendingResult<MediaChannelResult> load(MediaInfo mediaInfo) {
        return this.load(mediaInfo, true, 0L, null, null);
    }

    public PendingResult<MediaChannelResult> load(MediaInfo mediaInfo, boolean bl) {
        return this.load(mediaInfo, bl, 0L, null, null);
    }

    public PendingResult<MediaChannelResult> load(MediaInfo mediaInfo, boolean bl, long l) {
        return this.load(mediaInfo, bl, l, null, null);
    }

    public PendingResult<MediaChannelResult> load(MediaInfo mediaInfo, boolean bl, long l, JSONObject jSONObject) {
        return this.load(mediaInfo, bl, l, null, jSONObject);
    }

    public PendingResult<MediaChannelResult> load(MediaInfo mediaInfo, boolean bl, long l, long[] lArray, JSONObject jSONObject) {
        zzbr.zzcz((String)"Must be called from the main thread.");
        this.zznW();
        return this.zza(new zzt(this, this.zzXl, mediaInfo, bl, l, lArray, jSONObject));
    }

    public PendingResult<MediaChannelResult> pause() {
        return this.pause(null);
    }

    public PendingResult<MediaChannelResult> pause(JSONObject jSONObject) {
        zzbr.zzcz((String)"Must be called from the main thread.");
        this.zznW();
        return this.zza(new zzy(this, this.zzXl, jSONObject));
    }

    public PendingResult<MediaChannelResult> stop() {
        return this.stop(null);
    }

    public PendingResult<MediaChannelResult> stop(JSONObject jSONObject) {
        zzbr.zzcz((String)"Must be called from the main thread.");
        this.zznW();
        return this.zza(new zzz(this, this.zzXl, jSONObject));
    }

    public PendingResult<MediaChannelResult> play() {
        return this.play(null);
    }

    public PendingResult<MediaChannelResult> play(JSONObject jSONObject) {
        zzbr.zzcz((String)"Must be called from the main thread.");
        this.zznW();
        return this.zza(new zzaa(this, this.zzXl, jSONObject));
    }

    public PendingResult<MediaChannelResult> seek(long l) {
        return this.seek(l, 0, null);
    }

    public PendingResult<MediaChannelResult> seek(long l, int n) {
        return this.seek(l, n, null);
    }

    public PendingResult<MediaChannelResult> seek(long l, int n, JSONObject jSONObject) {
        zzbr.zzcz((String)"Must be called from the main thread.");
        this.zznW();
        return this.zza(new zzab(this, this.zzXl, l, n, jSONObject));
    }

    public PendingResult<MediaChannelResult> setStreamVolume(double d) throws IllegalArgumentException {
        return this.setStreamVolume(d, null);
    }

    public PendingResult<MediaChannelResult> setStreamVolume(double d, JSONObject jSONObject) throws IllegalArgumentException {
        zzbr.zzcz((String)"Must be called from the main thread.");
        this.zznW();
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new IllegalArgumentException(new StringBuilder(41).append("Volume cannot be ").append(d).toString());
        }
        return this.zza(new zzac(this, this.zzXl, d, jSONObject));
    }

    public PendingResult<MediaChannelResult> setStreamMute(boolean bl) {
        return this.setStreamMute(bl, null);
    }

    public PendingResult<MediaChannelResult> setStreamMute(boolean bl, JSONObject jSONObject) {
        zzbr.zzcz((String)"Must be called from the main thread.");
        this.zznW();
        return this.zza(new zzad(this, this.zzXl, bl, jSONObject));
    }

    public PendingResult<MediaChannelResult> requestStatus() {
        zzbr.zzcz((String)"Must be called from the main thread.");
        this.zznW();
        return this.zza(new zzae(this, this.zzXl));
    }

    public PendingResult<MediaChannelResult> setActiveMediaTracks(long[] lArray) {
        zzbr.zzcz((String)"Must be called from the main thread.");
        this.zznW();
        if (lArray == null) {
            throw new IllegalArgumentException("trackIds cannot be null");
        }
        return this.zza(new zzj(this, this.zzXl, lArray));
    }

    public PendingResult<MediaChannelResult> setTextTrackStyle(TextTrackStyle textTrackStyle) {
        zzbr.zzcz((String)"Must be called from the main thread.");
        this.zznW();
        if (textTrackStyle == null) {
            throw new IllegalArgumentException("trackStyle cannot be null");
        }
        return this.zza(new zzk(this, this.zzXl, textTrackStyle));
    }

    public PendingResult<MediaChannelResult> queueLoad(MediaQueueItem[] mediaQueueItemArray, int n, int n2, JSONObject jSONObject) throws IllegalArgumentException {
        return this.queueLoad(mediaQueueItemArray, n, n2, -1L, jSONObject);
    }

    public PendingResult<MediaChannelResult> queueLoad(MediaQueueItem[] mediaQueueItemArray, int n, int n2, long l, JSONObject jSONObject) throws IllegalArgumentException {
        zzbr.zzcz((String)"Must be called from the main thread.");
        this.zznW();
        return this.zza(new zzl(this, this.zzXl, mediaQueueItemArray, n, n2, l, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueInsertItems(MediaQueueItem[] mediaQueueItemArray, int n, JSONObject jSONObject) throws IllegalArgumentException {
        zzbr.zzcz((String)"Must be called from the main thread.");
        this.zznW();
        return this.zza(new zzm(this, this.zzXl, mediaQueueItemArray, n, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueAppendItem(MediaQueueItem mediaQueueItem, JSONObject jSONObject) throws IllegalArgumentException {
        return this.queueInsertItems(new MediaQueueItem[]{mediaQueueItem}, 0, jSONObject);
    }

    public PendingResult<MediaChannelResult> queueInsertAndPlayItem(MediaQueueItem mediaQueueItem, int n, JSONObject jSONObject) {
        return this.queueInsertAndPlayItem(mediaQueueItem, n, -1L, jSONObject);
    }

    public PendingResult<MediaChannelResult> queueInsertAndPlayItem(MediaQueueItem mediaQueueItem, int n, long l, JSONObject jSONObject) {
        zzbr.zzcz((String)"Must be called from the main thread.");
        this.zznW();
        return this.zza(new zzn(this, this.zzXl, mediaQueueItem, n, l, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueUpdateItems(MediaQueueItem[] mediaQueueItemArray, JSONObject jSONObject) {
        zzbr.zzcz((String)"Must be called from the main thread.");
        this.zznW();
        return this.zza(new zzo(this, this.zzXl, mediaQueueItemArray, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueRemoveItems(int[] nArray, JSONObject jSONObject) throws IllegalArgumentException {
        zzbr.zzcz((String)"Must be called from the main thread.");
        this.zznW();
        return this.zza(new zzp(this, this.zzXl, nArray, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueReorderItems(int[] nArray, int n, JSONObject jSONObject) throws IllegalArgumentException {
        zzbr.zzcz((String)"Must be called from the main thread.");
        this.zznW();
        return this.zza(new zzq(this, this.zzXl, nArray, n, jSONObject));
    }

    public PendingResult<MediaChannelResult> queuePrev(JSONObject jSONObject) {
        zzbr.zzcz((String)"Must be called from the main thread.");
        this.zznW();
        return this.zza(new zzr(this, this.zzXl, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueNext(JSONObject jSONObject) {
        zzbr.zzcz((String)"Must be called from the main thread.");
        this.zznW();
        return this.zza(new zzs(this, this.zzXl, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueSetRepeatMode(int n, JSONObject jSONObject) {
        zzbr.zzcz((String)"Must be called from the main thread.");
        this.zznW();
        return this.zza(new zzu(this, this.zzXl, n, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueRemoveItem(int n, JSONObject jSONObject) {
        zzbr.zzcz((String)"Must be called from the main thread.");
        this.zznW();
        return this.zza(new zzv(this, this.zzXl, n, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueJumpToItem(int n, JSONObject jSONObject) {
        return this.queueJumpToItem(n, -1L, jSONObject);
    }

    public PendingResult<MediaChannelResult> queueJumpToItem(int n, long l, JSONObject jSONObject) {
        zzbr.zzcz((String)"Must be called from the main thread.");
        this.zznW();
        return this.zza(new zzw(this, this.zzXl, n, l, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueMoveItemToNewIndex(int n, int n2, JSONObject jSONObject) {
        zzbr.zzcz((String)"Must be called from the main thread.");
        this.zznW();
        return this.zza(new zzx(this, this.zzXl, n, n2, jSONObject));
    }

    private final int zzX(int n) {
        zzbr.zzcz((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        for (int i = 0; i < mediaStatus.getQueueItemCount(); ++i) {
            if (mediaStatus.getQueueItem(i).getItemId() != n) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getApproximateStreamPosition() {
        Object object = this.mLock;
        synchronized (object) {
            zzbr.zzcz((String)"Must be called from the main thread.");
            return this.zzaqR.getApproximateStreamPosition();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getStreamDuration() {
        Object object = this.mLock;
        synchronized (object) {
            zzbr.zzcz((String)"Must be called from the main thread.");
            return this.zzaqR.getStreamDuration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaStatus getMediaStatus() {
        Object object = this.mLock;
        synchronized (object) {
            zzbr.zzcz((String)"Must be called from the main thread.");
            return this.zzaqR.getMediaStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaInfo getMediaInfo() {
        Object object = this.mLock;
        synchronized (object) {
            zzbr.zzcz((String)"Must be called from the main thread.");
            return this.zzaqR.getMediaInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPlayerState() {
        Object object = this.mLock;
        synchronized (object) {
            zzbr.zzcz((String)"Must be called from the main thread.");
            MediaStatus mediaStatus = this.getMediaStatus();
            return mediaStatus != null ? mediaStatus.getPlayerState() : 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIdleReason() {
        Object object = this.mLock;
        synchronized (object) {
            zzbr.zzcz((String)"Must be called from the main thread.");
            MediaStatus mediaStatus = this.getMediaStatus();
            return mediaStatus != null ? mediaStatus.getIdleReason() : 0;
        }
    }

    public boolean isLiveStream() {
        zzbr.zzcz((String)"Must be called from the main thread.");
        MediaInfo mediaInfo = this.getMediaInfo();
        return mediaInfo != null && mediaInfo.getStreamType() == 2;
    }

    public boolean isPlaying() {
        zzbr.zzcz((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus != null && mediaStatus.getPlayerState() == 2;
    }

    public boolean isPaused() {
        zzbr.zzcz((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus != null && (mediaStatus.getPlayerState() == 3 || this.isLiveStream() && this.getIdleReason() == 2);
    }

    public boolean isBuffering() {
        zzbr.zzcz((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus != null && mediaStatus.getPlayerState() == 4;
    }

    public boolean isLoadingNextItem() {
        zzbr.zzcz((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus != null && mediaStatus.getLoadingItemId() != 0;
    }

    public MediaQueueItem getCurrentItem() {
        zzbr.zzcz((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        if (mediaStatus == null) {
            return null;
        }
        return mediaStatus.getQueueItemById(mediaStatus.getCurrentItemId());
    }

    public MediaQueueItem getLoadingItem() {
        zzbr.zzcz((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        if (mediaStatus == null) {
            return null;
        }
        return mediaStatus.getQueueItemById(mediaStatus.getLoadingItemId());
    }

    public MediaQueueItem getPreloadedItem() {
        zzbr.zzcz((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        if (mediaStatus == null) {
            return null;
        }
        return mediaStatus.getQueueItemById(mediaStatus.getPreloadedItemId());
    }

    public void togglePlayback() {
        zzbr.zzcz((String)"Must be called from the main thread.");
        int n = this.getPlayerState();
        if (n == 4 || n == 2) {
            this.pause();
            return;
        }
        this.play();
    }

    public boolean hasMediaSession() {
        zzbr.zzcz((String)"Must be called from the main thread.");
        return this.isBuffering() || this.isPlaying() || this.isPaused() || this.isLoadingNextItem();
    }

    public void addListener(Listener listener) {
        zzbr.zzcz((String)"Must be called from the main thread.");
        if (listener != null) {
            this.mListeners.add(listener);
        }
    }

    public void removeListener(Listener listener) {
        zzbr.zzcz((String)"Must be called from the main thread.");
        if (listener != null) {
            this.mListeners.remove(listener);
        }
    }

    public boolean addProgressListener(ProgressListener progressListener, long l) {
        zzbr.zzcz((String)"Must be called from the main thread.");
        if (progressListener == null || this.zzaux.containsKey(progressListener)) {
            return false;
        }
        zzd zzd2 = this.zzauy.get(l);
        if (zzd2 == null) {
            zzd2 = new zzd(l);
            this.zzauy.put(l, zzd2);
        }
        zzd2.zza(progressListener);
        this.zzaux.put(progressListener, zzd2);
        if (this.hasMediaSession()) {
            zzd2.start();
        }
        return true;
    }

    public void removeProgressListener(ProgressListener progressListener) {
        zzbr.zzcz((String)"Must be called from the main thread.");
        zzd zzd2 = this.zzaux.remove(progressListener);
        if (zzd2 != null) {
            zzd2.zzb(progressListener);
            if (!zzd2.zzoa()) {
                this.zzauy.remove(zzd2.zznZ());
                zzd2.stop();
            }
        }
    }

    public void setParseAdsInfoCallback(ParseAdsInfoCallback parseAdsInfoCallback) {
        zzbr.zzcz((String)"Must be called from the main thread.");
        this.zzauz = parseAdsInfoCallback;
    }

    public boolean isPlayingAd() {
        zzbr.zzcz((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus != null && mediaStatus.isPlayingAd();
    }

    public String getNamespace() {
        zzbr.zzcz((String)"Must be called from the main thread.");
        return this.zzaqR.getNamespace();
    }

    public void onMessageReceived(CastDevice castDevice, String string2, String string3) {
        this.zzaqR.zzch(string3);
    }

    private final void zznW() throws IllegalStateException {
        if (this.zzXl == null) {
            throw new IllegalStateException("No connection");
        }
    }

    private final zzb zza(zzb zzb2) {
        try {
            this.zzXl.zze((zzbck)zzb2);
            return zzb2;
        }
        catch (IllegalStateException illegalStateException) {
            try {
                zzb2.setResult((MediaChannelResult)zzb2.zzb(new Status(2100)));
                return zzb2;
            }
            catch (Throwable throwable) {
                return zzb2;
            }
        }
    }

    private final void zza(Set<ProgressListener> set) {
        if (this.isBuffering() || this.isPaused()) {
            return;
        }
        HashSet<ProgressListener> hashSet = new HashSet<ProgressListener>(set);
        if (this.isPlaying()) {
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                ((ProgressListener)iterator.next()).onProgressUpdated(this.getApproximateStreamPosition(), this.getStreamDuration());
            }
            return;
        }
        if (this.isLoadingNextItem()) {
            MediaQueueItem mediaQueueItem = this.getLoadingItem();
            if (mediaQueueItem != null && mediaQueueItem.getMedia() != null) {
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    ((ProgressListener)iterator.next()).onProgressUpdated(0L, mediaQueueItem.getMedia().getStreamDuration());
                }
            }
            return;
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            ((ProgressListener)iterator.next()).onProgressUpdated(0L, 0L);
        }
    }

    private final void zznX() {
        for (zzd zzd2 : this.zzauy.values()) {
            if (this.hasMediaSession() && !zzd2.isStarted()) {
                zzd2.start();
            } else if (!this.hasMediaSession() && zzd2.isStarted()) {
                zzd2.stop();
            }
            if (!zzd2.isStarted() || !this.isBuffering() && !this.isPaused() && !this.isLoadingNextItem()) continue;
            this.zza(zzd2.zzauD);
        }
    }

    static /* synthetic */ void zza(RemoteMediaClient remoteMediaClient) {
        remoteMediaClient.zznX();
    }

    static /* synthetic */ ParseAdsInfoCallback zzc(RemoteMediaClient remoteMediaClient) {
        return remoteMediaClient.zzauz;
    }

    static /* synthetic */ Object zzd(RemoteMediaClient remoteMediaClient) {
        return remoteMediaClient.mLock;
    }

    static /* synthetic */ zzbab zze(RemoteMediaClient remoteMediaClient) {
        return remoteMediaClient.zzaqR;
    }

    static /* synthetic */ int zza(RemoteMediaClient remoteMediaClient, int n) {
        return remoteMediaClient.zzX(n);
    }

    static /* synthetic */ void zza(RemoteMediaClient remoteMediaClient, Set set) {
        remoteMediaClient.zza(set);
    }

    final class zzd {
        private final Set<ProgressListener> zzauD = new HashSet<ProgressListener>();
        private final long zzauE;
        private final Runnable zzauF;
        private boolean zzauG;

        public zzd(long l) {
            this.zzauE = l;
            this.zzauF = new zzai(this, RemoteMediaClient.this);
        }

        public final long zznZ() {
            return this.zzauE;
        }

        public final void zza(ProgressListener progressListener) {
            this.zzauD.add(progressListener);
        }

        public final void zzb(ProgressListener progressListener) {
            this.zzauD.remove(progressListener);
        }

        public final boolean zzoa() {
            return !this.zzauD.isEmpty();
        }

        public final void start() {
            RemoteMediaClient.this.mHandler.removeCallbacks(this.zzauF);
            this.zzauG = true;
            RemoteMediaClient.this.mHandler.postDelayed(this.zzauF, this.zzauE);
        }

        public final void stop() {
            RemoteMediaClient.this.mHandler.removeCallbacks(this.zzauF);
            this.zzauG = false;
        }

        public final boolean isStarted() {
            return this.zzauG;
        }

        static /* synthetic */ long zzb(zzd zzd2) {
            return zzd2.zzauE;
        }
    }

    static abstract class zzb
    extends zzaze<MediaChannelResult> {
        zzbaf zzary = new zzag(this);

        zzb(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected void zza(zzazj zzazj2) {
        }

        public final /* synthetic */ Result zzb(Status status) {
            Status status2 = status;
            zzb zzb2 = this;
            return new zzah(zzb2, status2);
        }
    }

    static final class zzc
    implements MediaChannelResult {
        private final Status mStatus;
        private final JSONObject zzaoF;

        zzc(Status status, JSONObject jSONObject) {
            this.mStatus = status;
            this.zzaoF = jSONObject;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final JSONObject getCustomData() {
            return this.zzaoF;
        }
    }

    public static interface MediaChannelResult
    extends Result {
        public JSONObject getCustomData();
    }

    final class zza
    implements zzbae {
        private GoogleApiClient zzaru;
        private long zzarv = 0L;

        public final void zzb(GoogleApiClient googleApiClient) {
            this.zzaru = googleApiClient;
        }

        public final long zznj() {
            return ++this.zzarv;
        }

        public final void zza(String string2, String string3, long l, String string4) throws IOException {
            if (this.zzaru == null) {
                throw new IOException("No GoogleApiClient available");
            }
            Iterator iterator = RemoteMediaClient.this.mListeners.iterator();
            while (iterator.hasNext()) {
                ((Listener)iterator.next()).onSendingRemoteMediaRequest();
            }
            RemoteMediaClient.this.zzasd.sendMessage(this.zzaru, string2, string3).setResultCallback((ResultCallback)new zzaf(this, l));
        }
    }

    public static interface ParseAdsInfoCallback {
        public boolean parseIsPlayingAdFromMediaStatus(MediaStatus var1);

        public List<AdBreakInfo> parseAdBreaksFromMediaStatus(MediaStatus var1);
    }

    public static interface ProgressListener {
        public void onProgressUpdated(long var1, long var3);
    }

    public static interface Listener {
        public void onStatusUpdated();

        public void onMetadataUpdated();

        public void onQueueStatusUpdated();

        public void onPreloadStatusUpdated();

        public void onSendingRemoteMediaRequest();

        public void onAdBreakStatusUpdated();
    }
}

