/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.DialogFragment;
import android.view.View;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TabHost;
import com.google.android.gms.R;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaTrack;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.zzaj;
import com.google.android.gms.cast.framework.media.zzak;
import com.google.android.gms.cast.framework.media.zzal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class TracksChooserDialogFragment
extends DialogFragment {
    private List<MediaTrack> zzauJ;
    private List<MediaTrack> zzauK;
    private long[] zzaqw;
    private Dialog mDialog;

    public static TracksChooserDialogFragment newInstance(MediaInfo mediaInfo, long[] lArray) {
        if (mediaInfo == null) {
            return null;
        }
        List list = mediaInfo.getMediaTracks();
        if (list == null) {
            return null;
        }
        ArrayList<MediaTrack> arrayList = TracksChooserDialogFragment.zza(list, 2);
        ArrayList<MediaTrack> arrayList2 = TracksChooserDialogFragment.zza(list, 1);
        if (arrayList.size() <= 1 && arrayList2.isEmpty()) {
            return null;
        }
        TracksChooserDialogFragment tracksChooserDialogFragment = new TracksChooserDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelableArrayList("extra_tracks_type_audio", arrayList);
        bundle.putParcelableArrayList("extra_tracks_type_text", arrayList2);
        bundle.putLongArray("extra_active_track_ids", lArray);
        tracksChooserDialogFragment.setArguments(bundle);
        return tracksChooserDialogFragment;
    }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.setRetainInstance(true);
        this.zzauJ = this.getArguments().getParcelableArrayList("extra_tracks_type_text");
        if (!this.zzauJ.isEmpty()) {
            TracksChooserDialogFragment tracksChooserDialogFragment = this;
            this.zzauJ.add(0, new MediaTrack.Builder(-1L, 1).setName(tracksChooserDialogFragment.getActivity().getString(R.string.cast_tracks_chooser_dialog_none)).setSubtype(2).setContentId("").build());
        }
        this.zzauK = this.getArguments().getParcelableArrayList("extra_tracks_type_audio");
        this.zzaqw = this.getArguments().getLongArray("extra_active_track_ids");
    }

    @NonNull
    public Dialog onCreateDialog(Bundle bundle) {
        TabHost.TabSpec tabSpec;
        int n = TracksChooserDialogFragment.zza(this.zzauJ, this.zzaqw, 0);
        int n2 = TracksChooserDialogFragment.zza(this.zzauK, this.zzaqw, -1);
        zzal zzal2 = new zzal((Context)this.getActivity(), this.zzauJ, n);
        zzal zzal3 = new zzal((Context)this.getActivity(), this.zzauK, n2);
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.getActivity());
        View view = this.getActivity().getLayoutInflater().inflate(R.layout.cast_tracks_chooser_dialog_layout, null);
        zzal zzal4 = zzal3;
        zzal zzal5 = zzal2;
        View view2 = view;
        TracksChooserDialogFragment tracksChooserDialogFragment = this;
        ListView listView = (ListView)view2.findViewById(R.id.text_list_view);
        ListView listView2 = (ListView)view2.findViewById(R.id.audio_list_view);
        TabHost tabHost = (TabHost)view2.findViewById(R.id.tab_host);
        tabHost.setup();
        if (zzal5.getCount() == 0) {
            listView.setVisibility(4);
        } else {
            listView.setAdapter((ListAdapter)zzal5);
            tabSpec = tabHost.newTabSpec("textTab");
            tabSpec.setContent(R.id.text_list_view);
            tabSpec.setIndicator((CharSequence)tracksChooserDialogFragment.getActivity().getString(R.string.cast_tracks_chooser_dialog_subtitles));
            tabHost.addTab(tabSpec);
        }
        if (zzal4.getCount() <= 1) {
            listView2.setVisibility(4);
        } else {
            listView2.setAdapter((ListAdapter)zzal4);
            tabSpec = tabHost.newTabSpec("audioTab");
            tabSpec.setContent(R.id.audio_list_view);
            tabSpec.setIndicator((CharSequence)tracksChooserDialogFragment.getActivity().getString(R.string.cast_tracks_chooser_dialog_audio));
            tabHost.addTab(tabSpec);
        }
        builder.setView(view).setPositiveButton((CharSequence)this.getActivity().getString(R.string.cast_tracks_chooser_dialog_ok), (DialogInterface.OnClickListener)new zzak(this, zzal2, zzal3)).setNegativeButton(R.string.cast_tracks_chooser_dialog_cancel, (DialogInterface.OnClickListener)new zzaj(this));
        if (this.mDialog != null) {
            this.mDialog.cancel();
            this.mDialog = null;
        }
        this.mDialog = builder.create();
        return this.mDialog;
    }

    private final void zza(zzal zzal2, zzal zzal3) {
        Object object;
        long[] lArray;
        MediaTrack mediaTrack;
        CastSession castSession = CastContext.getSharedInstance(this.getContext()).getSessionManager().getCurrentCastSession();
        if (castSession == null || !castSession.isConnected()) {
            return;
        }
        RemoteMediaClient remoteMediaClient = castSession.getRemoteMediaClient();
        if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession()) {
            return;
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        MediaTrack mediaTrack2 = zzal2.zzob();
        if (mediaTrack2.getId() != -1L) {
            arrayList.add(mediaTrack2.getId());
        }
        if ((mediaTrack = zzal3.zzob()) != null) {
            arrayList.add(mediaTrack.getId());
        }
        if ((lArray = remoteMediaClient.getMediaStatus().getActiveTrackIds()) != null && lArray.length > 0) {
            object = new HashSet();
            for (MediaTrack mediaTrack3 : this.zzauK) {
                ((HashSet)object).add(mediaTrack3.getId());
            }
            for (MediaTrack mediaTrack3 : this.zzauJ) {
                ((HashSet)object).add(mediaTrack3.getId());
            }
            Object object2 = lArray;
            int n = lArray.length;
            for (int i = 0; i < n; ++i) {
                Object object3 = object2[i];
                if (((HashSet)object).contains((long)object3)) continue;
                arrayList.add((long)object3);
            }
        }
        object = new long[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            object[i] = (Long)arrayList.get(i);
        }
        Arrays.sort((long[])object);
        remoteMediaClient.setActiveMediaTracks((long[])object);
        if (this.mDialog != null) {
            this.mDialog.cancel();
            this.mDialog = null;
        }
    }

    public void onDestroyView() {
        if (this.getDialog() != null && this.getRetainInstance()) {
            this.getDialog().setDismissMessage(null);
        }
        super.onDestroyView();
    }

    @NonNull
    private static ArrayList<MediaTrack> zza(List<MediaTrack> list, int n) {
        ArrayList<MediaTrack> arrayList = new ArrayList<MediaTrack>();
        if (list != null) {
            for (MediaTrack mediaTrack : list) {
                if (mediaTrack.getType() != n) continue;
                arrayList.add(mediaTrack);
            }
        }
        return arrayList;
    }

    private static int zza(List<MediaTrack> list, long[] lArray, int n) {
        if (lArray == null || list == null) {
            return n;
        }
        for (int i = 0; i < list.size(); ++i) {
            long[] lArray2 = lArray;
            int n2 = lArray.length;
            for (int j = 0; j < n2; ++j) {
                if (lArray2[j] != list.get(i).getId()) continue;
                return i;
            }
        }
        return n;
    }

    static /* synthetic */ Dialog zza(TracksChooserDialogFragment tracksChooserDialogFragment) {
        return tracksChooserDialogFragment.mDialog;
    }

    static /* synthetic */ Dialog zza(TracksChooserDialogFragment tracksChooserDialogFragment, Dialog dialog) {
        tracksChooserDialogFragment.mDialog = null;
        return null;
    }

    static /* synthetic */ void zza(TracksChooserDialogFragment tracksChooserDialogFragment, zzal zzal2, zzal zzal3) {
        tracksChooserDialogFragment.zza(zzal2, zzal3);
    }
}

