/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media.uicontroller;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.view.View;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.SeekBar;
import android.widget.TextView;
import com.google.android.gms.R;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.Session;
import com.google.android.gms.cast.framework.SessionManager;
import com.google.android.gms.cast.framework.SessionManagerListener;
import com.google.android.gms.cast.framework.media.ImageHints;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.uicontroller.UIController;
import com.google.android.gms.cast.framework.media.uicontroller.zza;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.internal.zzaxe;
import com.google.android.gms.internal.zzaxg;
import com.google.android.gms.internal.zzaxi;
import com.google.android.gms.internal.zzaxk;
import com.google.android.gms.internal.zzaxo;
import com.google.android.gms.internal.zzaxp;
import com.google.android.gms.internal.zzaxq;
import com.google.android.gms.internal.zzaxr;
import com.google.android.gms.internal.zzaxu;
import com.google.android.gms.internal.zzaxw;
import com.google.android.gms.internal.zzaxx;
import com.google.android.gms.internal.zzaxz;
import com.google.android.gms.internal.zzayb;
import com.google.android.gms.internal.zzayd;
import com.google.android.gms.internal.zzayf;
import com.google.android.gms.internal.zzayg;
import com.google.android.gms.internal.zzayh;
import com.google.android.gms.internal.zzayi;
import com.google.android.gms.internal.zzayj;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UIMediaController
implements SessionManagerListener<CastSession>,
RemoteMediaClient.Listener {
    private final Activity mActivity;
    private final SessionManager zzarQ;
    private final Map<View, List<UIController>> zzavk = new HashMap<View, List<UIController>>();
    private final Set<zzayh> zzavl = new HashSet<zzayh>();
    private RemoteMediaClient.Listener zzavm;
    private RemoteMediaClient zzasg;

    public UIMediaController(Activity activity) {
        this.mActivity = activity;
        this.zzarQ = CastContext.getSharedInstance((Context)activity).getSessionManager();
        this.zzarQ.addSessionManagerListener(this, CastSession.class);
        this.zza(this.zzarQ.getCurrentCastSession());
    }

    public boolean isActive() {
        zzbr.zzcz((String)"Must be called from the main thread.");
        return this.zzasg != null;
    }

    public RemoteMediaClient getRemoteMediaClient() {
        zzbr.zzcz((String)"Must be called from the main thread.");
        return this.zzasg;
    }

    public void setPostRemoteMediaClientListener(RemoteMediaClient.Listener listener) {
        zzbr.zzcz((String)"Must be called from the main thread.");
        this.zzavm = listener;
    }

    public void dispose() {
        zzbr.zzcz((String)"Must be called from the main thread.");
        this.zzog();
        this.zzavk.clear();
        this.zzarQ.removeSessionManagerListener(this, CastSession.class);
        this.zzavm = null;
    }

    public void bindImageViewToPlayPauseToggle(@NonNull ImageView imageView, @NonNull Drawable drawable2, @NonNull Drawable drawable3, Drawable drawable4, View view, boolean bl) {
        zzbr.zzcz((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzaxu(imageView, (Context)this.mActivity, drawable2, drawable3, drawable4, view, bl));
    }

    public void bindViewToSkipNext(View view, int n) {
        zzbr.zzcz((String)"Must be called from the main thread.");
        this.zza(view, new zzayb(view, n));
    }

    public void bindViewToSkipPrev(View view, int n) {
        zzbr.zzcz((String)"Must be called from the main thread.");
        this.zza(view, new zzayd(view, n));
    }

    public void bindViewToForward(View view, long l) {
        zzbr.zzcz((String)"Must be called from the main thread.");
        this.zza(view, new zzaxz(view, l));
    }

    public void bindViewToRewind(View view, long l) {
        zzbr.zzcz((String)"Must be called from the main thread.");
        this.bindViewToForward(view, -l);
    }

    public void bindViewToLoadingIndicator(View view) {
        zzbr.zzcz((String)"Must be called from the main thread.");
        this.zza(view, new zzaxo(view));
    }

    public void bindProgressBar(ProgressBar progressBar) {
        this.bindProgressBar(progressBar, 1000L);
    }

    public void bindProgressBar(ProgressBar progressBar, long l) {
        zzbr.zzcz((String)"Must be called from the main thread.");
        this.zza((View)progressBar, new zzaxw(progressBar, l));
    }

    public void bindSeekBar(SeekBar seekBar) {
        this.bindSeekBar(seekBar, 1000L);
    }

    public void bindSeekBar(SeekBar seekBar, long l) {
        zzbr.zzcz((String)"Must be called from the main thread.");
        zza zza2 = new zza(this);
        this.zza((View)seekBar, new zzaxx(seekBar, l, zza2));
    }

    public void bindTextViewToStreamPosition(TextView textView, boolean bl) {
        this.bindTextViewToStreamPosition(textView, bl, 1000L);
    }

    public void bindTextViewToStreamPosition(TextView textView, boolean bl, long l) {
        zzbr.zzcz((String)"Must be called from the main thread.");
        zzayh zzayh2 = new zzayh(textView, l, this.mActivity.getString(R.string.cast_invalid_stream_position_text));
        if (bl) {
            this.zzavl.add(zzayh2);
        }
        this.zza((View)textView, zzayh2);
    }

    public void bindTextViewToStreamDuration(TextView textView) {
        zzbr.zzcz((String)"Must be called from the main thread.");
        this.zza((View)textView, new zzayg(textView, this.mActivity.getString(R.string.cast_invalid_stream_duration_text), null));
    }

    public void bindTextViewToStreamDuration(TextView textView, View view) {
        zzbr.zzcz((String)"Must be called from the main thread.");
        this.zza((View)textView, new zzayg(textView, this.mActivity.getString(R.string.cast_invalid_stream_duration_text), view));
    }

    public void bindViewToLaunchExpandedController(View view) {
        zzbr.zzcz((String)"Must be called from the main thread.");
        this.zza(view, new zzaxk(view, this.mActivity));
    }

    public void bindViewToClosedCaption(View view) {
        zzbr.zzcz((String)"Must be called from the main thread.");
        this.zza(view, new zzaxe(view, this.mActivity));
    }

    public void bindImageViewToMuteToggle(ImageView imageView) {
        zzbr.zzcz((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzaxr(imageView, (Context)this.mActivity));
    }

    public void bindTextViewToMetadataOfCurrentItem(TextView textView, String string2) {
        zzbr.zzcz((String)"Must be called from the main thread.");
        this.bindTextViewToMetadataOfCurrentItem(textView, Collections.singletonList(string2));
    }

    public void bindTextViewToMetadataOfCurrentItem(TextView textView, List<String> list) {
        zzbr.zzcz((String)"Must be called from the main thread.");
        this.zza((View)textView, new zzaxq(textView, list));
    }

    @Deprecated
    public void bindImageViewToImageOfCurrentItem(ImageView imageView, int n, @DrawableRes int n2) {
        zzbr.zzcz((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzaxi(imageView, (Context)this.mActivity, new ImageHints(n, 0, 0), n2, null));
    }

    @Deprecated
    public void bindImageViewToImageOfCurrentItem(ImageView imageView, int n, View view) {
        zzbr.zzcz((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzaxi(imageView, (Context)this.mActivity, new ImageHints(n, 0, 0), 0, view));
    }

    public void bindImageViewToImageOfCurrentItem(ImageView imageView, @NonNull ImageHints imageHints, @DrawableRes int n) {
        zzbr.zzcz((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzaxi(imageView, (Context)this.mActivity, imageHints, n, null));
    }

    public void bindImageViewToImageOfCurrentItem(ImageView imageView, @NonNull ImageHints imageHints, View view) {
        zzbr.zzcz((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzaxi(imageView, (Context)this.mActivity, imageHints, 0, view));
    }

    public void bindViewVisibilityToMediaSession(View view, int n) {
        zzbr.zzcz((String)"Must be called from the main thread.");
        this.zza(view, new zzayj(view, n));
    }

    public void bindTextViewToMetadataOfPreloadedItem(TextView textView, String string2) {
        zzbr.zzcz((String)"Must be called from the main thread.");
        this.bindTextViewToMetadataOfPreloadedItem(textView, Collections.singletonList(string2));
    }

    public void bindTextViewToMetadataOfPreloadedItem(TextView textView, List<String> list) {
        zzbr.zzcz((String)"Must be called from the main thread.");
        this.zza((View)textView, new zzaxp(textView, list));
    }

    @Deprecated
    public void bindImageViewToImageOfPreloadedItem(ImageView imageView, int n, @DrawableRes int n2) {
        zzbr.zzcz((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzaxg(imageView, (Context)this.mActivity, new ImageHints(n, 0, 0), n2));
    }

    public void bindImageViewToImageOfPreloadedItem(ImageView imageView, @NonNull ImageHints imageHints, @DrawableRes int n) {
        zzbr.zzcz((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzaxg(imageView, (Context)this.mActivity, imageHints, n));
    }

    public void bindViewVisibilityToPreloadingEvent(View view, int n) {
        zzbr.zzcz((String)"Must be called from the main thread.");
        this.zza(view, new zzayi(view, n));
    }

    public void bindViewToUIController(View view, UIController uIController) {
        zzbr.zzcz((String)"Must be called from the main thread.");
        this.zza(view, uIController);
    }

    public void bindTextViewToSmartSubtitle(TextView textView) {
        zzbr.zzcz((String)"Must be called from the main thread.");
        this.zza((View)textView, new zzayf(textView));
    }

    @Override
    public void onSessionStarting(CastSession castSession) {
    }

    @Override
    public void onSessionStarted(CastSession castSession, String string2) {
        this.zza(castSession);
    }

    @Override
    public void onSessionResuming(CastSession castSession, String string2) {
    }

    @Override
    public void onSessionResumed(CastSession castSession, boolean bl) {
        this.zza(castSession);
    }

    @Override
    public void onSessionStartFailed(CastSession castSession, int n) {
        this.zzog();
    }

    @Override
    public void onSessionEnding(CastSession castSession) {
    }

    @Override
    public void onSessionEnded(CastSession castSession, int n) {
        this.zzog();
    }

    @Override
    public void onSessionResumeFailed(CastSession castSession, int n) {
        this.zzog();
    }

    @Override
    public void onSessionSuspended(CastSession castSession, int n) {
    }

    @Override
    public void onStatusUpdated() {
        this.zzoh();
        if (this.zzavm != null) {
            this.zzavm.onStatusUpdated();
        }
    }

    @Override
    public void onMetadataUpdated() {
        this.zzoh();
        if (this.zzavm != null) {
            this.zzavm.onMetadataUpdated();
        }
    }

    @Override
    public void onQueueStatusUpdated() {
        this.zzoh();
        if (this.zzavm != null) {
            this.zzavm.onQueueStatusUpdated();
        }
    }

    @Override
    public void onPreloadStatusUpdated() {
        this.zzoh();
        if (this.zzavm != null) {
            this.zzavm.onPreloadStatusUpdated();
        }
    }

    @Override
    public void onAdBreakStatusUpdated() {
        this.zzoh();
        if (this.zzavm != null) {
            this.zzavm.onAdBreakStatusUpdated();
        }
    }

    @Override
    public void onSendingRemoteMediaRequest() {
        Iterator<List<UIController>> iterator = this.zzavk.values().iterator();
        while (iterator.hasNext()) {
            Iterator<UIController> iterator2 = iterator.next().iterator();
            while (iterator2.hasNext()) {
                iterator2.next().onSendingRemoteMediaRequest();
            }
        }
        if (this.zzavm != null) {
            this.zzavm.onSendingRemoteMediaRequest();
        }
    }

    private final void zza(Session session) {
        if (this.isActive() || !(session instanceof CastSession) || !session.isConnected()) {
            return;
        }
        CastSession castSession = (CastSession)session;
        this.zzasg = castSession.getRemoteMediaClient();
        if (this.zzasg != null) {
            this.zzasg.addListener(this);
            Iterator<List<UIController>> iterator = this.zzavk.values().iterator();
            while (iterator.hasNext()) {
                Iterator<UIController> iterator2 = iterator.next().iterator();
                while (iterator2.hasNext()) {
                    iterator2.next().onSessionConnected(castSession);
                }
            }
            this.zzoh();
        }
    }

    private final void zzog() {
        if (!this.isActive()) {
            return;
        }
        Iterator<List<UIController>> iterator = this.zzavk.values().iterator();
        while (iterator.hasNext()) {
            Iterator<UIController> iterator2 = iterator.next().iterator();
            while (iterator2.hasNext()) {
                iterator2.next().onSessionEnded();
            }
        }
        this.zzasg.removeListener(this);
        this.zzasg = null;
    }

    private final void zza(View view, UIController uIController) {
        List<UIController> list = this.zzavk.get(view);
        if (list == null) {
            list = new ArrayList<UIController>();
            this.zzavk.put(view, list);
        }
        list.add(uIController);
        if (this.isActive()) {
            uIController.onSessionConnected(this.zzarQ.getCurrentCastSession());
            this.zzoh();
        }
    }

    private final void zzoh() {
        Iterator<List<UIController>> iterator = this.zzavk.values().iterator();
        while (iterator.hasNext()) {
            Iterator<UIController> iterator2 = iterator.next().iterator();
            while (iterator2.hasNext()) {
                iterator2.next().onMediaStatusUpdated();
            }
        }
    }

    static /* synthetic */ Set zza(UIMediaController uIMediaController) {
        return uIMediaController.zzavl;
    }
}

