/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media.widget;

import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Bundle;
import android.support.annotation.DrawableRes;
import android.support.v4.app.Fragment;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.google.android.gms.R;
import com.google.android.gms.cast.framework.media.ImageHints;
import com.google.android.gms.cast.framework.media.uicontroller.UIMediaController;
import com.google.android.gms.cast.framework.media.widget.ControlButtonsContainer;
import com.google.android.gms.cast.framework.media.widget.zzb;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.internal.zzbaa;

public class MiniControllerFragment
extends Fragment
implements ControlButtonsContainer {
    private static final zzbaa zzarM = new zzbaa("MiniControllerFragment");
    private boolean zzawI;
    private int zzawJ;
    private int zzawK;
    private TextView zzawL;
    private int zzawM;
    private int zzawN;
    private int zzawu;
    private int[] zzawz;
    private ImageView[] zzawA = new ImageView[3];
    private int zzawO;
    @DrawableRes
    private int zzawl;
    @DrawableRes
    private int zzawm;
    @DrawableRes
    private int zzawn;
    @DrawableRes
    private int zzawP;
    @DrawableRes
    private int zzawQ;
    @DrawableRes
    private int zzawR;
    @DrawableRes
    private int zzawo;
    @DrawableRes
    private int zzawp;
    @DrawableRes
    private int zzawq;
    @DrawableRes
    private int zzawr;
    @DrawableRes
    private int zzaws;
    @DrawableRes
    private int zzawt;
    private UIMediaController zzawG;

    public void onInflate(Context context, AttributeSet attributeSet, Bundle bundle) {
        super.onInflate(context, attributeSet, bundle);
        AttributeSet attributeSet2 = attributeSet;
        Context context2 = context;
        MiniControllerFragment miniControllerFragment = this;
        if (miniControllerFragment.zzawz == null) {
            TypedArray typedArray = context2.obtainStyledAttributes(attributeSet2, R.styleable.CastMiniController, R.attr.castMiniControllerStyle, R.style.CastMiniController);
            miniControllerFragment.zzawI = typedArray.getBoolean(R.styleable.CastMiniController_castShowImageThumbnail, true);
            miniControllerFragment.zzawJ = typedArray.getResourceId(R.styleable.CastMiniController_castTitleTextAppearance, 0);
            miniControllerFragment.zzawK = typedArray.getResourceId(R.styleable.CastMiniController_castSubtitleTextAppearance, 0);
            miniControllerFragment.zzawM = typedArray.getResourceId(R.styleable.CastMiniController_castBackground, 0);
            miniControllerFragment.zzawN = typedArray.getColor(R.styleable.CastMiniController_castProgressBarColor, 0);
            miniControllerFragment.zzawu = typedArray.getResourceId(R.styleable.CastMiniController_castButtonColor, 0);
            miniControllerFragment.zzawl = typedArray.getResourceId(R.styleable.CastMiniController_castPlayButtonDrawable, 0);
            miniControllerFragment.zzawm = typedArray.getResourceId(R.styleable.CastMiniController_castPauseButtonDrawable, 0);
            miniControllerFragment.zzawn = typedArray.getResourceId(R.styleable.CastMiniController_castStopButtonDrawable, 0);
            miniControllerFragment.zzawP = typedArray.getResourceId(R.styleable.CastMiniController_castPlayButtonDrawable, 0);
            miniControllerFragment.zzawQ = typedArray.getResourceId(R.styleable.CastMiniController_castPauseButtonDrawable, 0);
            miniControllerFragment.zzawR = typedArray.getResourceId(R.styleable.CastMiniController_castStopButtonDrawable, 0);
            miniControllerFragment.zzawo = typedArray.getResourceId(R.styleable.CastMiniController_castSkipPreviousButtonDrawable, 0);
            miniControllerFragment.zzawp = typedArray.getResourceId(R.styleable.CastMiniController_castSkipNextButtonDrawable, 0);
            miniControllerFragment.zzawq = typedArray.getResourceId(R.styleable.CastMiniController_castRewind30ButtonDrawable, 0);
            miniControllerFragment.zzawr = typedArray.getResourceId(R.styleable.CastMiniController_castForward30ButtonDrawable, 0);
            miniControllerFragment.zzaws = typedArray.getResourceId(R.styleable.CastMiniController_castMuteToggleButtonDrawable, 0);
            miniControllerFragment.zzawt = typedArray.getResourceId(R.styleable.CastMiniController_castClosedCaptionsButtonDrawable, 0);
            int n = typedArray.getResourceId(R.styleable.CastMiniController_castControlButtons, 0);
            if (n != 0) {
                TypedArray typedArray2 = context2.getResources().obtainTypedArray(n);
                zzbr.zzaf((typedArray2.length() == 3 ? 1 : 0) != 0);
                miniControllerFragment.zzawz = new int[typedArray2.length()];
                for (int i = 0; i < typedArray2.length(); ++i) {
                    miniControllerFragment.zzawz[i] = typedArray2.getResourceId(i, 0);
                }
                typedArray2.recycle();
                if (miniControllerFragment.zzawI) {
                    miniControllerFragment.zzawz[0] = R.id.cast_button_type_empty;
                }
                miniControllerFragment.zzawO = 0;
                int[] nArray = miniControllerFragment.zzawz;
                int n2 = miniControllerFragment.zzawz.length;
                for (int i = 0; i < n2; ++i) {
                    if (nArray[i] == R.id.cast_button_type_empty) continue;
                    ++miniControllerFragment.zzawO;
                }
            } else {
                zzarM.zzf("Unable to read attribute castControlButtons.", new Object[0]);
                miniControllerFragment.zzawz = new int[]{R.id.cast_button_type_empty, R.id.cast_button_type_empty, R.id.cast_button_type_empty};
            }
            typedArray.recycle();
        }
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        this.zzawG = new UIMediaController((Activity)this.getActivity());
        View view = layoutInflater.inflate(R.layout.cast_mini_controller, viewGroup);
        view.setVisibility(8);
        this.zzawG.bindViewVisibilityToMediaSession(view, 8);
        RelativeLayout relativeLayout = (RelativeLayout)view.findViewById(R.id.container_current);
        if (this.zzawM != 0) {
            relativeLayout.setBackgroundResource(this.zzawM);
        }
        ImageView imageView = (ImageView)view.findViewById(R.id.icon_view);
        TextView textView = (TextView)view.findViewById(R.id.title_view);
        if (this.zzawJ != 0) {
            textView.setTextAppearance((Context)this.getActivity(), this.zzawJ);
        }
        this.zzawL = (TextView)view.findViewById(R.id.subtitle_view);
        if (this.zzawK != 0) {
            this.zzawL.setTextAppearance((Context)this.getActivity(), this.zzawK);
        }
        ProgressBar progressBar = (ProgressBar)view.findViewById(R.id.progressBar);
        if (this.zzawN != 0) {
            ((LayerDrawable)progressBar.getProgressDrawable()).setColorFilter(this.zzawN, PorterDuff.Mode.SRC_IN);
        }
        this.zzawG.bindTextViewToMetadataOfCurrentItem(textView, "com.google.android.gms.cast.metadata.TITLE");
        this.zzawG.bindTextViewToSmartSubtitle(this.zzawL);
        this.zzawG.bindProgressBar(progressBar);
        this.zzawG.bindViewToLaunchExpandedController((View)relativeLayout);
        if (this.zzawI) {
            int n = this.getResources().getDimensionPixelSize(R.dimen.cast_mini_controller_icon_width);
            int n2 = this.getResources().getDimensionPixelSize(R.dimen.cast_mini_controller_icon_height);
            this.zzawG.bindImageViewToImageOfCurrentItem(imageView, new ImageHints(2, n, n2), R.drawable.cast_album_art_placeholder);
        } else {
            imageView.setVisibility(8);
        }
        this.zzawA[0] = (ImageView)relativeLayout.findViewById(R.id.button_0);
        this.zzawA[1] = (ImageView)relativeLayout.findViewById(R.id.button_1);
        this.zzawA[2] = (ImageView)relativeLayout.findViewById(R.id.button_2);
        this.zza(relativeLayout, R.id.button_0, 0);
        this.zza(relativeLayout, R.id.button_1, 1);
        this.zza(relativeLayout, R.id.button_2, 2);
        return view;
    }

    public void onDestroy() {
        if (this.zzawG != null) {
            this.zzawG.dispose();
            this.zzawG = null;
        }
        super.onDestroy();
    }

    @Override
    public final int getButtonSlotCount() {
        return 3;
    }

    @Override
    public final int getButtonTypeAt(int n) throws IndexOutOfBoundsException {
        return this.zzawz[n];
    }

    @Override
    public final ImageView getButtonImageViewAt(int n) throws IndexOutOfBoundsException {
        return this.zzawA[n];
    }

    @Override
    public UIMediaController getUIMediaController() {
        return this.zzawG;
    }

    private final void zza(RelativeLayout relativeLayout, int n, int n2) {
        ImageView imageView = (ImageView)relativeLayout.findViewById(n);
        int n3 = this.zzawz[n2];
        if (n3 == R.id.cast_button_type_empty) {
            imageView.setVisibility(4);
            return;
        }
        if (n3 != R.id.cast_button_type_custom) {
            if (n3 == R.id.cast_button_type_play_pause_toggle) {
                int n4 = this.zzawl;
                int n5 = this.zzawm;
                int n6 = this.zzawn;
                if (this.zzawO == 1) {
                    n4 = this.zzawP;
                    n5 = this.zzawQ;
                    n6 = this.zzawR;
                }
                Drawable drawable2 = zzb.zza(this.getContext(), this.zzawu, n4);
                Drawable drawable3 = zzb.zza(this.getContext(), this.zzawu, n5);
                Drawable drawable4 = zzb.zza(this.getContext(), this.zzawu, n6);
                imageView.setImageDrawable(drawable3);
                int n7 = n;
                MiniControllerFragment miniControllerFragment = this;
                ProgressBar progressBar = new ProgressBar(miniControllerFragment.getContext());
                RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
                layoutParams.addRule(8, n7);
                layoutParams.addRule(6, n7);
                layoutParams.addRule(5, n7);
                layoutParams.addRule(7, n7);
                layoutParams.addRule(15);
                progressBar.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                progressBar.setVisibility(8);
                Drawable drawable5 = progressBar.getIndeterminateDrawable();
                if (miniControllerFragment.zzawN != 0 && drawable5 != null) {
                    drawable5.setColorFilter(miniControllerFragment.zzawN, PorterDuff.Mode.SRC_IN);
                }
                ProgressBar progressBar2 = progressBar;
                relativeLayout.addView((View)progressBar2);
                this.zzawG.bindImageViewToPlayPauseToggle(imageView, drawable2, drawable3, drawable4, (View)progressBar2, true);
                return;
            }
            if (n3 == R.id.cast_button_type_skip_previous) {
                imageView.setImageDrawable(zzb.zza(this.getContext(), this.zzawu, this.zzawo));
                imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_skip_prev));
                this.zzawG.bindViewToSkipPrev((View)imageView, 0);
                return;
            }
            if (n3 == R.id.cast_button_type_skip_next) {
                imageView.setImageDrawable(zzb.zza(this.getContext(), this.zzawu, this.zzawp));
                imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_skip_next));
                this.zzawG.bindViewToSkipNext((View)imageView, 0);
                return;
            }
            if (n3 == R.id.cast_button_type_rewind_30_seconds) {
                imageView.setImageDrawable(zzb.zza(this.getContext(), this.zzawu, this.zzawq));
                imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_rewind_30));
                this.zzawG.bindViewToRewind((View)imageView, 30000L);
                return;
            }
            if (n3 == R.id.cast_button_type_forward_30_seconds) {
                imageView.setImageDrawable(zzb.zza(this.getContext(), this.zzawu, this.zzawr));
                imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_forward_30));
                this.zzawG.bindViewToForward((View)imageView, 30000L);
                return;
            }
            if (n3 == R.id.cast_button_type_mute_toggle) {
                imageView.setImageDrawable(zzb.zza(this.getContext(), this.zzawu, this.zzaws));
                this.zzawG.bindImageViewToMuteToggle(imageView);
                return;
            }
            if (n3 == R.id.cast_button_type_closed_caption) {
                imageView.setImageDrawable(zzb.zza(this.getContext(), this.zzawu, this.zzawt));
                this.zzawG.bindViewToClosedCaption((View)imageView);
            }
        }
    }
}

