/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.view.View;
import android.widget.ImageView;
import com.google.android.gms.R;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.uicontroller.UIController;
import com.google.android.gms.internal.zzaxv;

public final class zzaxu
extends UIController {
    private final ImageView zzavt;
    private final View zzavI;
    private final boolean zzavJ;
    private final Drawable zzavK;
    private final String zzavL;
    private final Drawable zzavM;
    private final String zzavN;
    private final Drawable zzavO;
    private final String zzavP;
    private final View.OnClickListener zzavr;

    public zzaxu(@NonNull ImageView imageView, Context context, @NonNull Drawable drawable2, @NonNull Drawable drawable3, Drawable drawable4, View view, boolean bl) {
        this.zzavt = imageView;
        this.zzavK = drawable2;
        this.zzavM = drawable3;
        this.zzavO = drawable4 != null ? drawable4 : drawable3;
        this.zzavL = context.getString(R.string.cast_play);
        this.zzavN = context.getString(R.string.cast_pause);
        this.zzavP = context.getString(R.string.cast_stop);
        this.zzavI = view;
        this.zzavJ = bl;
        this.zzavr = new zzaxv(this);
    }

    @Override
    public final void onSessionConnected(CastSession castSession) {
        super.onSessionConnected(castSession);
        this.zzavt.setOnClickListener(this.zzavr);
        this.zzoi();
    }

    @Override
    public final void onSessionEnded() {
        this.zzavt.setOnClickListener(null);
        super.onSessionEnded();
    }

    @Override
    public final void onMediaStatusUpdated() {
        this.zzoi();
    }

    @Override
    public final void onSendingRemoteMediaRequest() {
        this.zzX(true);
    }

    private final void zzoi() {
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession()) {
            return;
        }
        if (remoteMediaClient.isPaused()) {
            this.zza(this.zzavK, this.zzavL);
            return;
        }
        if (remoteMediaClient.isPlaying()) {
            if (remoteMediaClient.isLiveStream()) {
                this.zza(this.zzavO, this.zzavP);
                return;
            }
            this.zza(this.zzavM, this.zzavN);
            return;
        }
        if (remoteMediaClient.isBuffering()) {
            this.zzX(false);
            return;
        }
        if (remoteMediaClient.isLoadingNextItem()) {
            this.zzX(true);
        }
    }

    private final void zza(Drawable drawable2, String string2) {
        this.zzavt.setImageDrawable(drawable2);
        this.zzavt.setContentDescription((CharSequence)string2);
        this.zzavt.setVisibility(0);
        this.zzavt.setEnabled(true);
        if (this.zzavI != null) {
            this.zzavI.setVisibility(8);
        }
    }

    private final void zzX(boolean bl) {
        if (this.zzavI != null) {
            this.zzavI.setVisibility(0);
        }
        this.zzavt.setVisibility(this.zzavJ ? 4 : 0);
        this.zzavt.setEnabled(!bl);
    }

    static /* synthetic */ RemoteMediaClient zza(zzaxu zzaxu2) {
        return zzaxu2.getRemoteMediaClient();
    }
}

