/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.cast.LaunchOptions;
import com.google.android.gms.cast.framework.media.CastMediaOptions;
import com.google.android.gms.cast.framework.zzb;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CastOptions
extends zza {
    public static final Parcelable.Creator<CastOptions> CREATOR = new zzb();
    private final String zzarS;
    private final List<String> zzarT;
    private final boolean zzarU;
    private final LaunchOptions zzapW;
    private final boolean zzarV;
    private final CastMediaOptions zzarW;
    private final boolean zzarX;
    private final double zzarY;

    CastOptions(String string, List<String> list, boolean bl, LaunchOptions launchOptions, boolean bl2, CastMediaOptions castMediaOptions, boolean bl3, double d) {
        this.zzarS = TextUtils.isEmpty((CharSequence)string) ? "" : string;
        int n = list == null ? 0 : list.size();
        this.zzarT = new ArrayList<String>(n);
        if (n > 0) {
            this.zzarT.addAll(list);
        }
        this.zzarU = bl;
        this.zzapW = launchOptions == null ? new LaunchOptions() : launchOptions;
        this.zzarV = bl2;
        this.zzarW = castMediaOptions;
        this.zzarX = bl3;
        this.zzarY = d;
    }

    public String getReceiverApplicationId() {
        return this.zzarS;
    }

    public List<String> getSupportedNamespaces() {
        return Collections.unmodifiableList(this.zzarT);
    }

    public boolean getStopReceiverApplicationWhenEndingSession() {
        return this.zzarU;
    }

    public LaunchOptions getLaunchOptions() {
        return this.zzapW;
    }

    public boolean getResumeSavedSession() {
        return this.zzarV;
    }

    public CastMediaOptions getCastMediaOptions() {
        return this.zzarW;
    }

    public boolean getEnableReconnectionService() {
        return this.zzarX;
    }

    public double getVolumeDeltaBeforeIceCreamSandwich() {
        return this.zzarY;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        CastOptions castOptions = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)2, (String)castOptions.getReceiverApplicationId(), (boolean)false);
        zzd.zzb((Parcel)parcel2, (int)3, castOptions.getSupportedNamespaces(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)4, (boolean)castOptions.getStopReceiverApplicationWhenEndingSession());
        zzd.zza((Parcel)parcel2, (int)5, (Parcelable)castOptions.getLaunchOptions(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)6, (boolean)castOptions.getResumeSavedSession());
        zzd.zza((Parcel)parcel2, (int)7, (Parcelable)castOptions.getCastMediaOptions(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)8, (boolean)castOptions.getEnableReconnectionService());
        zzd.zza((Parcel)parcel2, (int)9, (double)castOptions.getVolumeDeltaBeforeIceCreamSandwich());
        zzd.zzI((Parcel)parcel2, (int)n2);
    }

    public static final class Builder {
        private String zzarS;
        private List<String> zzarT = new ArrayList<String>();
        private boolean zzarU;
        private LaunchOptions zzapW = new LaunchOptions();
        private boolean zzarV = true;
        private CastMediaOptions zzarW = new CastMediaOptions.Builder().build();
        private boolean zzarX = true;
        private double zzarY = 0.05f;

        public final Builder setReceiverApplicationId(String string) {
            this.zzarS = string;
            return this;
        }

        public final Builder setSupportedNamespaces(List<String> list) {
            this.zzarT = list;
            return this;
        }

        public final Builder setStopReceiverApplicationWhenEndingSession(boolean bl) {
            this.zzarU = bl;
            return this;
        }

        public final Builder setLaunchOptions(LaunchOptions launchOptions) {
            this.zzapW = launchOptions;
            return this;
        }

        public final Builder setResumeSavedSession(boolean bl) {
            this.zzarV = bl;
            return this;
        }

        public final Builder setCastMediaOptions(CastMediaOptions castMediaOptions) {
            this.zzarW = castMediaOptions;
            return this;
        }

        public final Builder setEnableReconnectionService(boolean bl) {
            this.zzarX = bl;
            return this;
        }

        public final Builder setVolumeDeltaBeforeIceCreamSandwich(double d) throws IllegalArgumentException {
            if (d <= 0.0 || d > 0.5) {
                throw new IllegalArgumentException("volumeDelta must be greater than 0 and less or equal to 0.5");
            }
            this.zzarY = d;
            return this;
        }

        public final CastOptions build() {
            return new CastOptions(this.zzarS, this.zzarT, this.zzarU, this.zzapW, this.zzarV, this.zzarW, this.zzarX, this.zzarY);
        }
    }
}

