/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import com.google.android.gms.cast.AdBreakInfo;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.cast.framework.media.zzaa;
import com.google.android.gms.cast.framework.media.zzab;
import com.google.android.gms.cast.framework.media.zzac;
import com.google.android.gms.cast.framework.media.zzad;
import com.google.android.gms.cast.framework.media.zzae;
import com.google.android.gms.cast.framework.media.zzaf;
import com.google.android.gms.cast.framework.media.zzag;
import com.google.android.gms.cast.framework.media.zzah;
import com.google.android.gms.cast.framework.media.zzai;
import com.google.android.gms.cast.framework.media.zzi;
import com.google.android.gms.cast.framework.media.zzj;
import com.google.android.gms.cast.framework.media.zzk;
import com.google.android.gms.cast.framework.media.zzl;
import com.google.android.gms.cast.framework.media.zzm;
import com.google.android.gms.cast.framework.media.zzn;
import com.google.android.gms.cast.framework.media.zzo;
import com.google.android.gms.cast.framework.media.zzp;
import com.google.android.gms.cast.framework.media.zzq;
import com.google.android.gms.cast.framework.media.zzr;
import com.google.android.gms.cast.framework.media.zzs;
import com.google.android.gms.cast.framework.media.zzt;
import com.google.android.gms.cast.framework.media.zzu;
import com.google.android.gms.cast.framework.media.zzv;
import com.google.android.gms.cast.framework.media.zzw;
import com.google.android.gms.cast.framework.media.zzx;
import com.google.android.gms.cast.framework.media.zzy;
import com.google.android.gms.cast.framework.media.zzz;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.internal.zzaxr;
import com.google.android.gms.internal.zzaxw;
import com.google.android.gms.internal.zzayo;
import com.google.android.gms.internal.zzayp;
import com.google.android.gms.internal.zzayr;
import com.google.android.gms.internal.zzays;
import com.google.android.gms.internal.zzbax;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONObject;

public class RemoteMediaClient
implements Cast.MessageReceivedCallback {
    private final Object mLock;
    private final Handler mHandler;
    private final zzayo zzaqP;
    private final zza zzauu;
    private final Cast.CastApi zzasb;
    private GoogleApiClient zzXj;
    private final List<Listener> mListeners = new CopyOnWriteArrayList<Listener>();
    private final Map<ProgressListener, zzd> zzauv = new ConcurrentHashMap<ProgressListener, zzd>();
    private final Map<Long, zzd> zzauw = new ConcurrentHashMap<Long, zzd>();
    private ParseAdsInfoCallback zzaux;
    public static final String NAMESPACE = zzayo.NAMESPACE;
    public static final int RESUME_STATE_UNCHANGED = 0;
    public static final int RESUME_STATE_PLAY = 1;
    public static final int RESUME_STATE_PAUSE = 2;
    public static final int STATUS_SUCCEEDED = 0;
    public static final int STATUS_FAILED = 2100;
    public static final int STATUS_REPLACED = 2103;

    public RemoteMediaClient(@NonNull zzayo zzayo2, @NonNull Cast.CastApi castApi) {
        this.mLock = new Object();
        this.mHandler = new Handler(Looper.getMainLooper());
        this.zzauu = new zza();
        this.zzasb = castApi;
        this.zzaqP = (zzayo)zzbo.zzu((Object)zzayo2);
        this.zzaqP.zza((zzayp)new zzi(this));
        this.zzaqP.zza((zzayr)this.zzauu);
    }

    public final void zzc(GoogleApiClient googleApiClient) throws IOException {
        if (this.zzXj == googleApiClient) {
            return;
        }
        if (this.zzXj != null) {
            this.zzaqP.zzoz();
            this.zzasb.removeMessageReceivedCallbacks(this.zzXj, this.getNamespace());
            this.zzauu.zzb(null);
            this.mHandler.removeCallbacksAndMessages(null);
        }
        this.zzXj = googleApiClient;
        if (this.zzXj != null) {
            this.zzauu.zzb(this.zzXj);
        }
    }

    public final void zznX() throws IOException {
        if (this.zzXj != null) {
            this.zzasb.setMessageReceivedCallbacks(this.zzXj, this.getNamespace(), (Cast.MessageReceivedCallback)this);
        }
    }

    public PendingResult<MediaChannelResult> load(MediaInfo mediaInfo) {
        return this.load(mediaInfo, true, 0L, null, null);
    }

    public PendingResult<MediaChannelResult> load(MediaInfo mediaInfo, boolean bl) {
        return this.load(mediaInfo, bl, 0L, null, null);
    }

    public PendingResult<MediaChannelResult> load(MediaInfo mediaInfo, boolean bl, long l) {
        return this.load(mediaInfo, bl, l, null, null);
    }

    public PendingResult<MediaChannelResult> load(MediaInfo mediaInfo, boolean bl, long l, JSONObject jSONObject) {
        return this.load(mediaInfo, bl, l, null, jSONObject);
    }

    public PendingResult<MediaChannelResult> load(MediaInfo mediaInfo, boolean bl, long l, long[] lArray, JSONObject jSONObject) {
        zzbo.zzcz((String)"Must be called from the main thread.");
        this.zznY();
        return this.zza(new zzt(this, this.zzXj, mediaInfo, bl, l, lArray, jSONObject));
    }

    public PendingResult<MediaChannelResult> pause() {
        return this.pause(null);
    }

    public PendingResult<MediaChannelResult> pause(JSONObject jSONObject) {
        zzbo.zzcz((String)"Must be called from the main thread.");
        this.zznY();
        return this.zza(new zzy(this, this.zzXj, jSONObject));
    }

    public PendingResult<MediaChannelResult> stop() {
        return this.stop(null);
    }

    public PendingResult<MediaChannelResult> stop(JSONObject jSONObject) {
        zzbo.zzcz((String)"Must be called from the main thread.");
        this.zznY();
        return this.zza(new zzz(this, this.zzXj, jSONObject));
    }

    public PendingResult<MediaChannelResult> play() {
        return this.play(null);
    }

    public PendingResult<MediaChannelResult> play(JSONObject jSONObject) {
        zzbo.zzcz((String)"Must be called from the main thread.");
        this.zznY();
        return this.zza(new zzaa(this, this.zzXj, jSONObject));
    }

    public PendingResult<MediaChannelResult> seek(long l) {
        return this.seek(l, 0, null);
    }

    public PendingResult<MediaChannelResult> seek(long l, int n) {
        return this.seek(l, n, null);
    }

    public PendingResult<MediaChannelResult> seek(long l, int n, JSONObject jSONObject) {
        zzbo.zzcz((String)"Must be called from the main thread.");
        this.zznY();
        return this.zza(new zzab(this, this.zzXj, l, n, jSONObject));
    }

    public PendingResult<MediaChannelResult> setStreamVolume(double d) throws IllegalArgumentException {
        return this.setStreamVolume(d, null);
    }

    public PendingResult<MediaChannelResult> setStreamVolume(double d, JSONObject jSONObject) throws IllegalArgumentException {
        zzbo.zzcz((String)"Must be called from the main thread.");
        this.zznY();
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new IllegalArgumentException(new StringBuilder(41).append("Volume cannot be ").append(d).toString());
        }
        return this.zza(new zzac(this, this.zzXj, d, jSONObject));
    }

    public PendingResult<MediaChannelResult> setStreamMute(boolean bl) {
        return this.setStreamMute(bl, null);
    }

    public PendingResult<MediaChannelResult> setStreamMute(boolean bl, JSONObject jSONObject) {
        zzbo.zzcz((String)"Must be called from the main thread.");
        this.zznY();
        return this.zza(new zzad(this, this.zzXj, bl, jSONObject));
    }

    public PendingResult<MediaChannelResult> requestStatus() {
        zzbo.zzcz((String)"Must be called from the main thread.");
        this.zznY();
        return this.zza(new zzae(this, this.zzXj));
    }

    public PendingResult<MediaChannelResult> setActiveMediaTracks(long[] lArray) {
        zzbo.zzcz((String)"Must be called from the main thread.");
        this.zznY();
        if (lArray == null) {
            throw new IllegalArgumentException("trackIds cannot be null");
        }
        return this.zza(new zzj(this, this.zzXj, lArray));
    }

    public PendingResult<MediaChannelResult> setTextTrackStyle(TextTrackStyle textTrackStyle) {
        zzbo.zzcz((String)"Must be called from the main thread.");
        this.zznY();
        if (textTrackStyle == null) {
            throw new IllegalArgumentException("trackStyle cannot be null");
        }
        return this.zza(new zzk(this, this.zzXj, textTrackStyle));
    }

    public PendingResult<MediaChannelResult> queueLoad(MediaQueueItem[] mediaQueueItemArray, int n, int n2, JSONObject jSONObject) throws IllegalArgumentException {
        return this.queueLoad(mediaQueueItemArray, n, n2, -1L, jSONObject);
    }

    public PendingResult<MediaChannelResult> queueLoad(MediaQueueItem[] mediaQueueItemArray, int n, int n2, long l, JSONObject jSONObject) throws IllegalArgumentException {
        zzbo.zzcz((String)"Must be called from the main thread.");
        this.zznY();
        return this.zza(new zzl(this, this.zzXj, mediaQueueItemArray, n, n2, l, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueInsertItems(MediaQueueItem[] mediaQueueItemArray, int n, JSONObject jSONObject) throws IllegalArgumentException {
        zzbo.zzcz((String)"Must be called from the main thread.");
        this.zznY();
        return this.zza(new zzm(this, this.zzXj, mediaQueueItemArray, n, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueAppendItem(MediaQueueItem mediaQueueItem, JSONObject jSONObject) throws IllegalArgumentException {
        return this.queueInsertItems(new MediaQueueItem[]{mediaQueueItem}, 0, jSONObject);
    }

    public PendingResult<MediaChannelResult> queueInsertAndPlayItem(MediaQueueItem mediaQueueItem, int n, JSONObject jSONObject) {
        return this.queueInsertAndPlayItem(mediaQueueItem, n, -1L, jSONObject);
    }

    public PendingResult<MediaChannelResult> queueInsertAndPlayItem(MediaQueueItem mediaQueueItem, int n, long l, JSONObject jSONObject) {
        zzbo.zzcz((String)"Must be called from the main thread.");
        this.zznY();
        return this.zza(new zzn(this, this.zzXj, mediaQueueItem, n, l, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueUpdateItems(MediaQueueItem[] mediaQueueItemArray, JSONObject jSONObject) {
        zzbo.zzcz((String)"Must be called from the main thread.");
        this.zznY();
        return this.zza(new zzo(this, this.zzXj, mediaQueueItemArray, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueRemoveItems(int[] nArray, JSONObject jSONObject) throws IllegalArgumentException {
        zzbo.zzcz((String)"Must be called from the main thread.");
        this.zznY();
        return this.zza(new zzp(this, this.zzXj, nArray, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueReorderItems(int[] nArray, int n, JSONObject jSONObject) throws IllegalArgumentException {
        zzbo.zzcz((String)"Must be called from the main thread.");
        this.zznY();
        return this.zza(new zzq(this, this.zzXj, nArray, n, jSONObject));
    }

    public PendingResult<MediaChannelResult> queuePrev(JSONObject jSONObject) {
        zzbo.zzcz((String)"Must be called from the main thread.");
        this.zznY();
        return this.zza(new zzr(this, this.zzXj, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueNext(JSONObject jSONObject) {
        zzbo.zzcz((String)"Must be called from the main thread.");
        this.zznY();
        return this.zza(new zzs(this, this.zzXj, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueSetRepeatMode(int n, JSONObject jSONObject) {
        zzbo.zzcz((String)"Must be called from the main thread.");
        this.zznY();
        return this.zza(new zzu(this, this.zzXj, n, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueRemoveItem(int n, JSONObject jSONObject) {
        zzbo.zzcz((String)"Must be called from the main thread.");
        this.zznY();
        return this.zza(new zzv(this, this.zzXj, n, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueJumpToItem(int n, JSONObject jSONObject) {
        return this.queueJumpToItem(n, -1L, jSONObject);
    }

    public PendingResult<MediaChannelResult> queueJumpToItem(int n, long l, JSONObject jSONObject) {
        zzbo.zzcz((String)"Must be called from the main thread.");
        this.zznY();
        return this.zza(new zzw(this, this.zzXj, n, l, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueMoveItemToNewIndex(int n, int n2, JSONObject jSONObject) {
        zzbo.zzcz((String)"Must be called from the main thread.");
        this.zznY();
        return this.zza(new zzx(this, this.zzXj, n, n2, jSONObject));
    }

    private final int zzX(int n) {
        zzbo.zzcz((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        for (int i = 0; i < mediaStatus.getQueueItemCount(); ++i) {
            if (mediaStatus.getQueueItem(i).getItemId() != n) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getApproximateStreamPosition() {
        Object object = this.mLock;
        synchronized (object) {
            zzbo.zzcz((String)"Must be called from the main thread.");
            return this.zzaqP.getApproximateStreamPosition();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getStreamDuration() {
        Object object = this.mLock;
        synchronized (object) {
            zzbo.zzcz((String)"Must be called from the main thread.");
            return this.zzaqP.getStreamDuration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaStatus getMediaStatus() {
        Object object = this.mLock;
        synchronized (object) {
            zzbo.zzcz((String)"Must be called from the main thread.");
            return this.zzaqP.getMediaStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaInfo getMediaInfo() {
        Object object = this.mLock;
        synchronized (object) {
            zzbo.zzcz((String)"Must be called from the main thread.");
            return this.zzaqP.getMediaInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPlayerState() {
        Object object = this.mLock;
        synchronized (object) {
            zzbo.zzcz((String)"Must be called from the main thread.");
            MediaStatus mediaStatus = this.getMediaStatus();
            return mediaStatus != null ? mediaStatus.getPlayerState() : 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIdleReason() {
        Object object = this.mLock;
        synchronized (object) {
            zzbo.zzcz((String)"Must be called from the main thread.");
            MediaStatus mediaStatus = this.getMediaStatus();
            return mediaStatus != null ? mediaStatus.getIdleReason() : 0;
        }
    }

    public boolean isLiveStream() {
        zzbo.zzcz((String)"Must be called from the main thread.");
        MediaInfo mediaInfo = this.getMediaInfo();
        return mediaInfo != null && mediaInfo.getStreamType() == 2;
    }

    public boolean isPlaying() {
        zzbo.zzcz((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus != null && mediaStatus.getPlayerState() == 2;
    }

    public boolean isPaused() {
        zzbo.zzcz((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus != null && (mediaStatus.getPlayerState() == 3 || this.isLiveStream() && this.getIdleReason() == 2);
    }

    public boolean isBuffering() {
        zzbo.zzcz((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus != null && mediaStatus.getPlayerState() == 4;
    }

    public boolean isLoadingNextItem() {
        zzbo.zzcz((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus != null && mediaStatus.getLoadingItemId() != 0;
    }

    public MediaQueueItem getCurrentItem() {
        zzbo.zzcz((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        if (mediaStatus == null) {
            return null;
        }
        return mediaStatus.getQueueItemById(mediaStatus.getCurrentItemId());
    }

    public MediaQueueItem getLoadingItem() {
        zzbo.zzcz((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        if (mediaStatus == null) {
            return null;
        }
        return mediaStatus.getQueueItemById(mediaStatus.getLoadingItemId());
    }

    public MediaQueueItem getPreloadedItem() {
        zzbo.zzcz((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        if (mediaStatus == null) {
            return null;
        }
        return mediaStatus.getQueueItemById(mediaStatus.getPreloadedItemId());
    }

    public void togglePlayback() {
        zzbo.zzcz((String)"Must be called from the main thread.");
        int n = this.getPlayerState();
        if (n == 4 || n == 2) {
            this.pause();
            return;
        }
        this.play();
    }

    public boolean hasMediaSession() {
        zzbo.zzcz((String)"Must be called from the main thread.");
        return this.isBuffering() || this.isPlaying() || this.isPaused() || this.isLoadingNextItem();
    }

    public void addListener(Listener listener) {
        zzbo.zzcz((String)"Must be called from the main thread.");
        if (listener != null) {
            this.mListeners.add(listener);
        }
    }

    public void removeListener(Listener listener) {
        zzbo.zzcz((String)"Must be called from the main thread.");
        if (listener != null) {
            this.mListeners.remove(listener);
        }
    }

    public boolean addProgressListener(ProgressListener progressListener, long l) {
        zzbo.zzcz((String)"Must be called from the main thread.");
        if (progressListener == null || this.zzauv.containsKey(progressListener)) {
            return false;
        }
        zzd zzd2 = this.zzauw.get(l);
        if (zzd2 == null) {
            zzd2 = new zzd(l);
            this.zzauw.put(l, zzd2);
        }
        zzd2.zza(progressListener);
        this.zzauv.put(progressListener, zzd2);
        if (this.hasMediaSession()) {
            zzd2.start();
        }
        return true;
    }

    public void removeProgressListener(ProgressListener progressListener) {
        zzbo.zzcz((String)"Must be called from the main thread.");
        zzd zzd2 = this.zzauv.remove(progressListener);
        if (zzd2 != null) {
            zzd2.zzb(progressListener);
            if (!zzd2.zzoc()) {
                this.zzauw.remove(zzd2.zzob());
                zzd2.stop();
            }
        }
    }

    public void setParseAdsInfoCallback(ParseAdsInfoCallback parseAdsInfoCallback) {
        zzbo.zzcz((String)"Must be called from the main thread.");
        this.zzaux = parseAdsInfoCallback;
    }

    public boolean isPlayingAd() {
        zzbo.zzcz((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus != null && mediaStatus.isPlayingAd();
    }

    public String getNamespace() {
        zzbo.zzcz((String)"Must be called from the main thread.");
        return this.zzaqP.getNamespace();
    }

    public void onMessageReceived(CastDevice castDevice, String string2, String string3) {
        this.zzaqP.zzch(string3);
    }

    private final void zznY() throws IllegalStateException {
        if (this.zzXj == null) {
            throw new IllegalStateException("No connection");
        }
    }

    private final zzb zza(zzb zzb2) {
        try {
            this.zzXj.zze((zzbax)zzb2);
            return zzb2;
        }
        catch (IllegalStateException illegalStateException) {
            try {
                zzb2.setResult((MediaChannelResult)zzb2.zzb(new Status(2100)));
                return zzb2;
            }
            catch (Throwable throwable) {
                return zzb2;
            }
        }
    }

    private final void zza(Set<ProgressListener> set) {
        if (this.isBuffering() || this.isPaused()) {
            return;
        }
        HashSet<ProgressListener> hashSet = new HashSet<ProgressListener>(set);
        if (this.isPlaying()) {
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                ((ProgressListener)iterator.next()).onProgressUpdated(this.getApproximateStreamPosition(), this.getStreamDuration());
            }
            return;
        }
        if (this.isLoadingNextItem()) {
            MediaQueueItem mediaQueueItem = this.getLoadingItem();
            if (mediaQueueItem != null && mediaQueueItem.getMedia() != null) {
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    ((ProgressListener)iterator.next()).onProgressUpdated(0L, mediaQueueItem.getMedia().getStreamDuration());
                }
            }
            return;
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            ((ProgressListener)iterator.next()).onProgressUpdated(0L, 0L);
        }
    }

    private final void zznZ() {
        for (zzd zzd2 : this.zzauw.values()) {
            if (this.hasMediaSession() && !zzd2.isStarted()) {
                zzd2.start();
            } else if (!this.hasMediaSession() && zzd2.isStarted()) {
                zzd2.stop();
            }
            if (!zzd2.isStarted() || !this.isBuffering() && !this.isPaused() && !this.isLoadingNextItem()) continue;
            this.zza(zzd2.zzauB);
        }
    }

    static /* synthetic */ void zza(RemoteMediaClient remoteMediaClient) {
        remoteMediaClient.zznZ();
    }

    static /* synthetic */ ParseAdsInfoCallback zzc(RemoteMediaClient remoteMediaClient) {
        return remoteMediaClient.zzaux;
    }

    static /* synthetic */ Object zzd(RemoteMediaClient remoteMediaClient) {
        return remoteMediaClient.mLock;
    }

    static /* synthetic */ zzayo zze(RemoteMediaClient remoteMediaClient) {
        return remoteMediaClient.zzaqP;
    }

    static /* synthetic */ int zza(RemoteMediaClient remoteMediaClient, int n) {
        return remoteMediaClient.zzX(n);
    }

    static /* synthetic */ void zza(RemoteMediaClient remoteMediaClient, Set set) {
        remoteMediaClient.zza(set);
    }

    final class zzd {
        private final Set<ProgressListener> zzauB = new HashSet<ProgressListener>();
        private final long zzauC;
        private final Runnable zzauD;
        private boolean zzauE;

        public zzd(long l) {
            this.zzauC = l;
            this.zzauD = new zzai(this, RemoteMediaClient.this);
        }

        public final long zzob() {
            return this.zzauC;
        }

        public final void zza(ProgressListener progressListener) {
            this.zzauB.add(progressListener);
        }

        public final void zzb(ProgressListener progressListener) {
            this.zzauB.remove(progressListener);
        }

        public final boolean zzoc() {
            return !this.zzauB.isEmpty();
        }

        public final void start() {
            RemoteMediaClient.this.mHandler.removeCallbacks(this.zzauD);
            this.zzauE = true;
            RemoteMediaClient.this.mHandler.postDelayed(this.zzauD, this.zzauC);
        }

        public final void stop() {
            RemoteMediaClient.this.mHandler.removeCallbacks(this.zzauD);
            this.zzauE = false;
        }

        public final boolean isStarted() {
            return this.zzauE;
        }

        static /* synthetic */ long zzb(zzd zzd2) {
            return zzd2.zzauC;
        }
    }

    static abstract class zzb
    extends zzaxr<MediaChannelResult> {
        zzays zzarw = new zzag(this);

        zzb(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected void zza(zzaxw zzaxw2) {
        }

        public final /* synthetic */ Result zzb(Status status) {
            Status status2 = status;
            zzb zzb2 = this;
            return new zzah(zzb2, status2);
        }
    }

    static final class zzc
    implements MediaChannelResult {
        private final Status mStatus;
        private final JSONObject zzaoD;

        zzc(Status status, JSONObject jSONObject) {
            this.mStatus = status;
            this.zzaoD = jSONObject;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final JSONObject getCustomData() {
            return this.zzaoD;
        }
    }

    public static interface MediaChannelResult
    extends Result {
        public JSONObject getCustomData();
    }

    final class zza
    implements zzayr {
        private GoogleApiClient zzars;
        private long zzart = 0L;

        public final void zzb(GoogleApiClient googleApiClient) {
            this.zzars = googleApiClient;
        }

        public final long zznl() {
            return ++this.zzart;
        }

        public final void zza(String string2, String string3, long l, String string4) throws IOException {
            if (this.zzars == null) {
                throw new IOException("No GoogleApiClient available");
            }
            Iterator iterator = RemoteMediaClient.this.mListeners.iterator();
            while (iterator.hasNext()) {
                ((Listener)iterator.next()).onSendingRemoteMediaRequest();
            }
            RemoteMediaClient.this.zzasb.sendMessage(this.zzars, string2, string3).setResultCallback((ResultCallback)new zzaf(this, l));
        }
    }

    public static interface ParseAdsInfoCallback {
        public boolean parseIsPlayingAdFromMediaStatus(MediaStatus var1);

        public List<AdBreakInfo> parseAdBreaksFromMediaStatus(MediaStatus var1);
    }

    public static interface ProgressListener {
        public void onProgressUpdated(long var1, long var3);
    }

    public static interface Listener {
        public void onStatusUpdated();

        public void onMetadataUpdated();

        public void onQueueStatusUpdated();

        public void onPreloadStatusUpdated();

        public void onSendingRemoteMediaRequest();

        public void onAdBreakStatusUpdated();
    }
}

