/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Xfermode;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.google.android.gms.R;
import com.google.android.gms.cast.framework.IntroductoryOverlay;
import com.google.android.gms.internal.zzaur;
import com.google.android.gms.internal.zzauw;
import com.google.android.gms.internal.zzauy;

public final class zzauv
extends RelativeLayout
implements IntroductoryOverlay {
    private final boolean zzasC;
    private Activity mActivity;
    private int zzasH;
    private boolean zzasE;
    private IntroductoryOverlay.OnOverlayDismissedListener zzaso;
    private final zzauy zzasI;

    public zzauv(IntroductoryOverlay.Builder builder) {
        this(builder, null, R.attr.castIntroOverlayStyle);
    }

    @TargetApi(value=14)
    private zzauv(IntroductoryOverlay.Builder builder, AttributeSet attributeSet, int n) {
        super((Context)builder.getActivity(), null, n);
        TypedArray typedArray;
        Object object;
        this.mActivity = builder.getActivity();
        this.zzasC = builder.zznD();
        this.zzaso = builder.zznB();
        TypedArray typedArray2 = this.mActivity.getTheme().obtainStyledAttributes(null, R.styleable.CastIntroOverlay, n, R.style.CastIntroOverlay);
        if (builder.zznA() != null) {
            Rect rect = new Rect();
            builder.zznA().getGlobalVisibleRect(rect);
            this.zzasI = new zzauy(null);
            this.zzasI.x = rect.centerX();
            this.zzasI.y = rect.centerY();
            object = new PorterDuffXfermode(PorterDuff.Mode.MULTIPLY);
            typedArray = new Paint();
            typedArray.setColor(-1);
            typedArray.setAlpha(0);
            typedArray.setXfermode((Xfermode)object);
            typedArray.setAntiAlias(true);
            this.zzasI.zzasL = typedArray;
            this.zzasI.zzasM = builder.zznG();
            if (this.zzasI.zzasM == 0.0f) {
                this.zzasI.zzasM = typedArray2.getDimension(R.styleable.CastIntroOverlay_castFocusRadius, 0.0f);
            }
        } else {
            this.zzasI = null;
        }
        LayoutInflater.from((Context)this.mActivity).inflate(R.layout.cast_intro_overlay, (ViewGroup)this);
        this.zzasH = builder.zznC();
        if (this.zzasH == 0) {
            this.zzasH = typedArray2.getColor(R.styleable.CastIntroOverlay_castBackgroundColor, Color.argb((int)0, (int)0, (int)0, (int)0));
        }
        TextView textView = (TextView)this.findViewById(R.id.textTitle);
        if (!TextUtils.isEmpty((CharSequence)builder.zznE())) {
            textView.setText((CharSequence)builder.zznE());
            int n2 = typedArray2.getResourceId(R.styleable.CastIntroOverlay_castTitleTextAppearance, 0);
            if (n2 != 0) {
                textView.setTextAppearance((Context)this.mActivity, n2);
            }
        }
        typedArray = typedArray2;
        object = builder.zznF();
        zzauv zzauv2 = this;
        Object object2 = object;
        if (TextUtils.isEmpty((CharSequence)object)) {
            object2 = typedArray.getString(R.styleable.CastIntroOverlay_castButtonText);
        }
        int n3 = typedArray.getColor(R.styleable.CastIntroOverlay_castButtonBackgroundColor, Color.argb((int)0, (int)0, (int)0, (int)0));
        Button button = (Button)zzauv2.findViewById(R.id.button);
        button.setText((CharSequence)object2);
        button.getBackground().setColorFilter(n3, PorterDuff.Mode.MULTIPLY);
        int n4 = typedArray.getResourceId(R.styleable.CastIntroOverlay_castButtonTextAppearance, 0);
        if (n4 != 0) {
            button.setTextAppearance((Context)zzauv2.mActivity, n4);
        }
        button.setOnClickListener((View.OnClickListener)new zzauw(zzauv2));
        typedArray2.recycle();
        this.setFitsSystemWindows(true);
    }

    @Override
    public final void show() {
        if (this.mActivity == null) {
            return;
        }
        if (zzaur.zzao((Context)this.mActivity)) {
            return;
        }
        if (this.zzasC && IntroductoryOverlay.zza.zzam((Context)this.mActivity)) {
            this.mActivity = null;
            this.zzaso = null;
            return;
        }
        if (!this.zzasE) {
            this.zzasE = true;
            ((ViewGroup)this.mActivity.getWindow().getDecorView()).addView((View)this);
        }
    }

    @Override
    public final void remove() {
        if (this.mActivity != null) {
            ((ViewGroup)this.mActivity.getWindow().getDecorView()).removeView((View)this);
            this.mActivity = null;
        }
        this.zzaso = null;
    }

    protected final void dispatchDraw(Canvas canvas) {
        Bitmap bitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas2 = new Canvas(bitmap);
        canvas2.drawColor(this.zzasH);
        if (this.zzasI != null) {
            canvas2.drawCircle((float)this.zzasI.x, (float)this.zzasI.y, this.zzasI.zzasM, this.zzasI.zzasL);
        }
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, null);
        bitmap.recycle();
        super.dispatchDraw(canvas);
    }

    public final boolean onTouchEvent(MotionEvent motionEvent) {
        return true;
    }

    protected final void onDetachedFromWindow() {
        if (this.mActivity != null) {
            this.mActivity = null;
        }
        super.onDetachedFromWindow();
    }

    private final void zznM() {
        IntroductoryOverlay.zza.zzal((Context)this.mActivity);
        if (this.zzaso != null) {
            this.zzaso.onOverlayDismissed();
            this.zzaso = null;
        }
        this.remove();
    }

    static /* synthetic */ void zza(zzauv zzauv2) {
        zzauv2.zznM();
    }
}

