/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.widget.ImageView;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.media.CastMediaOptions;
import com.google.android.gms.cast.framework.media.ImageHints;
import com.google.android.gms.cast.framework.media.ImagePicker;
import com.google.android.gms.cast.framework.media.MediaUtils;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.uicontroller.UIController;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.internal.zzavb;
import com.google.android.gms.internal.zzavu;

public final class zzavt
extends UIController {
    private final ImageView zzavr;
    private final ImageHints zzauP;
    private final Bitmap zzavs;
    private final ImagePicker zzatH;
    private final zzavb zzavt;

    public zzavt(ImageView imageView, Context context, @NonNull ImageHints imageHints, int n) {
        this.zzavr = imageView;
        this.zzauP = imageHints;
        this.zzavs = BitmapFactory.decodeResource((Resources)context.getResources(), (int)n);
        CastMediaOptions castMediaOptions = CastContext.getSharedInstance(context).getCastOptions().getCastMediaOptions();
        this.zzatH = castMediaOptions != null ? castMediaOptions.getImagePicker() : null;
        this.zzavt = new zzavb(context.getApplicationContext());
    }

    @Override
    public final void onSessionConnected(CastSession castSession) {
        super.onSessionConnected(castSession);
        this.zzavt.zza(new zzavu(this));
        this.zzavr.setImageBitmap(this.zzavs);
        this.zzok();
    }

    @Override
    public final void onSessionEnded() {
        this.zzavt.clear();
        this.zzavr.setImageBitmap(this.zzavs);
        super.onSessionEnded();
    }

    @Override
    public final void onMediaStatusUpdated() {
        this.zzok();
    }

    private final void zzok() {
        WebImage webImage;
        Uri uri;
        MediaInfo mediaInfo;
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession()) {
            this.zzavr.setImageBitmap(this.zzavs);
            return;
        }
        MediaQueueItem mediaQueueItem = remoteMediaClient.getPreloadedItem();
        zzavt zzavt2 = this;
        if ((mediaQueueItem == null ? null : ((mediaInfo = mediaQueueItem.getMedia()) == null ? null : (uri = zzavt2.zzatH != null && (webImage = zzavt2.zzatH.onPickImage(mediaInfo.getMetadata(), zzavt2.zzauP)) != null && webImage.getUrl() != null ? webImage.getUrl() : MediaUtils.getImageUri(mediaInfo, 0)))) == null) {
            this.zzavr.setImageBitmap(this.zzavs);
            return;
        }
        this.zzavt.zzm(uri);
    }

    static /* synthetic */ ImageView zza(zzavt zzavt2) {
        return zzavt2.zzavr;
    }
}

