/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import com.google.android.gms.cast.ApplicationMetadata;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.LaunchOptions;
import com.google.android.gms.cast.framework.CastOptions;
import com.google.android.gms.cast.framework.Session;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.zzj;
import com.google.android.gms.cast.framework.zzm;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.internal.zzauj;
import com.google.android.gms.internal.zzaul;
import com.google.android.gms.internal.zzavn;
import com.google.android.gms.internal.zzayo;
import com.google.android.gms.internal.zzayp;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class CastSession
extends Session {
    private static final zzayo zzarK = new zzayo("CastSession");
    private final Context zzarM;
    private final Set<Cast.Listener> zzarZ = new HashSet<Cast.Listener>();
    private final zzm zzasa;
    private final CastOptions zzarQ;
    private final Cast.CastApi zzasb;
    private final zzaul zzasc;
    private final zzavn zzasd;
    private GoogleApiClient zzapu;
    private RemoteMediaClient zzase;
    private CastDevice zzasf;
    private Cast.ApplicationConnectionResult zzasg;

    public CastSession(Context context, String string2, String string3, CastOptions castOptions, Cast.CastApi castApi, zzaul zzaul2, zzavn zzavn2) {
        super(context, string2, string3);
        this.zzarM = context.getApplicationContext();
        this.zzarQ = castOptions;
        this.zzasb = castApi;
        this.zzasc = zzaul2;
        this.zzasd = zzavn2;
        this.zzasa = zzauj.zza(context, castOptions, this.zznw(), new zzb(this, null));
    }

    @Override
    protected void start(Bundle bundle) {
        this.zzj(bundle);
    }

    @Override
    protected void resume(Bundle bundle) {
        this.zzj(bundle);
    }

    @Override
    protected void end(boolean bl) {
        try {
            this.zzasa.zzb(bl, 0);
        }
        catch (RemoteException remoteException) {
            zzarK.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"disconnectFromDevice", zzm.class.getSimpleName()});
        }
        this.notifySessionEnded(0);
    }

    public RemoteMediaClient getRemoteMediaClient() {
        zzbo.zzcz((String)"Must be called from the main thread.");
        return this.zzase;
    }

    public CastDevice getCastDevice() {
        zzbo.zzcz((String)"Must be called from the main thread.");
        return this.zzasf;
    }

    public void requestStatus() throws IOException, IllegalStateException {
        zzbo.zzcz((String)"Must be called from the main thread.");
        if (this.zzapu != null) {
            this.zzasb.requestStatus(this.zzapu);
        }
    }

    public int getActiveInputState() throws IllegalStateException {
        zzbo.zzcz((String)"Must be called from the main thread.");
        if (this.zzapu != null) {
            return this.zzasb.getActiveInputState(this.zzapu);
        }
        return -1;
    }

    public int getStandbyState() throws IllegalStateException {
        zzbo.zzcz((String)"Must be called from the main thread.");
        if (this.zzapu != null) {
            return this.zzasb.getStandbyState(this.zzapu);
        }
        return -1;
    }

    public ApplicationMetadata getApplicationMetadata() throws IllegalStateException {
        zzbo.zzcz((String)"Must be called from the main thread.");
        if (this.zzapu != null) {
            return this.zzasb.getApplicationMetadata(this.zzapu);
        }
        return null;
    }

    public String getApplicationStatus() throws IllegalStateException {
        zzbo.zzcz((String)"Must be called from the main thread.");
        if (this.zzapu != null) {
            return this.zzasb.getApplicationStatus(this.zzapu);
        }
        return null;
    }

    public void setVolume(double d) throws IOException {
        zzbo.zzcz((String)"Must be called from the main thread.");
        if (this.zzapu != null) {
            this.zzasb.setVolume(this.zzapu, d);
        }
    }

    public double getVolume() throws IllegalStateException {
        zzbo.zzcz((String)"Must be called from the main thread.");
        if (this.zzapu != null) {
            return this.zzasb.getVolume(this.zzapu);
        }
        return 0.0;
    }

    public void setMute(boolean bl) throws IOException, IllegalStateException {
        zzbo.zzcz((String)"Must be called from the main thread.");
        if (this.zzapu != null) {
            this.zzasb.setMute(this.zzapu, bl);
        }
    }

    public boolean isMute() throws IllegalStateException {
        zzbo.zzcz((String)"Must be called from the main thread.");
        if (this.zzapu != null) {
            return this.zzasb.isMute(this.zzapu);
        }
        return false;
    }

    public Cast.ApplicationConnectionResult getApplicationConnectionResult() {
        zzbo.zzcz((String)"Must be called from the main thread.");
        return this.zzasg;
    }

    public void setMessageReceivedCallbacks(String string2, Cast.MessageReceivedCallback messageReceivedCallback) throws IOException, IllegalStateException {
        zzbo.zzcz((String)"Must be called from the main thread.");
        if (this.zzapu != null) {
            this.zzasb.setMessageReceivedCallbacks(this.zzapu, string2, messageReceivedCallback);
        }
    }

    public void removeMessageReceivedCallbacks(String string2) throws IOException, IllegalArgumentException {
        zzbo.zzcz((String)"Must be called from the main thread.");
        if (this.zzapu != null) {
            this.zzasb.removeMessageReceivedCallbacks(this.zzapu, string2);
        }
    }

    public PendingResult<Status> sendMessage(String string2, String string3) {
        zzbo.zzcz((String)"Must be called from the main thread.");
        if (this.zzapu != null) {
            return this.zzasb.sendMessage(this.zzapu, string2, string3);
        }
        return null;
    }

    public void addCastListener(Cast.Listener listener) {
        zzbo.zzcz((String)"Must be called from the main thread.");
        if (listener != null) {
            this.zzarZ.add(listener);
        }
    }

    public void removeCastListener(Cast.Listener listener) {
        zzbo.zzcz((String)"Must be called from the main thread.");
        if (listener != null) {
            this.zzarZ.remove(listener);
        }
    }

    private final void zzj(Bundle bundle) {
        zzd zzd2;
        this.zzasf = CastDevice.getFromBundle((Bundle)bundle);
        if (this.zzasf == null) {
            if (this.isResuming()) {
                this.notifyFailedToResumeSession(8);
                return;
            }
            this.notifyFailedToStartSession(8);
            return;
        }
        if (this.zzapu != null) {
            this.zzapu.disconnect();
            this.zzapu = null;
        }
        zzarK.zzb("Acquiring a connection to Google Play Services for %s", new Object[]{this.zzasf});
        zzd zzd3 = zzd2 = new zzd(this, null);
        zzd zzd4 = zzd2;
        zzc zzc2 = new zzc(this, null);
        CastOptions castOptions = this.zzarQ;
        CastDevice castDevice = this.zzasf;
        Context context = this.zzarM;
        Bundle bundle2 = new Bundle();
        bundle2.putBoolean("com.google.android.gms.cast.EXTRA_CAST_FRAMEWORK_NOTIFICATION_ENABLED", castOptions != null && castOptions.getCastMediaOptions() != null && castOptions.getCastMediaOptions().getNotificationOptions() != null);
        this.zzapu = new GoogleApiClient.Builder(context).addApi(Cast.API, (Api.ApiOptions.HasOptions)new Cast.CastOptions.Builder(castDevice, (Cast.Listener)zzc2).zzi(bundle2).build()).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)zzd4).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)zzd3).build();
        this.zzapu.connect();
    }

    private final void zzY(int n) {
        this.zzasd.zzab(n);
        if (this.zzapu != null) {
            this.zzapu.disconnect();
            this.zzapu = null;
        }
        this.zzasf = null;
        if (this.zzase != null) {
            try {
                this.zzase.zzc(null);
            }
            catch (IOException iOException) {
                zzarK.zza((Throwable)iOException, "Exception when setting GoogleApiClient.", new Object[0]);
            }
            this.zzase = null;
        }
        this.zzasg = null;
    }

    @Override
    public long getSessionRemainingTimeMs() {
        zzbo.zzcz((String)"Must be called from the main thread.");
        if (this.zzase == null) {
            return 0L;
        }
        return this.zzase.getStreamDuration() - this.zzase.getApproximateStreamPosition();
    }

    final class zzb
    extends zzj {
        private /* synthetic */ CastSession zzasi;

        private zzb(CastSession castSession) {
            this.zzasi = castSession;
        }

        @Override
        public final void zzt(String string, String string2) {
            this.zzasi.zzasb.joinApplication(this.zzasi.zzapu, string, string2).setResultCallback((ResultCallback)new zza(this.zzasi, "joinApplication"));
        }

        @Override
        public final void zza(String string, LaunchOptions launchOptions) {
            this.zzasi.zzasb.launchApplication(this.zzasi.zzapu, string, launchOptions).setResultCallback((ResultCallback)new zza(this.zzasi, "launchApplication"));
        }

        @Override
        public final void zzcc(String string) {
            this.zzasi.zzasb.stopApplication(this.zzasi.zzapu, string);
        }

        @Override
        public final void zzY(int n) {
            this.zzasi.zzY(n);
        }

        /* synthetic */ zzb(CastSession castSession, com.google.android.gms.cast.framework.zzc zzc2) {
            this(castSession);
        }
    }

    final class zza
    implements ResultCallback<Cast.ApplicationConnectionResult> {
        private String zzash;
        private /* synthetic */ CastSession zzasi;

        zza(CastSession castSession, String string2) {
            this.zzasi = castSession;
            this.zzash = string2;
        }

        public final /* synthetic */ void onResult(@NonNull Result result) {
            Cast.ApplicationConnectionResult applicationConnectionResult = (Cast.ApplicationConnectionResult)result;
            zza zza2 = this;
            zza2.zzasi.zzasg = applicationConnectionResult;
            try {
                if (applicationConnectionResult.getStatus().isSuccess()) {
                    zzarK.zzb("%s() -> success result", new Object[]{zza2.zzash});
                    zza2.zzasi.zzase = new RemoteMediaClient(new zzayp(null), zza2.zzasi.zzasb);
                    try {
                        zza2.zzasi.zzase.zzc(zza2.zzasi.zzapu);
                        zza2.zzasi.zzase.zznX();
                        zza2.zzasi.zzase.requestStatus();
                        zza2.zzasi.zzasd.zza(zza2.zzasi.zzase, zza2.zzasi.getCastDevice());
                    }
                    catch (IOException iOException) {
                        zzarK.zza((Throwable)iOException, "Exception when setting GoogleApiClient.", new Object[0]);
                        zza2.zzasi.zzase = null;
                    }
                    zza2.zzasi.zzasa.zza(applicationConnectionResult.getApplicationMetadata(), applicationConnectionResult.getApplicationStatus(), applicationConnectionResult.getSessionId(), applicationConnectionResult.getWasLaunched());
                    return;
                }
                zzarK.zzb("%s() -> failure result", new Object[]{zza2.zzash});
                zza2.zzasi.zzasa.zzZ(applicationConnectionResult.getStatus().getStatusCode());
                return;
            }
            catch (RemoteException remoteException) {
                zzarK.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"methods", zzm.class.getSimpleName()});
                return;
            }
        }
    }

    final class zzc
    extends Cast.Listener {
        private /* synthetic */ CastSession zzasi;

        private zzc(CastSession castSession) {
            this.zzasi = castSession;
        }

        public final void onApplicationDisconnected(int n) {
            this.zzasi.zzY(n);
            this.zzasi.notifySessionEnded(n);
            Iterator iterator = new HashSet(this.zzasi.zzarZ).iterator();
            while (iterator.hasNext()) {
                ((Cast.Listener)iterator.next()).onApplicationDisconnected(n);
            }
        }

        public final void onApplicationStatusChanged() {
            Iterator iterator = new HashSet(this.zzasi.zzarZ).iterator();
            while (iterator.hasNext()) {
                ((Cast.Listener)iterator.next()).onApplicationStatusChanged();
            }
        }

        public final void onApplicationMetadataChanged(ApplicationMetadata applicationMetadata) {
            Iterator iterator = new HashSet(this.zzasi.zzarZ).iterator();
            while (iterator.hasNext()) {
                ((Cast.Listener)iterator.next()).onApplicationMetadataChanged(applicationMetadata);
            }
        }

        public final void onActiveInputStateChanged(int n) {
            Iterator iterator = new HashSet(this.zzasi.zzarZ).iterator();
            while (iterator.hasNext()) {
                ((Cast.Listener)iterator.next()).onActiveInputStateChanged(n);
            }
        }

        public final void onStandbyStateChanged(int n) {
            Iterator iterator = new HashSet(this.zzasi.zzarZ).iterator();
            while (iterator.hasNext()) {
                ((Cast.Listener)iterator.next()).onStandbyStateChanged(n);
            }
        }

        public final void onVolumeChanged() {
            Iterator iterator = new HashSet(this.zzasi.zzarZ).iterator();
            while (iterator.hasNext()) {
                ((Cast.Listener)iterator.next()).onVolumeChanged();
            }
        }

        /* synthetic */ zzc(CastSession castSession, com.google.android.gms.cast.framework.zzc zzc2) {
            this(castSession);
        }
    }

    final class zzd
    implements GoogleApiClient.ConnectionCallbacks,
    GoogleApiClient.OnConnectionFailedListener {
        private /* synthetic */ CastSession zzasi;

        private zzd(CastSession castSession) {
            this.zzasi = castSession;
        }

        public final void onConnected(Bundle bundle) {
            try {
                if (this.zzasi.zzase != null) {
                    try {
                        this.zzasi.zzase.zznX();
                        this.zzasi.zzase.requestStatus();
                    }
                    catch (IOException iOException) {
                        zzarK.zza((Throwable)iOException, "Exception when setting GoogleApiClient.", new Object[0]);
                        this.zzasi.zzase = null;
                    }
                }
                this.zzasi.zzasa.onConnected(bundle);
                return;
            }
            catch (RemoteException remoteException) {
                zzarK.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"onConnected", zzm.class.getSimpleName()});
                return;
            }
        }

        public final void onConnectionSuspended(int n) {
            try {
                this.zzasi.zzasa.onConnectionSuspended(n);
                return;
            }
            catch (RemoteException remoteException) {
                zzarK.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"onConnectionSuspended", zzm.class.getSimpleName()});
                return;
            }
        }

        public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            try {
                this.zzasi.zzasa.onConnectionFailed(connectionResult);
                return;
            }
            catch (RemoteException remoteException) {
                zzarK.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"onConnectionFailed", zzm.class.getSimpleName()});
                return;
            }
        }

        /* synthetic */ zzd(CastSession castSession, com.google.android.gms.cast.framework.zzc zzc2) {
            this(castSession);
        }
    }
}

