/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media.uicontroller;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.view.View;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.SeekBar;
import android.widget.TextView;
import com.google.android.gms.R;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.Session;
import com.google.android.gms.cast.framework.SessionManager;
import com.google.android.gms.cast.framework.SessionManagerListener;
import com.google.android.gms.cast.framework.media.ImageHints;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.uicontroller.UIController;
import com.google.android.gms.cast.framework.media.uicontroller.zza;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.internal.zzavs;
import com.google.android.gms.internal.zzavu;
import com.google.android.gms.internal.zzavw;
import com.google.android.gms.internal.zzavy;
import com.google.android.gms.internal.zzawc;
import com.google.android.gms.internal.zzawd;
import com.google.android.gms.internal.zzawe;
import com.google.android.gms.internal.zzawf;
import com.google.android.gms.internal.zzawi;
import com.google.android.gms.internal.zzawk;
import com.google.android.gms.internal.zzawl;
import com.google.android.gms.internal.zzawn;
import com.google.android.gms.internal.zzawp;
import com.google.android.gms.internal.zzawr;
import com.google.android.gms.internal.zzawt;
import com.google.android.gms.internal.zzawu;
import com.google.android.gms.internal.zzawv;
import com.google.android.gms.internal.zzaww;
import com.google.android.gms.internal.zzawx;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UIMediaController
implements SessionManagerListener<CastSession>,
RemoteMediaClient.Listener {
    private final Activity mActivity;
    private final SessionManager zzarO;
    private final Map<View, List<UIController>> zzavi = new HashMap<View, List<UIController>>();
    private final Set<zzawv> zzavj = new HashSet<zzawv>();
    private RemoteMediaClient.Listener zzavk;
    private RemoteMediaClient zzase;

    public UIMediaController(Activity activity) {
        this.mActivity = activity;
        this.zzarO = CastContext.getSharedInstance((Context)activity).getSessionManager();
        this.zzarO.addSessionManagerListener(this, CastSession.class);
        this.zza(this.zzarO.getCurrentCastSession());
    }

    public boolean isActive() {
        zzbo.zzcz((String)"Must be called from the main thread.");
        return this.zzase != null;
    }

    public RemoteMediaClient getRemoteMediaClient() {
        zzbo.zzcz((String)"Must be called from the main thread.");
        return this.zzase;
    }

    public void setPostRemoteMediaClientListener(RemoteMediaClient.Listener listener) {
        zzbo.zzcz((String)"Must be called from the main thread.");
        this.zzavk = listener;
    }

    public void dispose() {
        zzbo.zzcz((String)"Must be called from the main thread.");
        this.zzoi();
        this.zzavi.clear();
        this.zzarO.removeSessionManagerListener(this, CastSession.class);
        this.zzavk = null;
    }

    public void bindImageViewToPlayPauseToggle(@NonNull ImageView imageView, @NonNull Drawable drawable2, @NonNull Drawable drawable3, Drawable drawable4, View view, boolean bl) {
        zzbo.zzcz((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzawi(imageView, (Context)this.mActivity, drawable2, drawable3, drawable4, view, bl));
    }

    public void bindViewToSkipNext(View view, int n) {
        zzbo.zzcz((String)"Must be called from the main thread.");
        this.zza(view, new zzawp(view, n));
    }

    public void bindViewToSkipPrev(View view, int n) {
        zzbo.zzcz((String)"Must be called from the main thread.");
        this.zza(view, new zzawr(view, n));
    }

    public void bindViewToForward(View view, long l) {
        zzbo.zzcz((String)"Must be called from the main thread.");
        this.zza(view, new zzawn(view, l));
    }

    public void bindViewToRewind(View view, long l) {
        zzbo.zzcz((String)"Must be called from the main thread.");
        this.bindViewToForward(view, -l);
    }

    public void bindViewToLoadingIndicator(View view) {
        zzbo.zzcz((String)"Must be called from the main thread.");
        this.zza(view, new zzawc(view));
    }

    public void bindProgressBar(ProgressBar progressBar) {
        this.bindProgressBar(progressBar, 1000L);
    }

    public void bindProgressBar(ProgressBar progressBar, long l) {
        zzbo.zzcz((String)"Must be called from the main thread.");
        this.zza((View)progressBar, new zzawk(progressBar, l));
    }

    public void bindSeekBar(SeekBar seekBar) {
        this.bindSeekBar(seekBar, 1000L);
    }

    public void bindSeekBar(SeekBar seekBar, long l) {
        zzbo.zzcz((String)"Must be called from the main thread.");
        zza zza2 = new zza(this);
        this.zza((View)seekBar, new zzawl(seekBar, l, zza2));
    }

    public void bindTextViewToStreamPosition(TextView textView, boolean bl) {
        this.bindTextViewToStreamPosition(textView, bl, 1000L);
    }

    public void bindTextViewToStreamPosition(TextView textView, boolean bl, long l) {
        zzbo.zzcz((String)"Must be called from the main thread.");
        zzawv zzawv2 = new zzawv(textView, l, this.mActivity.getString(R.string.cast_invalid_stream_position_text));
        if (bl) {
            this.zzavj.add(zzawv2);
        }
        this.zza((View)textView, zzawv2);
    }

    public void bindTextViewToStreamDuration(TextView textView) {
        zzbo.zzcz((String)"Must be called from the main thread.");
        this.zza((View)textView, new zzawu(textView, this.mActivity.getString(R.string.cast_invalid_stream_duration_text), null));
    }

    public void bindTextViewToStreamDuration(TextView textView, View view) {
        zzbo.zzcz((String)"Must be called from the main thread.");
        this.zza((View)textView, new zzawu(textView, this.mActivity.getString(R.string.cast_invalid_stream_duration_text), view));
    }

    public void bindViewToLaunchExpandedController(View view) {
        zzbo.zzcz((String)"Must be called from the main thread.");
        this.zza(view, new zzavy(view, this.mActivity));
    }

    public void bindViewToClosedCaption(View view) {
        zzbo.zzcz((String)"Must be called from the main thread.");
        this.zza(view, new zzavs(view, this.mActivity));
    }

    public void bindImageViewToMuteToggle(ImageView imageView) {
        zzbo.zzcz((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzawf(imageView, (Context)this.mActivity));
    }

    public void bindTextViewToMetadataOfCurrentItem(TextView textView, String string2) {
        zzbo.zzcz((String)"Must be called from the main thread.");
        this.bindTextViewToMetadataOfCurrentItem(textView, Collections.singletonList(string2));
    }

    public void bindTextViewToMetadataOfCurrentItem(TextView textView, List<String> list) {
        zzbo.zzcz((String)"Must be called from the main thread.");
        this.zza((View)textView, new zzawe(textView, list));
    }

    @Deprecated
    public void bindImageViewToImageOfCurrentItem(ImageView imageView, int n, @DrawableRes int n2) {
        zzbo.zzcz((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzavw(imageView, (Context)this.mActivity, new ImageHints(n, 0, 0), n2, null));
    }

    @Deprecated
    public void bindImageViewToImageOfCurrentItem(ImageView imageView, int n, View view) {
        zzbo.zzcz((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzavw(imageView, (Context)this.mActivity, new ImageHints(n, 0, 0), 0, view));
    }

    public void bindImageViewToImageOfCurrentItem(ImageView imageView, @NonNull ImageHints imageHints, @DrawableRes int n) {
        zzbo.zzcz((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzavw(imageView, (Context)this.mActivity, imageHints, n, null));
    }

    public void bindImageViewToImageOfCurrentItem(ImageView imageView, @NonNull ImageHints imageHints, View view) {
        zzbo.zzcz((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzavw(imageView, (Context)this.mActivity, imageHints, 0, view));
    }

    public void bindViewVisibilityToMediaSession(View view, int n) {
        zzbo.zzcz((String)"Must be called from the main thread.");
        this.zza(view, new zzawx(view, n));
    }

    public void bindTextViewToMetadataOfPreloadedItem(TextView textView, String string2) {
        zzbo.zzcz((String)"Must be called from the main thread.");
        this.bindTextViewToMetadataOfPreloadedItem(textView, Collections.singletonList(string2));
    }

    public void bindTextViewToMetadataOfPreloadedItem(TextView textView, List<String> list) {
        zzbo.zzcz((String)"Must be called from the main thread.");
        this.zza((View)textView, new zzawd(textView, list));
    }

    @Deprecated
    public void bindImageViewToImageOfPreloadedItem(ImageView imageView, int n, @DrawableRes int n2) {
        zzbo.zzcz((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzavu(imageView, (Context)this.mActivity, new ImageHints(n, 0, 0), n2));
    }

    public void bindImageViewToImageOfPreloadedItem(ImageView imageView, @NonNull ImageHints imageHints, @DrawableRes int n) {
        zzbo.zzcz((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzavu(imageView, (Context)this.mActivity, imageHints, n));
    }

    public void bindViewVisibilityToPreloadingEvent(View view, int n) {
        zzbo.zzcz((String)"Must be called from the main thread.");
        this.zza(view, new zzaww(view, n));
    }

    public void bindViewToUIController(View view, UIController uIController) {
        zzbo.zzcz((String)"Must be called from the main thread.");
        this.zza(view, uIController);
    }

    public void bindTextViewToSmartSubtitle(TextView textView) {
        zzbo.zzcz((String)"Must be called from the main thread.");
        this.zza((View)textView, new zzawt(textView));
    }

    @Override
    public void onSessionStarting(CastSession castSession) {
    }

    @Override
    public void onSessionStarted(CastSession castSession, String string2) {
        this.zza(castSession);
    }

    @Override
    public void onSessionResuming(CastSession castSession, String string2) {
    }

    @Override
    public void onSessionResumed(CastSession castSession, boolean bl) {
        this.zza(castSession);
    }

    @Override
    public void onSessionStartFailed(CastSession castSession, int n) {
        this.zzoi();
    }

    @Override
    public void onSessionEnding(CastSession castSession) {
    }

    @Override
    public void onSessionEnded(CastSession castSession, int n) {
        this.zzoi();
    }

    @Override
    public void onSessionResumeFailed(CastSession castSession, int n) {
        this.zzoi();
    }

    @Override
    public void onSessionSuspended(CastSession castSession, int n) {
    }

    @Override
    public void onStatusUpdated() {
        this.zzoj();
        if (this.zzavk != null) {
            this.zzavk.onStatusUpdated();
        }
    }

    @Override
    public void onMetadataUpdated() {
        this.zzoj();
        if (this.zzavk != null) {
            this.zzavk.onMetadataUpdated();
        }
    }

    @Override
    public void onQueueStatusUpdated() {
        this.zzoj();
        if (this.zzavk != null) {
            this.zzavk.onQueueStatusUpdated();
        }
    }

    @Override
    public void onPreloadStatusUpdated() {
        this.zzoj();
        if (this.zzavk != null) {
            this.zzavk.onPreloadStatusUpdated();
        }
    }

    @Override
    public void onAdBreakStatusUpdated() {
        this.zzoj();
        if (this.zzavk != null) {
            this.zzavk.onAdBreakStatusUpdated();
        }
    }

    @Override
    public void onSendingRemoteMediaRequest() {
        Iterator<List<UIController>> iterator = this.zzavi.values().iterator();
        while (iterator.hasNext()) {
            Iterator<UIController> iterator2 = iterator.next().iterator();
            while (iterator2.hasNext()) {
                iterator2.next().onSendingRemoteMediaRequest();
            }
        }
        if (this.zzavk != null) {
            this.zzavk.onSendingRemoteMediaRequest();
        }
    }

    private final void zza(Session session) {
        if (this.isActive() || !(session instanceof CastSession) || !session.isConnected()) {
            return;
        }
        CastSession castSession = (CastSession)session;
        this.zzase = castSession.getRemoteMediaClient();
        if (this.zzase != null) {
            this.zzase.addListener(this);
            Iterator<List<UIController>> iterator = this.zzavi.values().iterator();
            while (iterator.hasNext()) {
                Iterator<UIController> iterator2 = iterator.next().iterator();
                while (iterator2.hasNext()) {
                    iterator2.next().onSessionConnected(castSession);
                }
            }
            this.zzoj();
        }
    }

    private final void zzoi() {
        if (!this.isActive()) {
            return;
        }
        Iterator<List<UIController>> iterator = this.zzavi.values().iterator();
        while (iterator.hasNext()) {
            Iterator<UIController> iterator2 = iterator.next().iterator();
            while (iterator2.hasNext()) {
                iterator2.next().onSessionEnded();
            }
        }
        this.zzase.removeListener(this);
        this.zzase = null;
    }

    private final void zza(View view, UIController uIController) {
        List<UIController> list = this.zzavi.get(view);
        if (list == null) {
            list = new ArrayList<UIController>();
            this.zzavi.put(view, list);
        }
        list.add(uIController);
        if (this.isActive()) {
            uIController.onSessionConnected(this.zzarO.getCurrentCastSession());
            this.zzoj();
        }
    }

    private final void zzoj() {
        Iterator<List<UIController>> iterator = this.zzavi.values().iterator();
        while (iterator.hasNext()) {
            Iterator<UIController> iterator2 = iterator.next().iterator();
            while (iterator2.hasNext()) {
                iterator2.next().onMediaStatusUpdated();
            }
        }
    }

    static /* synthetic */ Set zza(UIMediaController uIMediaController) {
        return uIMediaController.zzavj;
    }
}

