/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import com.google.android.gms.cast.ApplicationMetadata;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.LaunchOptions;
import com.google.android.gms.cast.framework.CastOptions;
import com.google.android.gms.cast.framework.Session;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.zzi;
import com.google.android.gms.cast.framework.zzl;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.common.util.zzh;
import com.google.android.gms.internal.zzavk;
import com.google.android.gms.internal.zzavm;
import com.google.android.gms.internal.zzawo;
import com.google.android.gms.internal.zzazp;
import com.google.android.gms.internal.zzazq;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class CastSession
extends Session {
    private static final zzazp zzejb = new zzazp("CastSession");
    private final Context zzeof;
    private final Set<Cast.Listener> zzeou = new HashSet<Cast.Listener>();
    private final zzl zzeov;
    private final CastOptions zzeol;
    private final Cast.CastApi zzeow;
    private final zzavm zzeox;
    private final zzawo zzeoy;
    private GoogleApiClient zzeoz;
    private RemoteMediaClient zzepa;
    private CastDevice zzepb;
    private Cast.ApplicationConnectionResult zzepc;

    public CastSession(Context context, String string2, String string3, CastOptions castOptions, Cast.CastApi castApi, zzavm zzavm2, zzawo zzawo2) {
        super(context, string2, string3);
        this.zzeof = context.getApplicationContext();
        this.zzeol = castOptions;
        this.zzeow = castApi;
        this.zzeox = zzavm2;
        this.zzeoy = zzawo2;
        this.zzeov = zzavk.zza(context, castOptions, this.zzaca(), new zzb(this, null));
    }

    @Override
    protected void start(Bundle bundle) {
        this.zzf(bundle);
    }

    @Override
    protected void resume(Bundle bundle) {
        this.zzf(bundle);
    }

    @Override
    protected void end(boolean bl) {
        try {
            this.zzeov.zzb(bl, 0);
        }
        catch (RemoteException remoteException) {
            zzejb.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"disconnectFromDevice", zzl.class.getSimpleName()});
        }
        this.notifySessionEnded(0);
    }

    public RemoteMediaClient getRemoteMediaClient() {
        zzbp.zzfx((String)"Must be called from the main thread.");
        return this.zzepa;
    }

    public CastDevice getCastDevice() {
        zzbp.zzfx((String)"Must be called from the main thread.");
        return this.zzepb;
    }

    public void requestStatus() throws IOException, IllegalStateException {
        zzbp.zzfx((String)"Must be called from the main thread.");
        if (this.zzeoz != null) {
            this.zzeow.requestStatus(this.zzeoz);
        }
    }

    public int getActiveInputState() throws IllegalStateException {
        zzbp.zzfx((String)"Must be called from the main thread.");
        if (this.zzeoz != null) {
            return this.zzeow.getActiveInputState(this.zzeoz);
        }
        return -1;
    }

    public int getStandbyState() throws IllegalStateException {
        zzbp.zzfx((String)"Must be called from the main thread.");
        if (this.zzeoz != null) {
            return this.zzeow.getStandbyState(this.zzeoz);
        }
        return -1;
    }

    public ApplicationMetadata getApplicationMetadata() throws IllegalStateException {
        zzbp.zzfx((String)"Must be called from the main thread.");
        if (this.zzeoz != null) {
            return this.zzeow.getApplicationMetadata(this.zzeoz);
        }
        return null;
    }

    public String getApplicationStatus() throws IllegalStateException {
        zzbp.zzfx((String)"Must be called from the main thread.");
        if (this.zzeoz != null) {
            return this.zzeow.getApplicationStatus(this.zzeoz);
        }
        return null;
    }

    public void setVolume(double d) throws IOException {
        zzbp.zzfx((String)"Must be called from the main thread.");
        if (this.zzeoz != null) {
            this.zzeow.setVolume(this.zzeoz, d);
        }
    }

    public double getVolume() throws IllegalStateException {
        zzbp.zzfx((String)"Must be called from the main thread.");
        if (this.zzeoz != null) {
            return this.zzeow.getVolume(this.zzeoz);
        }
        return 0.0;
    }

    public final zzawo zzabu() {
        return this.zzeoy;
    }

    public void setMute(boolean bl) throws IOException, IllegalStateException {
        zzbp.zzfx((String)"Must be called from the main thread.");
        if (this.zzeoz != null) {
            this.zzeow.setMute(this.zzeoz, bl);
        }
    }

    public boolean isMute() throws IllegalStateException {
        zzbp.zzfx((String)"Must be called from the main thread.");
        if (this.zzeoz != null) {
            return this.zzeow.isMute(this.zzeoz);
        }
        return false;
    }

    public Cast.ApplicationConnectionResult getApplicationConnectionResult() {
        zzbp.zzfx((String)"Must be called from the main thread.");
        return this.zzepc;
    }

    public void setMessageReceivedCallbacks(String string2, Cast.MessageReceivedCallback messageReceivedCallback) throws IOException, IllegalStateException {
        zzbp.zzfx((String)"Must be called from the main thread.");
        if (this.zzeoz != null) {
            this.zzeow.setMessageReceivedCallbacks(this.zzeoz, string2, messageReceivedCallback);
        }
    }

    public void removeMessageReceivedCallbacks(String string2) throws IOException, IllegalArgumentException {
        zzbp.zzfx((String)"Must be called from the main thread.");
        if (this.zzeoz != null) {
            this.zzeow.removeMessageReceivedCallbacks(this.zzeoz, string2);
        }
    }

    public PendingResult<Status> sendMessage(String string2, String string3) {
        zzbp.zzfx((String)"Must be called from the main thread.");
        if (this.zzeoz != null) {
            return this.zzeow.sendMessage(this.zzeoz, string2, string3);
        }
        return null;
    }

    public void addCastListener(Cast.Listener listener) {
        zzbp.zzfx((String)"Must be called from the main thread.");
        if (listener != null) {
            this.zzeou.add(listener);
        }
    }

    public void removeCastListener(Cast.Listener listener) {
        zzbp.zzfx((String)"Must be called from the main thread.");
        if (listener != null) {
            this.zzeou.remove(listener);
        }
    }

    private final void zzf(Bundle bundle) {
        zzd zzd2;
        this.zzepb = CastDevice.getFromBundle((Bundle)bundle);
        if (this.zzepb == null) {
            if (this.isResuming()) {
                this.notifyFailedToResumeSession(8);
                return;
            }
            this.notifyFailedToStartSession(8);
            return;
        }
        if (this.zzeoz != null) {
            this.zzeoz.disconnect();
            this.zzeoz = null;
        }
        zzejb.zzb("Acquiring a connection to Google Play Services for %s", new Object[]{this.zzepb});
        zzd zzd3 = zzd2 = new zzd(this, null);
        zzd zzd4 = zzd2;
        zzc zzc2 = new zzc(this, null);
        CastOptions castOptions = this.zzeol;
        CastDevice castDevice = this.zzepb;
        Context context = this.zzeof;
        Bundle bundle2 = new Bundle();
        bundle2.putBoolean("com.google.android.gms.cast.EXTRA_CAST_FRAMEWORK_NOTIFICATION_ENABLED", castOptions != null && castOptions.getCastMediaOptions() != null && castOptions.getCastMediaOptions().getNotificationOptions() != null);
        this.zzeoz = new GoogleApiClient.Builder(context).addApi(Cast.API, (Api.ApiOptions.HasOptions)new Cast.CastOptions.Builder(castDevice, (Cast.Listener)zzc2).zze(bundle2).build()).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)zzd4).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)zzd3).build();
        this.zzeoz.connect();
    }

    private final void zzbd(int n) {
        this.zzeoy.zzbg(n);
        if (this.zzeoz != null) {
            this.zzeoz.disconnect();
            this.zzeoz = null;
        }
        this.zzepb = null;
        if (this.zzepa != null) {
            try {
                this.zzepa.zzc(null);
            }
            catch (IOException iOException) {
                zzejb.zza((Throwable)iOException, "Exception when setting GoogleApiClient.", new Object[0]);
            }
            this.zzepa = null;
        }
        this.zzepc = null;
    }

    @Override
    public long getSessionRemainingTimeMs() {
        zzbp.zzfx((String)"Must be called from the main thread.");
        if (this.zzepa == null) {
            return 0L;
        }
        return this.zzepa.getStreamDuration() - this.zzepa.getApproximateStreamPosition();
    }

    final class zzb
    extends zzi {
        private /* synthetic */ CastSession zzepe;

        private zzb(CastSession castSession) {
            this.zzepe = castSession;
        }

        @Override
        public final void zzt(String string, String string2) {
            this.zzepe.zzeow.joinApplication(this.zzepe.zzeoz, string, string2).setResultCallback((ResultCallback)new zza(this.zzepe, "joinApplication"));
        }

        @Override
        public final void zza(String string, LaunchOptions launchOptions) {
            this.zzepe.zzeow.launchApplication(this.zzepe.zzeoz, string, launchOptions).setResultCallback((ResultCallback)new zza(this.zzepe, "launchApplication"));
        }

        @Override
        public final void zzfa(String string) {
            this.zzepe.zzeow.stopApplication(this.zzepe.zzeoz, string);
        }

        @Override
        public final void zzbd(int n) {
            this.zzepe.zzbd(n);
        }

        /* synthetic */ zzb(CastSession castSession, com.google.android.gms.cast.framework.zzc zzc2) {
            this(castSession);
        }
    }

    final class zza
    implements ResultCallback<Cast.ApplicationConnectionResult> {
        private String zzepd;
        private /* synthetic */ CastSession zzepe;

        zza(CastSession castSession, String string2) {
            this.zzepe = castSession;
            this.zzepd = string2;
        }

        public final /* synthetic */ void onResult(@NonNull Result result) {
            Cast.ApplicationConnectionResult applicationConnectionResult = (Cast.ApplicationConnectionResult)result;
            zza zza2 = this;
            zza2.zzepe.zzepc = applicationConnectionResult;
            try {
                if (applicationConnectionResult.getStatus().isSuccess()) {
                    zzejb.zzb("%s() -> success result", new Object[]{zza2.zzepd});
                    zza2.zzepe.zzepa = new RemoteMediaClient(new zzazq(null, zzh.zzalc()), zza2.zzepe.zzeow);
                    try {
                        zza2.zzepe.zzepa.zzc(zza2.zzepe.zzeoz);
                        zza2.zzepe.zzepa.zzadc();
                        zza2.zzepe.zzepa.requestStatus();
                        zza2.zzepe.zzeoy.zza(zza2.zzepe.zzepa, zza2.zzepe.getCastDevice());
                    }
                    catch (IOException iOException) {
                        zzejb.zza((Throwable)iOException, "Exception when setting GoogleApiClient.", new Object[0]);
                        zza2.zzepe.zzepa = null;
                    }
                    zza2.zzepe.zzeov.zza(applicationConnectionResult.getApplicationMetadata(), applicationConnectionResult.getApplicationStatus(), applicationConnectionResult.getSessionId(), applicationConnectionResult.getWasLaunched());
                    return;
                }
                zzejb.zzb("%s() -> failure result", new Object[]{zza2.zzepd});
                zza2.zzepe.zzeov.zzbe(applicationConnectionResult.getStatus().getStatusCode());
                return;
            }
            catch (RemoteException remoteException) {
                zzejb.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"methods", zzl.class.getSimpleName()});
                return;
            }
        }
    }

    final class zzc
    extends Cast.Listener {
        private /* synthetic */ CastSession zzepe;

        private zzc(CastSession castSession) {
            this.zzepe = castSession;
        }

        public final void onApplicationDisconnected(int n) {
            this.zzepe.zzbd(n);
            this.zzepe.notifySessionEnded(n);
            Iterator iterator = new HashSet(this.zzepe.zzeou).iterator();
            while (iterator.hasNext()) {
                ((Cast.Listener)iterator.next()).onApplicationDisconnected(n);
            }
        }

        public final void onApplicationStatusChanged() {
            Iterator iterator = new HashSet(this.zzepe.zzeou).iterator();
            while (iterator.hasNext()) {
                ((Cast.Listener)iterator.next()).onApplicationStatusChanged();
            }
        }

        public final void onApplicationMetadataChanged(ApplicationMetadata applicationMetadata) {
            Iterator iterator = new HashSet(this.zzepe.zzeou).iterator();
            while (iterator.hasNext()) {
                ((Cast.Listener)iterator.next()).onApplicationMetadataChanged(applicationMetadata);
            }
        }

        public final void onActiveInputStateChanged(int n) {
            Iterator iterator = new HashSet(this.zzepe.zzeou).iterator();
            while (iterator.hasNext()) {
                ((Cast.Listener)iterator.next()).onActiveInputStateChanged(n);
            }
        }

        public final void onStandbyStateChanged(int n) {
            Iterator iterator = new HashSet(this.zzepe.zzeou).iterator();
            while (iterator.hasNext()) {
                ((Cast.Listener)iterator.next()).onStandbyStateChanged(n);
            }
        }

        public final void onVolumeChanged() {
            Iterator iterator = new HashSet(this.zzepe.zzeou).iterator();
            while (iterator.hasNext()) {
                ((Cast.Listener)iterator.next()).onVolumeChanged();
            }
        }

        /* synthetic */ zzc(CastSession castSession, com.google.android.gms.cast.framework.zzc zzc2) {
            this(castSession);
        }
    }

    final class zzd
    implements GoogleApiClient.ConnectionCallbacks,
    GoogleApiClient.OnConnectionFailedListener {
        private /* synthetic */ CastSession zzepe;

        private zzd(CastSession castSession) {
            this.zzepe = castSession;
        }

        public final void onConnected(Bundle bundle) {
            try {
                if (this.zzepe.zzepa != null) {
                    try {
                        this.zzepe.zzepa.zzadc();
                        this.zzepe.zzepa.requestStatus();
                    }
                    catch (IOException iOException) {
                        zzejb.zza((Throwable)iOException, "Exception when setting GoogleApiClient.", new Object[0]);
                        this.zzepe.zzepa = null;
                    }
                }
                this.zzepe.zzeov.onConnected(bundle);
                return;
            }
            catch (RemoteException remoteException) {
                zzejb.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"onConnected", zzl.class.getSimpleName()});
                return;
            }
        }

        public final void onConnectionSuspended(int n) {
            try {
                this.zzepe.zzeov.onConnectionSuspended(n);
                return;
            }
            catch (RemoteException remoteException) {
                zzejb.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"onConnectionSuspended", zzl.class.getSimpleName()});
                return;
            }
        }

        public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            try {
                this.zzepe.zzeov.onConnectionFailed(connectionResult);
                return;
            }
            catch (RemoteException remoteException) {
                zzejb.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"onConnectionFailed", zzl.class.getSimpleName()});
                return;
            }
        }

        /* synthetic */ zzd(CastSession castSession, com.google.android.gms.cast.framework.zzc zzc2) {
            this(castSession);
        }
    }
}

