/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.internal.featurehighlight;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.Keep;
import com.google.android.gms.R;
import com.google.android.gms.internal.zzdet;

class InnerZoneDrawable
extends Drawable {
    private final Paint zzeqh = new Paint();
    private final Paint zzerh = new Paint();
    private final Rect zzeqm = new Rect();
    private final int zzeri;
    private final int zzerj;
    private float zzeqi;
    private float zzerk = 1.0f;
    private float centerX;
    private float centerY;
    private float zzerl;
    private float zzerm;

    public InnerZoneDrawable(Context context) {
        Resources resources = context.getResources();
        this.zzeri = resources.getDimensionPixelSize(R.dimen.cast_libraries_material_featurehighlight_inner_radius);
        this.zzerj = resources.getInteger(R.integer.cast_libraries_material_featurehighlight_pulse_base_alpha);
        this.zzeqh.setAntiAlias(true);
        this.zzeqh.setStyle(Paint.Style.FILL);
        this.zzerh.setAntiAlias(true);
        this.zzerh.setStyle(Paint.Style.FILL);
        InnerZoneDrawable innerZoneDrawable = this;
        innerZoneDrawable.zzeqh.setColor(-1);
        innerZoneDrawable.zzerh.setColor(-1);
        innerZoneDrawable.invalidateSelf();
    }

    public void draw(Canvas canvas) {
        if (this.zzerm > 0.0f) {
            float f = this.zzeqi * this.zzerl;
            this.zzerh.setAlpha((int)((float)this.zzerj * this.zzerm));
            canvas.drawCircle(this.centerX, this.centerY, f, this.zzerh);
        }
        canvas.drawCircle(this.centerX, this.centerY, this.zzeqi * this.zzerk, this.zzeqh);
    }

    public void setAlpha(int n) {
        this.zzeqh.setAlpha(n);
        this.invalidateSelf();
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.zzeqh.setColorFilter(colorFilter);
        this.invalidateSelf();
    }

    public int getOpacity() {
        return -3;
    }

    @Keep
    public void setScale(float f) {
        this.zzerk = f;
        this.invalidateSelf();
    }

    @Keep
    public void setPulseScale(float f) {
        this.zzerl = f;
        this.invalidateSelf();
    }

    @Keep
    public void setPulseAlpha(float f) {
        this.zzerm = f;
        this.invalidateSelf();
    }

    public final void zzc(Rect rect) {
        this.zzeqm.set(rect);
        this.centerX = this.zzeqm.exactCenterX();
        this.centerY = this.zzeqm.exactCenterY();
        this.zzeqi = Math.max((float)this.zzeri, Math.max((float)this.zzeqm.width() / 2.0f, (float)this.zzeqm.height() / 2.0f));
        this.invalidateSelf();
    }

    public final Animator zzacv() {
        PropertyValuesHolder propertyValuesHolder = PropertyValuesHolder.ofFloat((String)"scale", (float[])new float[]{0.0f});
        PropertyValuesHolder propertyValuesHolder2 = PropertyValuesHolder.ofInt((String)"alpha", (int[])new int[]{0});
        PropertyValuesHolder propertyValuesHolder3 = PropertyValuesHolder.ofFloat((String)"pulseScale", (float[])new float[]{0.0f});
        PropertyValuesHolder propertyValuesHolder4 = PropertyValuesHolder.ofFloat((String)"pulseAlpha", (float[])new float[]{0.0f});
        ObjectAnimator objectAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this), (PropertyValuesHolder[])new PropertyValuesHolder[]{propertyValuesHolder, propertyValuesHolder2, propertyValuesHolder3, propertyValuesHolder4});
        objectAnimator.setInterpolator((TimeInterpolator)zzdet.zzbje());
        return objectAnimator.setDuration(200L);
    }
}

