/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.internal.featurehighlight;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.Keep;
import android.support.v4.graphics.ColorUtils;
import android.util.TypedValue;
import com.google.android.gms.R;
import com.google.android.gms.common.util.zzp;
import com.google.android.gms.internal.zzdet;
import com.google.android.gms.internal.zzdev;

class OuterHighlightDrawable
extends Drawable {
    private final int zzert;
    private final int zzeru;
    private final int zzerv;
    private final Rect zzeqm = new Rect();
    private final Rect zzern = new Rect();
    private final Paint zzeqh = new Paint();
    private float zzeqi;
    private float zzerk = 1.0f;
    private float centerX;
    private float centerY;
    private float zzerw = 0.0f;
    private float zzerx = 0.0f;
    private int zzery = 244;

    public OuterHighlightDrawable(Context context) {
        if (zzp.zzalj()) {
            Context context2 = context;
            TypedValue typedValue = new TypedValue();
            context2.getTheme().resolveAttribute(16843827, typedValue, true);
            this.setColor(ColorUtils.setAlphaComponent((int)typedValue.data, (int)244));
        } else {
            this.setColor(context.getResources().getColor(R.color.cast_libraries_material_featurehighlight_outer_highlight_default_color));
        }
        this.zzeqh.setAntiAlias(true);
        this.zzeqh.setStyle(Paint.Style.FILL);
        Resources resources = context.getResources();
        this.zzert = resources.getDimensionPixelSize(R.dimen.cast_libraries_material_featurehighlight_center_threshold);
        this.zzeru = resources.getDimensionPixelSize(R.dimen.cast_libraries_material_featurehighlight_center_horizontal_offset);
        this.zzerv = resources.getDimensionPixelSize(R.dimen.cast_libraries_material_featurehighlight_outer_padding);
    }

    public void draw(Canvas canvas) {
        canvas.drawCircle(this.centerX + this.zzerw, this.centerY + this.zzerx, this.zzeqi * this.zzerk, this.zzeqh);
    }

    public void setAlpha(int n) {
        this.zzeqh.setAlpha(n);
        this.invalidateSelf();
    }

    public int getAlpha() {
        return this.zzeqh.getAlpha();
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.zzeqh.setColorFilter(colorFilter);
        this.invalidateSelf();
    }

    public int getOpacity() {
        return -3;
    }

    @ColorInt
    public final int getColor() {
        return this.zzeqh.getColor();
    }

    public final void setColor(@ColorInt int n) {
        this.zzeqh.setColor(n);
        this.zzery = this.zzeqh.getAlpha();
        this.invalidateSelf();
    }

    public final void zzb(Rect rect, Rect rect2) {
        this.zzeqm.set(rect);
        this.zzern.set(rect2);
        float f = rect.exactCenterX();
        float f2 = rect.exactCenterY();
        Rect rect3 = this.getBounds();
        if (Math.min(f2 - (float)rect3.top, (float)rect3.bottom - f2) < (float)this.zzert) {
            this.centerX = f;
            this.centerY = f2;
        } else {
            boolean bl = f <= rect3.exactCenterX();
            this.centerX = bl ? rect2.exactCenterX() + (float)this.zzeru : rect2.exactCenterX() - (float)this.zzeru;
            this.centerY = rect2.exactCenterY();
        }
        this.zzeqi = (float)this.zzerv + Math.max(OuterHighlightDrawable.zza(this.centerX, this.centerY, rect), OuterHighlightDrawable.zza(this.centerX, this.centerY, rect2));
        this.invalidateSelf();
    }

    @Keep
    public void setScale(float f) {
        this.zzerk = f;
        this.invalidateSelf();
    }

    @Keep
    public void setTranslationX(float f) {
        this.zzerw = f;
        this.invalidateSelf();
    }

    @Keep
    public void setTranslationY(float f) {
        this.zzerx = f;
        this.invalidateSelf();
    }

    public final float getCenterX() {
        return this.centerX;
    }

    public final float getCenterY() {
        return this.centerY;
    }

    public final boolean zzd(float f, float f2) {
        return zzdev.zza(f, f2, this.centerX, this.centerY) < this.zzeqi;
    }

    private static float zza(float f, float f2, Rect rect) {
        float f3;
        float f4 = rect.bottom;
        float f5 = rect.right;
        float f6 = rect.top;
        float f7 = rect.left;
        float f8 = f2;
        float f9 = f;
        float f10 = zzdev.zza(f9, f8, f7, f4);
        float f11 = zzdev.zza(f9, f8, f5, f4);
        float f12 = zzdev.zza(f9, f8, f5, f6);
        float f13 = zzdev.zza(f9, f8, f7, f6);
        return (float)Math.ceil(f3 > f12 && f13 > f11 && f13 > f10 ? f13 : (f12 > f11 && f12 > f10 ? f12 : (f11 > f10 ? f11 : f10)));
    }

    public final Animator zze(float f, float f2) {
        PropertyValuesHolder propertyValuesHolder = PropertyValuesHolder.ofFloat((String)"scale", (float[])new float[]{0.0f, 1.0f});
        PropertyValuesHolder propertyValuesHolder2 = PropertyValuesHolder.ofFloat((String)"translationX", (float[])new float[]{f, 0.0f});
        PropertyValuesHolder propertyValuesHolder3 = PropertyValuesHolder.ofFloat((String)"translationY", (float[])new float[]{f2, 0.0f});
        PropertyValuesHolder propertyValuesHolder4 = PropertyValuesHolder.ofInt((String)"alpha", (int[])new int[]{0, this.zzery});
        ObjectAnimator objectAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this), (PropertyValuesHolder[])new PropertyValuesHolder[]{propertyValuesHolder, propertyValuesHolder2, propertyValuesHolder3, propertyValuesHolder4});
        objectAnimator.setInterpolator((TimeInterpolator)zzdet.zzbjd());
        return objectAnimator.setDuration(350L);
    }
}

