/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.app.Activity;
import android.content.Context;
import android.preference.PreferenceManager;
import android.support.annotation.ColorRes;
import android.support.annotation.DimenRes;
import android.support.annotation.StringRes;
import android.support.v7.app.MediaRouteButton;
import android.view.MenuItem;
import android.view.View;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.common.util.zzp;
import com.google.android.gms.internal.zzavt;
import com.google.android.gms.internal.zzavx;

public interface IntroductoryOverlay {
    public void show();

    public void remove();

    public static class Builder {
        private final Activity mActivity;
        private final View zzeph;
        private int zzepi;
        private String zzepj;
        private OnOverlayDismissedListener zzepk;
        private boolean zzepl;
        private float zzepm;
        private String zzepn;

        public Builder(Activity activity, MenuItem menuItem) {
            this.mActivity = (Activity)zzbp.zzu((Object)activity);
            this.zzeph = ((MenuItem)zzbp.zzu((Object)menuItem)).getActionView();
        }

        public Builder(Activity activity, MediaRouteButton mediaRouteButton) {
            this.mActivity = (Activity)zzbp.zzu((Object)activity);
            this.zzeph = (View)zzbp.zzu((Object)mediaRouteButton);
        }

        public Builder setOverlayColor(@ColorRes int n) {
            this.zzepi = this.mActivity.getResources().getColor(n);
            return this;
        }

        public Builder setTitleText(String string2) {
            this.zzepj = string2;
            return this;
        }

        public Builder setTitleText(@StringRes int n) {
            this.zzepj = this.mActivity.getResources().getString(n);
            return this;
        }

        public Builder setOnOverlayDismissedListener(OnOverlayDismissedListener onOverlayDismissedListener) {
            this.zzepk = onOverlayDismissedListener;
            return this;
        }

        public Builder setSingleTime() {
            this.zzepl = true;
            return this;
        }

        public Builder setFocusRadiusId(@DimenRes int n) {
            this.zzepm = this.mActivity.getResources().getDimension(n);
            return this;
        }

        public Builder setFocusRadius(float f) {
            this.zzepm = f;
            return this;
        }

        public Builder setButtonText(String string2) {
            this.zzepn = string2;
            return this;
        }

        public Builder setButtonText(@StringRes int n) {
            this.zzepn = this.mActivity.getResources().getString(n);
            return this;
        }

        public final Activity getActivity() {
            return this.mActivity;
        }

        public final View zzacd() {
            return this.zzeph;
        }

        public final OnOverlayDismissedListener zzace() {
            return this.zzepk;
        }

        public final int zzacf() {
            return this.zzepi;
        }

        public final boolean zzacg() {
            return this.zzepl;
        }

        public final String zzach() {
            return this.zzepj;
        }

        public final String zzaci() {
            return this.zzepn;
        }

        public final float zzacj() {
            return this.zzepm;
        }

        public IntroductoryOverlay build() {
            if (zzp.zzale()) {
                return new zzavt(this);
            }
            return new zzavx(this);
        }
    }

    public static final class zza {
        public static void zzbo(Context context) {
            PreferenceManager.getDefaultSharedPreferences((Context)context).edit().putBoolean("googlecast-introOverlayShown", true).apply();
        }

        public static boolean zzbp(Context context) {
            return PreferenceManager.getDefaultSharedPreferences((Context)context).getBoolean("googlecast-introOverlayShown", false);
        }
    }

    public static interface OnOverlayDismissedListener {
        public void onOverlayDismissed();
    }
}

