/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import com.google.android.gms.cast.AdBreakInfo;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.cast.framework.media.zzaa;
import com.google.android.gms.cast.framework.media.zzab;
import com.google.android.gms.cast.framework.media.zzac;
import com.google.android.gms.cast.framework.media.zzad;
import com.google.android.gms.cast.framework.media.zzae;
import com.google.android.gms.cast.framework.media.zzaf;
import com.google.android.gms.cast.framework.media.zzag;
import com.google.android.gms.cast.framework.media.zzah;
import com.google.android.gms.cast.framework.media.zzai;
import com.google.android.gms.cast.framework.media.zzaj;
import com.google.android.gms.cast.framework.media.zzak;
import com.google.android.gms.cast.framework.media.zzal;
import com.google.android.gms.cast.framework.media.zzam;
import com.google.android.gms.cast.framework.media.zzan;
import com.google.android.gms.cast.framework.media.zzn;
import com.google.android.gms.cast.framework.media.zzo;
import com.google.android.gms.cast.framework.media.zzp;
import com.google.android.gms.cast.framework.media.zzq;
import com.google.android.gms.cast.framework.media.zzr;
import com.google.android.gms.cast.framework.media.zzs;
import com.google.android.gms.cast.framework.media.zzt;
import com.google.android.gms.cast.framework.media.zzu;
import com.google.android.gms.cast.framework.media.zzv;
import com.google.android.gms.cast.framework.media.zzw;
import com.google.android.gms.cast.framework.media.zzx;
import com.google.android.gms.cast.framework.media.zzy;
import com.google.android.gms.cast.framework.media.zzz;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzayt;
import com.google.android.gms.internal.zzayy;
import com.google.android.gms.internal.zzazq;
import com.google.android.gms.internal.zzazr;
import com.google.android.gms.internal.zzazt;
import com.google.android.gms.internal.zzazu;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONObject;

public class RemoteMediaClient
implements Cast.MessageReceivedCallback {
    private final Object mLock;
    private final Handler mHandler;
    private final zzazq zzemj;
    private final zza zzetw;
    private final Cast.CastApi zzeow;
    private GoogleApiClient zzetx;
    private final List<Listener> mListeners = new CopyOnWriteArrayList<Listener>();
    private final Map<ProgressListener, zzd> zzety = new ConcurrentHashMap<ProgressListener, zzd>();
    private final Map<Long, zzd> zzetz = new ConcurrentHashMap<Long, zzd>();
    private ParseAdsInfoCallback zzeua;
    public static final String NAMESPACE = zzazq.NAMESPACE;
    public static final int RESUME_STATE_UNCHANGED = 0;
    public static final int RESUME_STATE_PLAY = 1;
    public static final int RESUME_STATE_PAUSE = 2;
    public static final int STATUS_SUCCEEDED = 0;
    public static final int STATUS_FAILED = 2100;
    public static final int STATUS_REPLACED = 2103;

    public RemoteMediaClient(@NonNull zzazq zzazq2, @NonNull Cast.CastApi castApi) {
        this.mLock = new Object();
        this.mHandler = new Handler(Looper.getMainLooper());
        this.zzetw = new zza();
        this.zzeow = castApi;
        this.zzemj = (zzazq)zzbp.zzu((Object)zzazq2);
        this.zzemj.zza((zzazr)new zzn(this));
        this.zzemj.zza((zzazt)this.zzetw);
    }

    public final void zzc(GoogleApiClient googleApiClient) throws IOException {
        if (this.zzetx == googleApiClient) {
            return;
        }
        if (this.zzetx != null) {
            this.zzemj.zzaed();
            this.zzeow.removeMessageReceivedCallbacks(this.zzetx, this.getNamespace());
            this.zzetw.zzb(null);
            this.mHandler.removeCallbacksAndMessages(null);
        }
        this.zzetx = googleApiClient;
        if (this.zzetx != null) {
            this.zzetw.zzb(this.zzetx);
        }
    }

    public final void zzadc() throws IOException {
        if (this.zzetx != null) {
            this.zzeow.setMessageReceivedCallbacks(this.zzetx, this.getNamespace(), (Cast.MessageReceivedCallback)this);
        }
    }

    public PendingResult<MediaChannelResult> load(MediaInfo mediaInfo) {
        return this.load(mediaInfo, true, 0L, null, null);
    }

    public PendingResult<MediaChannelResult> load(MediaInfo mediaInfo, boolean bl) {
        return this.load(mediaInfo, bl, 0L, null, null);
    }

    public PendingResult<MediaChannelResult> load(MediaInfo mediaInfo, boolean bl, long l) {
        return this.load(mediaInfo, bl, l, null, null);
    }

    public PendingResult<MediaChannelResult> load(MediaInfo mediaInfo, boolean bl, long l, JSONObject jSONObject) {
        return this.load(mediaInfo, bl, l, null, jSONObject);
    }

    public PendingResult<MediaChannelResult> load(MediaInfo mediaInfo, boolean bl, long l, long[] lArray, JSONObject jSONObject) {
        zzbp.zzfx((String)"Must be called from the main thread.");
        this.zzadd();
        return this.zza(new zzy(this, this.zzetx, mediaInfo, bl, l, lArray, jSONObject));
    }

    public PendingResult<MediaChannelResult> pause() {
        return this.pause(null);
    }

    public PendingResult<MediaChannelResult> pause(JSONObject jSONObject) {
        zzbp.zzfx((String)"Must be called from the main thread.");
        this.zzadd();
        return this.zza(new zzad(this, this.zzetx, jSONObject));
    }

    public PendingResult<MediaChannelResult> stop() {
        return this.stop(null);
    }

    public PendingResult<MediaChannelResult> stop(JSONObject jSONObject) {
        zzbp.zzfx((String)"Must be called from the main thread.");
        this.zzadd();
        return this.zza(new zzae(this, this.zzetx, jSONObject));
    }

    public PendingResult<MediaChannelResult> play() {
        return this.play(null);
    }

    public PendingResult<MediaChannelResult> play(JSONObject jSONObject) {
        zzbp.zzfx((String)"Must be called from the main thread.");
        this.zzadd();
        return this.zza(new zzaf(this, this.zzetx, jSONObject));
    }

    public PendingResult<MediaChannelResult> seek(long l) {
        return this.seek(l, 0, null);
    }

    public PendingResult<MediaChannelResult> seek(long l, int n) {
        return this.seek(l, n, null);
    }

    public PendingResult<MediaChannelResult> seek(long l, int n, JSONObject jSONObject) {
        zzbp.zzfx((String)"Must be called from the main thread.");
        this.zzadd();
        return this.zza(new zzag(this, this.zzetx, l, n, jSONObject));
    }

    public PendingResult<MediaChannelResult> setStreamVolume(double d) throws IllegalArgumentException {
        return this.setStreamVolume(d, null);
    }

    public PendingResult<MediaChannelResult> setStreamVolume(double d, JSONObject jSONObject) throws IllegalArgumentException {
        zzbp.zzfx((String)"Must be called from the main thread.");
        this.zzadd();
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new IllegalArgumentException(new StringBuilder(41).append("Volume cannot be ").append(d).toString());
        }
        return this.zza(new zzah(this, this.zzetx, d, jSONObject));
    }

    public PendingResult<MediaChannelResult> setStreamMute(boolean bl) {
        return this.setStreamMute(bl, null);
    }

    public PendingResult<MediaChannelResult> setStreamMute(boolean bl, JSONObject jSONObject) {
        zzbp.zzfx((String)"Must be called from the main thread.");
        this.zzadd();
        return this.zza(new zzai(this, this.zzetx, bl, jSONObject));
    }

    public PendingResult<MediaChannelResult> requestStatus() {
        zzbp.zzfx((String)"Must be called from the main thread.");
        this.zzadd();
        return this.zza(new zzaj(this, this.zzetx));
    }

    public PendingResult<MediaChannelResult> setActiveMediaTracks(long[] lArray) {
        zzbp.zzfx((String)"Must be called from the main thread.");
        this.zzadd();
        if (lArray == null) {
            throw new IllegalArgumentException("trackIds cannot be null");
        }
        return this.zza(new zzo(this, this.zzetx, lArray));
    }

    public PendingResult<MediaChannelResult> setTextTrackStyle(TextTrackStyle textTrackStyle) {
        zzbp.zzfx((String)"Must be called from the main thread.");
        this.zzadd();
        if (textTrackStyle == null) {
            throw new IllegalArgumentException("trackStyle cannot be null");
        }
        return this.zza(new zzp(this, this.zzetx, textTrackStyle));
    }

    public PendingResult<MediaChannelResult> queueLoad(MediaQueueItem[] mediaQueueItemArray, int n, int n2, JSONObject jSONObject) throws IllegalArgumentException {
        return this.queueLoad(mediaQueueItemArray, n, n2, -1L, jSONObject);
    }

    public PendingResult<MediaChannelResult> queueLoad(MediaQueueItem[] mediaQueueItemArray, int n, int n2, long l, JSONObject jSONObject) throws IllegalArgumentException {
        zzbp.zzfx((String)"Must be called from the main thread.");
        this.zzadd();
        return this.zza(new zzq(this, this.zzetx, mediaQueueItemArray, n, n2, l, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueInsertItems(MediaQueueItem[] mediaQueueItemArray, int n, JSONObject jSONObject) throws IllegalArgumentException {
        zzbp.zzfx((String)"Must be called from the main thread.");
        this.zzadd();
        return this.zza(new zzr(this, this.zzetx, mediaQueueItemArray, n, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueAppendItem(MediaQueueItem mediaQueueItem, JSONObject jSONObject) throws IllegalArgumentException {
        return this.queueInsertItems(new MediaQueueItem[]{mediaQueueItem}, 0, jSONObject);
    }

    public PendingResult<MediaChannelResult> queueInsertAndPlayItem(MediaQueueItem mediaQueueItem, int n, JSONObject jSONObject) {
        return this.queueInsertAndPlayItem(mediaQueueItem, n, -1L, jSONObject);
    }

    public PendingResult<MediaChannelResult> queueInsertAndPlayItem(MediaQueueItem mediaQueueItem, int n, long l, JSONObject jSONObject) {
        zzbp.zzfx((String)"Must be called from the main thread.");
        this.zzadd();
        return this.zza(new zzs(this, this.zzetx, mediaQueueItem, n, l, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueUpdateItems(MediaQueueItem[] mediaQueueItemArray, JSONObject jSONObject) {
        zzbp.zzfx((String)"Must be called from the main thread.");
        this.zzadd();
        return this.zza(new zzt(this, this.zzetx, mediaQueueItemArray, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueRemoveItems(int[] nArray, JSONObject jSONObject) throws IllegalArgumentException {
        zzbp.zzfx((String)"Must be called from the main thread.");
        this.zzadd();
        return this.zza(new zzu(this, this.zzetx, nArray, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueReorderItems(int[] nArray, int n, JSONObject jSONObject) throws IllegalArgumentException {
        zzbp.zzfx((String)"Must be called from the main thread.");
        this.zzadd();
        return this.zza(new zzv(this, this.zzetx, nArray, n, jSONObject));
    }

    public PendingResult<MediaChannelResult> queuePrev(JSONObject jSONObject) {
        zzbp.zzfx((String)"Must be called from the main thread.");
        this.zzadd();
        return this.zza(new zzw(this, this.zzetx, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueNext(JSONObject jSONObject) {
        zzbp.zzfx((String)"Must be called from the main thread.");
        this.zzadd();
        return this.zza(new zzx(this, this.zzetx, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueSetRepeatMode(int n, JSONObject jSONObject) {
        zzbp.zzfx((String)"Must be called from the main thread.");
        this.zzadd();
        return this.zza(new zzz(this, this.zzetx, n, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueRemoveItem(int n, JSONObject jSONObject) {
        zzbp.zzfx((String)"Must be called from the main thread.");
        this.zzadd();
        return this.zza(new zzaa(this, this.zzetx, n, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueJumpToItem(int n, JSONObject jSONObject) {
        return this.queueJumpToItem(n, -1L, jSONObject);
    }

    public PendingResult<MediaChannelResult> queueJumpToItem(int n, long l, JSONObject jSONObject) {
        zzbp.zzfx((String)"Must be called from the main thread.");
        this.zzadd();
        return this.zza(new zzab(this, this.zzetx, n, l, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueMoveItemToNewIndex(int n, int n2, JSONObject jSONObject) {
        zzbp.zzfx((String)"Must be called from the main thread.");
        this.zzadd();
        return this.zza(new zzac(this, this.zzetx, n, n2, jSONObject));
    }

    private final int zzbb(int n) {
        zzbp.zzfx((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        for (int i = 0; i < mediaStatus.getQueueItemCount(); ++i) {
            if (mediaStatus.getQueueItem(i).getItemId() != n) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getApproximateStreamPosition() {
        Object object = this.mLock;
        synchronized (object) {
            zzbp.zzfx((String)"Must be called from the main thread.");
            return this.zzemj.getApproximateStreamPosition();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getStreamDuration() {
        Object object = this.mLock;
        synchronized (object) {
            zzbp.zzfx((String)"Must be called from the main thread.");
            return this.zzemj.getStreamDuration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaStatus getMediaStatus() {
        Object object = this.mLock;
        synchronized (object) {
            zzbp.zzfx((String)"Must be called from the main thread.");
            return this.zzemj.getMediaStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaInfo getMediaInfo() {
        Object object = this.mLock;
        synchronized (object) {
            zzbp.zzfx((String)"Must be called from the main thread.");
            return this.zzemj.getMediaInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPlayerState() {
        Object object = this.mLock;
        synchronized (object) {
            zzbp.zzfx((String)"Must be called from the main thread.");
            MediaStatus mediaStatus = this.getMediaStatus();
            return mediaStatus != null ? mediaStatus.getPlayerState() : 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIdleReason() {
        Object object = this.mLock;
        synchronized (object) {
            zzbp.zzfx((String)"Must be called from the main thread.");
            MediaStatus mediaStatus = this.getMediaStatus();
            return mediaStatus != null ? mediaStatus.getIdleReason() : 0;
        }
    }

    public boolean isLiveStream() {
        zzbp.zzfx((String)"Must be called from the main thread.");
        MediaInfo mediaInfo = this.getMediaInfo();
        return mediaInfo != null && mediaInfo.getStreamType() == 2;
    }

    public boolean isPlaying() {
        zzbp.zzfx((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus != null && mediaStatus.getPlayerState() == 2;
    }

    public boolean isPaused() {
        zzbp.zzfx((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus != null && (mediaStatus.getPlayerState() == 3 || this.isLiveStream() && this.getIdleReason() == 2);
    }

    public boolean isBuffering() {
        zzbp.zzfx((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus != null && mediaStatus.getPlayerState() == 4;
    }

    public boolean isLoadingNextItem() {
        zzbp.zzfx((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus != null && mediaStatus.getLoadingItemId() != 0;
    }

    public MediaQueueItem getCurrentItem() {
        zzbp.zzfx((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        if (mediaStatus == null) {
            return null;
        }
        return mediaStatus.getQueueItemById(mediaStatus.getCurrentItemId());
    }

    public MediaQueueItem getLoadingItem() {
        zzbp.zzfx((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        if (mediaStatus == null) {
            return null;
        }
        return mediaStatus.getQueueItemById(mediaStatus.getLoadingItemId());
    }

    public MediaQueueItem getPreloadedItem() {
        zzbp.zzfx((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        if (mediaStatus == null) {
            return null;
        }
        return mediaStatus.getQueueItemById(mediaStatus.getPreloadedItemId());
    }

    public void togglePlayback() {
        zzbp.zzfx((String)"Must be called from the main thread.");
        int n = this.getPlayerState();
        if (n == 4 || n == 2) {
            this.pause();
            return;
        }
        this.play();
    }

    public boolean hasMediaSession() {
        zzbp.zzfx((String)"Must be called from the main thread.");
        return this.isBuffering() || this.isPlaying() || this.isPaused() || this.isLoadingNextItem();
    }

    public void addListener(Listener listener) {
        zzbp.zzfx((String)"Must be called from the main thread.");
        if (listener != null) {
            this.mListeners.add(listener);
        }
    }

    public void removeListener(Listener listener) {
        zzbp.zzfx((String)"Must be called from the main thread.");
        if (listener != null) {
            this.mListeners.remove(listener);
        }
    }

    public boolean addProgressListener(ProgressListener progressListener, long l) {
        zzbp.zzfx((String)"Must be called from the main thread.");
        if (progressListener == null || this.zzety.containsKey(progressListener)) {
            return false;
        }
        zzd zzd2 = this.zzetz.get(l);
        if (zzd2 == null) {
            zzd2 = new zzd(l);
            this.zzetz.put(l, zzd2);
        }
        zzd2.zza(progressListener);
        this.zzety.put(progressListener, zzd2);
        if (this.hasMediaSession()) {
            zzd2.start();
        }
        return true;
    }

    public void removeProgressListener(ProgressListener progressListener) {
        zzbp.zzfx((String)"Must be called from the main thread.");
        zzd zzd2 = this.zzety.remove(progressListener);
        if (zzd2 != null) {
            zzd2.zzb(progressListener);
            if (!zzd2.zzadh()) {
                this.zzetz.remove(zzd2.zzadg());
                zzd2.stop();
            }
        }
    }

    public void setParseAdsInfoCallback(ParseAdsInfoCallback parseAdsInfoCallback) {
        zzbp.zzfx((String)"Must be called from the main thread.");
        this.zzeua = parseAdsInfoCallback;
    }

    public boolean isPlayingAd() {
        zzbp.zzfx((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus != null && mediaStatus.isPlayingAd();
    }

    public String getNamespace() {
        zzbp.zzfx((String)"Must be called from the main thread.");
        return this.zzemj.getNamespace();
    }

    public void onMessageReceived(CastDevice castDevice, String string2, String string3) {
        this.zzemj.zzff(string3);
    }

    private final void zzadd() throws IllegalStateException {
        if (this.zzetx == null) {
            throw new IllegalStateException("No connection");
        }
    }

    private final zzb zza(zzb zzb2) {
        try {
            this.zzetx.zze((zzm)zzb2);
            return zzb2;
        }
        catch (IllegalStateException illegalStateException) {
            try {
                zzb2.setResult((MediaChannelResult)zzb2.zzb(new Status(2100)));
                return zzb2;
            }
            catch (Throwable throwable) {
                return zzb2;
            }
        }
    }

    private final void zza(Set<ProgressListener> set) {
        if (this.isBuffering() || this.isPaused()) {
            return;
        }
        HashSet<ProgressListener> hashSet = new HashSet<ProgressListener>(set);
        if (this.isPlaying()) {
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                ((ProgressListener)iterator.next()).onProgressUpdated(this.getApproximateStreamPosition(), this.getStreamDuration());
            }
            return;
        }
        if (this.isLoadingNextItem()) {
            MediaQueueItem mediaQueueItem = this.getLoadingItem();
            if (mediaQueueItem != null && mediaQueueItem.getMedia() != null) {
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    ((ProgressListener)iterator.next()).onProgressUpdated(0L, mediaQueueItem.getMedia().getStreamDuration());
                }
            }
            return;
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            ((ProgressListener)iterator.next()).onProgressUpdated(0L, 0L);
        }
    }

    private final void zzade() {
        for (zzd zzd2 : this.zzetz.values()) {
            if (this.hasMediaSession() && !zzd2.isStarted()) {
                zzd2.start();
            } else if (!this.hasMediaSession() && zzd2.isStarted()) {
                zzd2.stop();
            }
            if (!zzd2.isStarted() || !this.isBuffering() && !this.isPaused() && !this.isLoadingNextItem()) continue;
            this.zza(zzd2.zzeue);
        }
    }

    static /* synthetic */ void zza(RemoteMediaClient remoteMediaClient) {
        remoteMediaClient.zzade();
    }

    static /* synthetic */ ParseAdsInfoCallback zzc(RemoteMediaClient remoteMediaClient) {
        return remoteMediaClient.zzeua;
    }

    static /* synthetic */ Object zzd(RemoteMediaClient remoteMediaClient) {
        return remoteMediaClient.mLock;
    }

    static /* synthetic */ zzazq zze(RemoteMediaClient remoteMediaClient) {
        return remoteMediaClient.zzemj;
    }

    static /* synthetic */ int zza(RemoteMediaClient remoteMediaClient, int n) {
        return remoteMediaClient.zzbb(n);
    }

    static /* synthetic */ void zza(RemoteMediaClient remoteMediaClient, Set set) {
        remoteMediaClient.zza(set);
    }

    final class zzd {
        private final Set<ProgressListener> zzeue = new HashSet<ProgressListener>();
        private final long zzeuf;
        private final Runnable zzeug;
        private boolean zzeuh;

        public zzd(long l) {
            this.zzeuf = l;
            this.zzeug = new zzan(this, RemoteMediaClient.this);
        }

        public final long zzadg() {
            return this.zzeuf;
        }

        public final void zza(ProgressListener progressListener) {
            this.zzeue.add(progressListener);
        }

        public final void zzb(ProgressListener progressListener) {
            this.zzeue.remove(progressListener);
        }

        public final boolean zzadh() {
            return !this.zzeue.isEmpty();
        }

        public final void start() {
            RemoteMediaClient.this.mHandler.removeCallbacks(this.zzeug);
            this.zzeuh = true;
            RemoteMediaClient.this.mHandler.postDelayed(this.zzeug, this.zzeuf);
        }

        public final void stop() {
            RemoteMediaClient.this.mHandler.removeCallbacks(this.zzeug);
            this.zzeuh = false;
        }

        public final boolean isStarted() {
            return this.zzeuh;
        }

        static /* synthetic */ long zzb(zzd zzd2) {
            return zzd2.zzeuf;
        }
    }

    static abstract class zzb
    extends zzayt<MediaChannelResult> {
        zzazu zzenq = new zzal(this);

        zzb(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected void zza(zzayy zzayy2) {
        }

        public final /* synthetic */ Result zzb(Status status) {
            Status status2 = status;
            zzb zzb2 = this;
            return new zzam(zzb2, status2);
        }
    }

    static final class zzc
    implements MediaChannelResult {
        private final Status mStatus;
        private final JSONObject zzehn;

        zzc(Status status, JSONObject jSONObject) {
            this.mStatus = status;
            this.zzehn = jSONObject;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final JSONObject getCustomData() {
            return this.zzehn;
        }
    }

    public static interface MediaChannelResult
    extends Result {
        public JSONObject getCustomData();
    }

    final class zza
    implements zzazt {
        private GoogleApiClient zzenm;
        private long zzenn = 0L;

        public final void zzb(GoogleApiClient googleApiClient) {
            this.zzenm = googleApiClient;
        }

        public final long zzabq() {
            return ++this.zzenn;
        }

        public final void zza(String string2, String string3, long l, String string4) throws IOException {
            if (this.zzenm == null) {
                throw new IOException("No GoogleApiClient available");
            }
            Iterator iterator = RemoteMediaClient.this.mListeners.iterator();
            while (iterator.hasNext()) {
                ((Listener)iterator.next()).onSendingRemoteMediaRequest();
            }
            RemoteMediaClient.this.zzeow.sendMessage(this.zzenm, string2, string3).setResultCallback((ResultCallback)new zzak(this, l));
        }
    }

    public static interface ParseAdsInfoCallback {
        public boolean parseIsPlayingAdFromMediaStatus(MediaStatus var1);

        public List<AdBreakInfo> parseAdBreaksFromMediaStatus(MediaStatus var1);
    }

    public static interface ProgressListener {
        public void onProgressUpdated(long var1, long var3);
    }

    public static interface Listener {
        public void onStatusUpdated();

        public void onMetadataUpdated();

        public void onQueueStatusUpdated();

        public void onPreloadStatusUpdated();

        public void onSendingRemoteMediaRequest();

        public void onAdBreakStatusUpdated();
    }
}

