/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media.uicontroller;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.view.View;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.SeekBar;
import android.widget.TextView;
import com.google.android.gms.R;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.Session;
import com.google.android.gms.cast.framework.SessionManager;
import com.google.android.gms.cast.framework.SessionManagerListener;
import com.google.android.gms.cast.framework.media.ImageHints;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.uicontroller.UIController;
import com.google.android.gms.cast.framework.media.uicontroller.zza;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzawt;
import com.google.android.gms.internal.zzawv;
import com.google.android.gms.internal.zzawx;
import com.google.android.gms.internal.zzawz;
import com.google.android.gms.internal.zzaxd;
import com.google.android.gms.internal.zzaxe;
import com.google.android.gms.internal.zzaxf;
import com.google.android.gms.internal.zzaxg;
import com.google.android.gms.internal.zzaxj;
import com.google.android.gms.internal.zzaxl;
import com.google.android.gms.internal.zzaxm;
import com.google.android.gms.internal.zzaxo;
import com.google.android.gms.internal.zzaxq;
import com.google.android.gms.internal.zzaxs;
import com.google.android.gms.internal.zzaxu;
import com.google.android.gms.internal.zzaxv;
import com.google.android.gms.internal.zzaxw;
import com.google.android.gms.internal.zzaxx;
import com.google.android.gms.internal.zzaxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UIMediaController
implements SessionManagerListener<CastSession>,
RemoteMediaClient.Listener {
    private final Activity mActivity;
    private final SessionManager zzeoh;
    private final Map<View, List<UIController>> zzevl = new HashMap<View, List<UIController>>();
    private final Set<zzaxw> zzevm = new HashSet<zzaxw>();
    private RemoteMediaClient.Listener zzevn;
    private RemoteMediaClient zzepa;

    public UIMediaController(Activity activity) {
        this.mActivity = activity;
        this.zzeoh = CastContext.getSharedInstance((Context)activity).getSessionManager();
        this.zzeoh.addSessionManagerListener(this, CastSession.class);
        this.zza(this.zzeoh.getCurrentCastSession());
    }

    public boolean isActive() {
        zzbp.zzfx((String)"Must be called from the main thread.");
        return this.zzepa != null;
    }

    public RemoteMediaClient getRemoteMediaClient() {
        zzbp.zzfx((String)"Must be called from the main thread.");
        return this.zzepa;
    }

    public void setPostRemoteMediaClientListener(RemoteMediaClient.Listener listener) {
        zzbp.zzfx((String)"Must be called from the main thread.");
        this.zzevn = listener;
    }

    public void dispose() {
        zzbp.zzfx((String)"Must be called from the main thread.");
        this.zzadm();
        this.zzevl.clear();
        this.zzeoh.removeSessionManagerListener(this, CastSession.class);
        this.zzevn = null;
    }

    public void bindImageViewToPlayPauseToggle(@NonNull ImageView imageView, @NonNull Drawable drawable2, @NonNull Drawable drawable3, Drawable drawable4, View view, boolean bl) {
        zzbp.zzfx((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzaxj(imageView, (Context)this.mActivity, drawable2, drawable3, drawable4, view, bl));
    }

    public void bindViewToSkipNext(View view, int n) {
        zzbp.zzfx((String)"Must be called from the main thread.");
        this.zza(view, new zzaxq(view, n));
    }

    public void bindViewToSkipPrev(View view, int n) {
        zzbp.zzfx((String)"Must be called from the main thread.");
        this.zza(view, new zzaxs(view, n));
    }

    public void bindViewToForward(View view, long l) {
        zzbp.zzfx((String)"Must be called from the main thread.");
        this.zza(view, new zzaxo(view, l));
    }

    public void bindViewToRewind(View view, long l) {
        zzbp.zzfx((String)"Must be called from the main thread.");
        this.bindViewToForward(view, -l);
    }

    public void bindViewToLoadingIndicator(View view) {
        zzbp.zzfx((String)"Must be called from the main thread.");
        this.zza(view, new zzaxd(view));
    }

    public void bindProgressBar(ProgressBar progressBar) {
        this.bindProgressBar(progressBar, 1000L);
    }

    public void bindProgressBar(ProgressBar progressBar, long l) {
        zzbp.zzfx((String)"Must be called from the main thread.");
        this.zza((View)progressBar, new zzaxl(progressBar, l));
    }

    public void bindSeekBar(SeekBar seekBar) {
        this.bindSeekBar(seekBar, 1000L);
    }

    public void bindSeekBar(SeekBar seekBar, long l) {
        zzbp.zzfx((String)"Must be called from the main thread.");
        zza zza2 = new zza(this);
        this.zza((View)seekBar, new zzaxm(seekBar, l, zza2));
    }

    public void bindTextViewToStreamPosition(TextView textView, boolean bl) {
        this.bindTextViewToStreamPosition(textView, bl, 1000L);
    }

    public void bindTextViewToStreamPosition(TextView textView, boolean bl, long l) {
        zzbp.zzfx((String)"Must be called from the main thread.");
        zzaxw zzaxw2 = new zzaxw(textView, l, this.mActivity.getString(R.string.cast_invalid_stream_position_text));
        if (bl) {
            this.zzevm.add(zzaxw2);
        }
        this.zza((View)textView, zzaxw2);
    }

    public void bindTextViewToStreamDuration(TextView textView) {
        zzbp.zzfx((String)"Must be called from the main thread.");
        this.zza((View)textView, new zzaxv(textView, this.mActivity.getString(R.string.cast_invalid_stream_duration_text), null));
    }

    public void bindTextViewToStreamDuration(TextView textView, View view) {
        zzbp.zzfx((String)"Must be called from the main thread.");
        this.zza((View)textView, new zzaxv(textView, this.mActivity.getString(R.string.cast_invalid_stream_duration_text), view));
    }

    public void bindViewToLaunchExpandedController(View view) {
        zzbp.zzfx((String)"Must be called from the main thread.");
        this.zza(view, new zzawz(view, this.mActivity));
    }

    public void bindViewToClosedCaption(View view) {
        zzbp.zzfx((String)"Must be called from the main thread.");
        this.zza(view, new zzawt(view, this.mActivity));
    }

    public void bindImageViewToMuteToggle(ImageView imageView) {
        zzbp.zzfx((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzaxg(imageView, (Context)this.mActivity));
    }

    public void bindTextViewToMetadataOfCurrentItem(TextView textView, String string2) {
        zzbp.zzfx((String)"Must be called from the main thread.");
        this.bindTextViewToMetadataOfCurrentItem(textView, Collections.singletonList(string2));
    }

    public void bindTextViewToMetadataOfCurrentItem(TextView textView, List<String> list) {
        zzbp.zzfx((String)"Must be called from the main thread.");
        this.zza((View)textView, new zzaxf(textView, list));
    }

    @Deprecated
    public void bindImageViewToImageOfCurrentItem(ImageView imageView, int n, @DrawableRes int n2) {
        zzbp.zzfx((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzawx(imageView, (Context)this.mActivity, new ImageHints(n, 0, 0), n2, null));
    }

    @Deprecated
    public void bindImageViewToImageOfCurrentItem(ImageView imageView, int n, View view) {
        zzbp.zzfx((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzawx(imageView, (Context)this.mActivity, new ImageHints(n, 0, 0), 0, view));
    }

    public void bindImageViewToImageOfCurrentItem(ImageView imageView, @NonNull ImageHints imageHints, @DrawableRes int n) {
        zzbp.zzfx((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzawx(imageView, (Context)this.mActivity, imageHints, n, null));
    }

    public void bindImageViewToImageOfCurrentItem(ImageView imageView, @NonNull ImageHints imageHints, View view) {
        zzbp.zzfx((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzawx(imageView, (Context)this.mActivity, imageHints, 0, view));
    }

    public void bindViewVisibilityToMediaSession(View view, int n) {
        zzbp.zzfx((String)"Must be called from the main thread.");
        this.zza(view, new zzaxy(view, n));
    }

    public void bindTextViewToMetadataOfPreloadedItem(TextView textView, String string2) {
        zzbp.zzfx((String)"Must be called from the main thread.");
        this.bindTextViewToMetadataOfPreloadedItem(textView, Collections.singletonList(string2));
    }

    public void bindTextViewToMetadataOfPreloadedItem(TextView textView, List<String> list) {
        zzbp.zzfx((String)"Must be called from the main thread.");
        this.zza((View)textView, new zzaxe(textView, list));
    }

    @Deprecated
    public void bindImageViewToImageOfPreloadedItem(ImageView imageView, int n, @DrawableRes int n2) {
        zzbp.zzfx((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzawv(imageView, (Context)this.mActivity, new ImageHints(n, 0, 0), n2));
    }

    public void bindImageViewToImageOfPreloadedItem(ImageView imageView, @NonNull ImageHints imageHints, @DrawableRes int n) {
        zzbp.zzfx((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzawv(imageView, (Context)this.mActivity, imageHints, n));
    }

    public void bindViewVisibilityToPreloadingEvent(View view, int n) {
        zzbp.zzfx((String)"Must be called from the main thread.");
        this.zza(view, new zzaxx(view, n));
    }

    public void bindViewToUIController(View view, UIController uIController) {
        zzbp.zzfx((String)"Must be called from the main thread.");
        this.zza(view, uIController);
    }

    public void bindTextViewToSmartSubtitle(TextView textView) {
        zzbp.zzfx((String)"Must be called from the main thread.");
        this.zza((View)textView, new zzaxu(textView));
    }

    @Override
    public void onSessionStarting(CastSession castSession) {
    }

    @Override
    public void onSessionStarted(CastSession castSession, String string2) {
        this.zza(castSession);
    }

    @Override
    public void onSessionResuming(CastSession castSession, String string2) {
    }

    @Override
    public void onSessionResumed(CastSession castSession, boolean bl) {
        this.zza(castSession);
    }

    @Override
    public void onSessionStartFailed(CastSession castSession, int n) {
        this.zzadm();
    }

    @Override
    public void onSessionEnding(CastSession castSession) {
    }

    @Override
    public void onSessionEnded(CastSession castSession, int n) {
        this.zzadm();
    }

    @Override
    public void onSessionResumeFailed(CastSession castSession, int n) {
        this.zzadm();
    }

    @Override
    public void onSessionSuspended(CastSession castSession, int n) {
    }

    @Override
    public void onStatusUpdated() {
        this.zzadn();
        if (this.zzevn != null) {
            this.zzevn.onStatusUpdated();
        }
    }

    @Override
    public void onMetadataUpdated() {
        this.zzadn();
        if (this.zzevn != null) {
            this.zzevn.onMetadataUpdated();
        }
    }

    @Override
    public void onQueueStatusUpdated() {
        this.zzadn();
        if (this.zzevn != null) {
            this.zzevn.onQueueStatusUpdated();
        }
    }

    @Override
    public void onPreloadStatusUpdated() {
        this.zzadn();
        if (this.zzevn != null) {
            this.zzevn.onPreloadStatusUpdated();
        }
    }

    @Override
    public void onAdBreakStatusUpdated() {
        this.zzadn();
        if (this.zzevn != null) {
            this.zzevn.onAdBreakStatusUpdated();
        }
    }

    @Override
    public void onSendingRemoteMediaRequest() {
        Iterator<List<UIController>> iterator = this.zzevl.values().iterator();
        while (iterator.hasNext()) {
            Iterator<UIController> iterator2 = iterator.next().iterator();
            while (iterator2.hasNext()) {
                iterator2.next().onSendingRemoteMediaRequest();
            }
        }
        if (this.zzevn != null) {
            this.zzevn.onSendingRemoteMediaRequest();
        }
    }

    private final void zza(Session session) {
        if (this.isActive() || !(session instanceof CastSession) || !session.isConnected()) {
            return;
        }
        CastSession castSession = (CastSession)session;
        this.zzepa = castSession.getRemoteMediaClient();
        if (this.zzepa != null) {
            this.zzepa.addListener(this);
            Iterator<List<UIController>> iterator = this.zzevl.values().iterator();
            while (iterator.hasNext()) {
                Iterator<UIController> iterator2 = iterator.next().iterator();
                while (iterator2.hasNext()) {
                    iterator2.next().onSessionConnected(castSession);
                }
            }
            this.zzadn();
        }
    }

    private final void zzadm() {
        if (!this.isActive()) {
            return;
        }
        Iterator<List<UIController>> iterator = this.zzevl.values().iterator();
        while (iterator.hasNext()) {
            Iterator<UIController> iterator2 = iterator.next().iterator();
            while (iterator2.hasNext()) {
                iterator2.next().onSessionEnded();
            }
        }
        this.zzepa.removeListener(this);
        this.zzepa = null;
    }

    private final void zza(View view, UIController uIController) {
        List<UIController> list = this.zzevl.get(view);
        if (list == null) {
            list = new ArrayList<UIController>();
            this.zzevl.put(view, list);
        }
        list.add(uIController);
        if (this.isActive()) {
            uIController.onSessionConnected(this.zzeoh.getCurrentCastSession());
            this.zzadn();
        }
    }

    private final void zzadn() {
        Iterator<List<UIController>> iterator = this.zzevl.values().iterator();
        while (iterator.hasNext()) {
            Iterator<UIController> iterator2 = iterator.next().iterator();
            while (iterator2.hasNext()) {
                iterator2.next().onMediaStatusUpdated();
            }
        }
    }

    static /* synthetic */ Set zza(UIMediaController uIMediaController) {
        return uIMediaController.zzevm;
    }
}

