/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.view.View;
import android.widget.ImageView;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.media.CastMediaOptions;
import com.google.android.gms.cast.framework.media.ImageHints;
import com.google.android.gms.cast.framework.media.ImagePicker;
import com.google.android.gms.cast.framework.media.MediaUtils;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.uicontroller.UIController;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.internal.zzawd;
import com.google.android.gms.internal.zzawy;

public final class zzawx
extends UIController {
    private final ImageView zzevt;
    private final ImageHints zzeus;
    private final Bitmap zzevx;
    private final View zzevy;
    private final ImagePicker zzesd;
    private final zzawd zzevv;

    public zzawx(ImageView imageView, Context context, @NonNull ImageHints imageHints, int n, View view) {
        this.zzevt = imageView;
        this.zzeus = imageHints;
        this.zzevx = n != 0 ? BitmapFactory.decodeResource((Resources)context.getResources(), (int)n) : null;
        this.zzevy = view;
        CastMediaOptions castMediaOptions = CastContext.getSharedInstance(context).getCastOptions().getCastMediaOptions();
        this.zzesd = castMediaOptions != null ? castMediaOptions.getImagePicker() : null;
        this.zzevv = new zzawd(context.getApplicationContext());
    }

    @Override
    public final void onSessionConnected(CastSession castSession) {
        super.onSessionConnected(castSession);
        this.zzevv.zza(new zzawy(this));
        this.zzadp();
        this.zzado();
    }

    @Override
    public final void onSessionEnded() {
        this.zzevv.clear();
        this.zzadp();
        super.onSessionEnded();
    }

    @Override
    public final void onMediaStatusUpdated() {
        this.zzado();
    }

    private final void zzado() {
        WebImage webImage;
        Uri uri;
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession()) {
            this.zzadp();
            return;
        }
        MediaInfo mediaInfo = remoteMediaClient.getMediaInfo();
        zzawx zzawx2 = this;
        if ((mediaInfo == null ? null : (uri = zzawx2.zzesd != null && (webImage = zzawx2.zzesd.onPickImage(mediaInfo.getMetadata(), zzawx2.zzeus)) != null && webImage.getUrl() != null ? webImage.getUrl() : MediaUtils.getImageUri(mediaInfo, 0))) == null) {
            this.zzadp();
            return;
        }
        this.zzevv.zzm(uri);
    }

    private final void zzadp() {
        if (this.zzevy != null) {
            this.zzevy.setVisibility(0);
            this.zzevt.setVisibility(4);
        }
        if (this.zzevx != null) {
            this.zzevt.setImageBitmap(this.zzevx);
        }
    }

    static /* synthetic */ View zza(zzawx zzawx2) {
        return zzawx2.zzevy;
    }

    static /* synthetic */ ImageView zzb(zzawx zzawx2) {
        return zzawx2.zzevt;
    }
}

