/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.view.View;
import android.widget.ImageView;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.media.CastMediaOptions;
import com.google.android.gms.cast.framework.media.ImageHints;
import com.google.android.gms.cast.framework.media.ImagePicker;
import com.google.android.gms.cast.framework.media.MediaUtils;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.uicontroller.UIController;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.internal.zzawe;
import com.google.android.gms.internal.zzawz;

public final class zzawy
extends UIController {
    private final ImageView zzevx;
    private final ImageHints zzeuw;
    private final Bitmap zzewb;
    private final View zzewc;
    private final ImagePicker zzesf;
    private final zzawe zzevz;

    public zzawy(ImageView imageView, Context context, @NonNull ImageHints imageHints, int n, View view) {
        this.zzevx = imageView;
        this.zzeuw = imageHints;
        this.zzewb = n != 0 ? BitmapFactory.decodeResource((Resources)context.getResources(), (int)n) : null;
        this.zzewc = view;
        CastMediaOptions castMediaOptions = CastContext.getSharedInstance(context).getCastOptions().getCastMediaOptions();
        this.zzesf = castMediaOptions != null ? castMediaOptions.getImagePicker() : null;
        this.zzevz = new zzawe(context.getApplicationContext());
    }

    @Override
    public final void onSessionConnected(CastSession castSession) {
        super.onSessionConnected(castSession);
        this.zzevz.zza(new zzawz(this));
        this.zzadq();
        this.zzadp();
    }

    @Override
    public final void onSessionEnded() {
        this.zzevz.clear();
        this.zzadq();
        super.onSessionEnded();
    }

    @Override
    public final void onMediaStatusUpdated() {
        this.zzadp();
    }

    private final void zzadp() {
        WebImage webImage;
        Uri uri;
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession()) {
            this.zzadq();
            return;
        }
        MediaInfo mediaInfo = remoteMediaClient.getMediaInfo();
        zzawy zzawy2 = this;
        if ((mediaInfo == null ? null : (uri = zzawy2.zzesf != null && (webImage = zzawy2.zzesf.onPickImage(mediaInfo.getMetadata(), zzawy2.zzeuw)) != null && webImage.getUrl() != null ? webImage.getUrl() : MediaUtils.getImageUri(mediaInfo, 0))) == null) {
            this.zzadq();
            return;
        }
        this.zzevz.zzl(uri);
    }

    private final void zzadq() {
        if (this.zzewc != null) {
            this.zzewc.setVisibility(0);
            this.zzevx.setVisibility(4);
        }
        if (this.zzewb != null) {
            this.zzevx.setImageBitmap(this.zzewb);
        }
    }

    static /* synthetic */ View zza(zzawy zzawy2) {
        return zzawy2.zzewc;
    }

    static /* synthetic */ ImageView zzb(zzawy zzawy2) {
        return zzawy2.zzevx;
    }
}

