/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.v7.media.MediaRouteSelector;
import android.support.v7.media.MediaRouter;
import android.view.KeyEvent;
import com.google.android.gms.cast.framework.AppVisibilityListener;
import com.google.android.gms.cast.framework.CastOptions;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.CastStateListener;
import com.google.android.gms.cast.framework.MediaNotificationManager;
import com.google.android.gms.cast.framework.OptionsProvider;
import com.google.android.gms.cast.framework.PrecacheManager;
import com.google.android.gms.cast.framework.SessionManager;
import com.google.android.gms.cast.framework.SessionProvider;
import com.google.android.gms.cast.framework.zza;
import com.google.android.gms.cast.framework.zze;
import com.google.android.gms.cast.framework.zzj;
import com.google.android.gms.cast.framework.zzp;
import com.google.android.gms.cast.framework.zzv;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.internal.zzavl;
import com.google.android.gms.internal.zzavm;
import com.google.android.gms.internal.zzawd;
import com.google.android.gms.internal.zzayy;
import com.google.android.gms.internal.zzazx;
import com.google.android.gms.internal.zzbed;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;

public final class CastContext {
    private static final zzazx zzejd = new zzazx("CastContext");
    public static final String OPTIONS_PROVIDER_CLASS_NAME_KEY = "com.google.android.gms.cast.framework.OPTIONS_PROVIDER_CLASS_NAME";
    private static CastContext zzeog;
    private final Context zzeoh;
    private final zzj zzeoi;
    private final SessionManager zzeoj;
    private final zze zzeok;
    private final PrecacheManager zzeol;
    private final MediaNotificationManager zzeom;
    private final CastOptions zzeon;
    private zzawd zzeoo;

    public static CastContext getSharedInstance(@NonNull Context context) throws IllegalStateException {
        zzbp.zzfy((String)"Must be called from the main thread.");
        if (zzeog == null) {
            OptionsProvider optionsProvider = CastContext.zzbm(context.getApplicationContext());
            zzeog = new CastContext(context, optionsProvider.getCastOptions(context.getApplicationContext()), optionsProvider.getAdditionalSessionProviders(context.getApplicationContext()));
        }
        return zzeog;
    }

    private static OptionsProvider zzbm(Context context) throws IllegalStateException {
        try {
            String string;
            Bundle bundle = zzbed.zzcr((Context)context).getApplicationInfo((String)context.getPackageName(), (int)128).metaData;
            if (bundle == null) {
                zzejd.zzc("Bundle is null", new Object[0]);
            }
            if ((string = bundle.getString(OPTIONS_PROVIDER_CLASS_NAME_KEY)) == null) {
                throw new IllegalStateException("The fully qualified name of the implementation of OptionsProvider must be provided as a metadata in the AndroidManifest.xml with key com.google.android.gms.cast.framework.OPTIONS_PROVIDER_CLASS_NAME.");
            }
            return (OptionsProvider)Class.forName(string).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (PackageManager.NameNotFoundException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | NullPointerException | InvocationTargetException throwable) {
            throw new IllegalStateException("Failed to initialize CastContext.", throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    private CastContext(Context context, CastOptions castOptions, List<SessionProvider> list) {
        PrecacheManager precacheManager;
        void var7_12;
        this.zzeoh = context.getApplicationContext();
        this.zzeon = castOptions;
        this.zzeoo = new zzawd(MediaRouter.getInstance((Context)this.zzeoh));
        HashMap<String, IBinder> hashMap = new HashMap<String, IBinder>();
        zzavm zzavm2 = new zzavm(this.zzeoh, castOptions, this.zzeoo);
        hashMap.put(zzavm2.getCategory(), zzavm2.zzacl());
        if (list != null) {
            for (SessionProvider object2 : list) {
                zzbp.zzb((Object)object2, (Object)"Additional SessionProvider must not be null.");
                String string2 = zzbp.zzh((String)object2.getCategory(), (Object)"Category for SessionProvider must not be null or empty string.");
                zzbp.zzb((!hashMap.containsKey(string2) ? 1 : 0) != 0, (Object)String.format("SessionProvider for category %s already added", string2));
                hashMap.put(string2, object2.zzacl());
            }
        }
        this.zzeoi = zzavl.zza(this.zzeoh, castOptions, this.zzeoo, hashMap);
        Object object3 = null;
        try {
            object3 = this.zzeoi.zzabz();
        }
        catch (RemoteException remoteException) {
            zzejd.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getDiscoveryManagerImpl", zzj.class.getSimpleName()});
        }
        this.zzeok = object3 == null ? null : new zze((zzp)object3);
        Object var7_10 = null;
        try {
            zzv zzv2 = this.zzeoi.zzaby();
        }
        catch (RemoteException remoteException) {
            zzejd.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getSessionManagerImpl", zzj.class.getSimpleName()});
        }
        this.zzeoj = var7_12 == null ? null : new SessionManager((zzv)var7_12, this.zzeoh);
        this.zzeom = new MediaNotificationManager(this.zzeoj);
        if (this.zzeoj == null) {
            precacheManager = null;
        } else {
            Context context2 = this.zzeoh;
            PrecacheManager precacheManager2 = new PrecacheManager(this.zzeon, this.zzeoj, new zzayy(context2));
            precacheManager = precacheManager2;
        }
        this.zzeol = precacheManager;
    }

    public final CastOptions getCastOptions() throws IllegalStateException {
        zzbp.zzfy((String)"Must be called from the main thread.");
        return this.zzeon;
    }

    public final SessionManager getSessionManager() throws IllegalStateException {
        zzbp.zzfy((String)"Must be called from the main thread.");
        return this.zzeoj;
    }

    public final MediaRouteSelector getMergedSelector() throws IllegalStateException {
        zzbp.zzfy((String)"Must be called from the main thread.");
        try {
            return MediaRouteSelector.fromBundle((Bundle)this.zzeoi.zzabx());
        }
        catch (RemoteException remoteException) {
            zzejd.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getMergedSelectorAsBundle", zzj.class.getSimpleName()});
            return null;
        }
    }

    public final int getCastState() {
        zzbp.zzfy((String)"Must be called from the main thread.");
        return this.zzeoj.getCastState();
    }

    public final PrecacheManager getPrecacheManager() {
        zzbp.zzfy((String)"Must be called from the main thread.");
        return this.zzeol;
    }

    public final boolean isAppVisible() throws IllegalStateException {
        zzbp.zzfy((String)"Must be called from the main thread.");
        try {
            return this.zzeoi.isAppVisible();
        }
        catch (RemoteException remoteException) {
            zzejd.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"isApplicationVisible", zzj.class.getSimpleName()});
            return false;
        }
    }

    public final MediaNotificationManager getMediaNotificationManager() {
        zzbp.zzfy((String)"Must be called from the main thread.");
        return this.zzeom;
    }

    public final void addAppVisibilityListener(AppVisibilityListener appVisibilityListener) throws IllegalStateException, NullPointerException {
        zzbp.zzfy((String)"Must be called from the main thread.");
        zzbp.zzu((Object)appVisibilityListener);
        try {
            this.zzeoi.zza(new zza(appVisibilityListener));
            return;
        }
        catch (RemoteException remoteException) {
            zzejd.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"addVisibilityChangeListener", zzj.class.getSimpleName()});
            return;
        }
    }

    public final void removeAppVisibilityListener(AppVisibilityListener appVisibilityListener) throws IllegalStateException {
        zzbp.zzfy((String)"Must be called from the main thread.");
        if (appVisibilityListener == null) {
            return;
        }
        try {
            this.zzeoi.zzb(new zza(appVisibilityListener));
            return;
        }
        catch (RemoteException remoteException) {
            zzejd.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"addVisibilityChangeListener", zzj.class.getSimpleName()});
            return;
        }
    }

    public final void addCastStateListener(CastStateListener castStateListener) throws IllegalStateException, NullPointerException {
        zzbp.zzfy((String)"Must be called from the main thread.");
        zzbp.zzu((Object)castStateListener);
        this.zzeoj.addCastStateListener(castStateListener);
    }

    public final void removeCastStateListener(CastStateListener castStateListener) throws IllegalStateException {
        zzbp.zzfy((String)"Must be called from the main thread.");
        if (castStateListener == null) {
            return;
        }
        this.zzeoj.removeCastStateListener(castStateListener);
    }

    public final zze zzabt() {
        zzbp.zzfy((String)"Must be called from the main thread.");
        return this.zzeok;
    }

    public final boolean onDispatchVolumeKeyEventBeforeJellyBean(KeyEvent keyEvent) {
        zzbp.zzfy((String)"Must be called from the main thread.");
        if (zzq.zzale()) {
            return false;
        }
        CastSession castSession = this.zzeoj.getCurrentCastSession();
        if (castSession == null || !castSession.isConnected()) {
            return false;
        }
        double d = this.getCastOptions().getVolumeDeltaBeforeIceCreamSandwich();
        boolean bl = keyEvent.getAction() == 0;
        switch (keyEvent.getKeyCode()) {
            case 24: {
                CastContext.zza(castSession, d, bl);
                return true;
            }
            case 25: {
                CastContext.zza(castSession, -d, bl);
                return true;
            }
        }
        return false;
    }

    private static boolean zza(CastSession castSession, double d, boolean bl) {
        if (bl) {
            try {
                double d2;
                double d3 = castSession.getVolume() + d;
                if (d2 > 1.0) {
                    d3 = 1.0;
                }
                castSession.setVolume(d3);
            }
            catch (IOException | IllegalStateException exception) {
                zzejd.zzc("Unable to call CastSession.setVolume(double).", new Object[]{exception});
            }
        }
        return true;
    }

    public final IObjectWrapper zzabu() {
        try {
            return this.zzeoi.zzaca();
        }
        catch (RemoteException remoteException) {
            zzejd.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getWrappedThis", zzj.class.getSimpleName()});
            return null;
        }
    }
}

