/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import com.google.android.gms.cast.ApplicationMetadata;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.LaunchOptions;
import com.google.android.gms.cast.framework.CastOptions;
import com.google.android.gms.cast.framework.Session;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.zzi;
import com.google.android.gms.cast.framework.zzl;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.common.util.zzh;
import com.google.android.gms.internal.zzavl;
import com.google.android.gms.internal.zzavn;
import com.google.android.gms.internal.zzawp;
import com.google.android.gms.internal.zzazx;
import com.google.android.gms.internal.zzazy;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class CastSession
extends Session {
    private static final zzazx zzejd = new zzazx("CastSession");
    private final Context zzeoh;
    private final Set<Cast.Listener> zzeow = new HashSet<Cast.Listener>();
    private final zzl zzeox;
    private final CastOptions zzeon;
    private final Cast.CastApi zzeoy;
    private final zzavn zzeoz;
    private final zzawp zzepa;
    private GoogleApiClient zzepb;
    private RemoteMediaClient zzepc;
    private CastDevice zzepd;
    private Cast.ApplicationConnectionResult zzepe;

    public CastSession(Context context, String string2, String string3, CastOptions castOptions, Cast.CastApi castApi, zzavn zzavn2, zzawp zzawp2) {
        super(context, string2, string3);
        this.zzeoh = context.getApplicationContext();
        this.zzeon = castOptions;
        this.zzeoy = castApi;
        this.zzeoz = zzavn2;
        this.zzepa = zzawp2;
        this.zzeox = zzavl.zza(context, castOptions, this.zzacb(), new zzb(this, null));
    }

    @Override
    protected void start(Bundle bundle) {
        this.zzf(bundle);
    }

    @Override
    protected void resume(Bundle bundle) {
        this.zzf(bundle);
    }

    @Override
    protected void end(boolean bl) {
        try {
            this.zzeox.zzb(bl, 0);
        }
        catch (RemoteException remoteException) {
            zzejd.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"disconnectFromDevice", zzl.class.getSimpleName()});
        }
        this.notifySessionEnded(0);
    }

    public RemoteMediaClient getRemoteMediaClient() {
        zzbp.zzfy((String)"Must be called from the main thread.");
        return this.zzepc;
    }

    public CastDevice getCastDevice() {
        zzbp.zzfy((String)"Must be called from the main thread.");
        return this.zzepd;
    }

    public void requestStatus() throws IOException, IllegalStateException {
        zzbp.zzfy((String)"Must be called from the main thread.");
        if (this.zzepb != null) {
            this.zzeoy.requestStatus(this.zzepb);
        }
    }

    public int getActiveInputState() throws IllegalStateException {
        zzbp.zzfy((String)"Must be called from the main thread.");
        if (this.zzepb != null) {
            return this.zzeoy.getActiveInputState(this.zzepb);
        }
        return -1;
    }

    public int getStandbyState() throws IllegalStateException {
        zzbp.zzfy((String)"Must be called from the main thread.");
        if (this.zzepb != null) {
            return this.zzeoy.getStandbyState(this.zzepb);
        }
        return -1;
    }

    public ApplicationMetadata getApplicationMetadata() throws IllegalStateException {
        zzbp.zzfy((String)"Must be called from the main thread.");
        if (this.zzepb != null) {
            return this.zzeoy.getApplicationMetadata(this.zzepb);
        }
        return null;
    }

    public String getApplicationStatus() throws IllegalStateException {
        zzbp.zzfy((String)"Must be called from the main thread.");
        if (this.zzepb != null) {
            return this.zzeoy.getApplicationStatus(this.zzepb);
        }
        return null;
    }

    public void setVolume(double d) throws IOException {
        zzbp.zzfy((String)"Must be called from the main thread.");
        if (this.zzepb != null) {
            this.zzeoy.setVolume(this.zzepb, d);
        }
    }

    public double getVolume() throws IllegalStateException {
        zzbp.zzfy((String)"Must be called from the main thread.");
        if (this.zzepb != null) {
            return this.zzeoy.getVolume(this.zzepb);
        }
        return 0.0;
    }

    public final zzawp zzabv() {
        return this.zzepa;
    }

    public void setMute(boolean bl) throws IOException, IllegalStateException {
        zzbp.zzfy((String)"Must be called from the main thread.");
        if (this.zzepb != null) {
            this.zzeoy.setMute(this.zzepb, bl);
        }
    }

    public boolean isMute() throws IllegalStateException {
        zzbp.zzfy((String)"Must be called from the main thread.");
        if (this.zzepb != null) {
            return this.zzeoy.isMute(this.zzepb);
        }
        return false;
    }

    public Cast.ApplicationConnectionResult getApplicationConnectionResult() {
        zzbp.zzfy((String)"Must be called from the main thread.");
        return this.zzepe;
    }

    public void setMessageReceivedCallbacks(String string2, Cast.MessageReceivedCallback messageReceivedCallback) throws IOException, IllegalStateException {
        zzbp.zzfy((String)"Must be called from the main thread.");
        if (this.zzepb != null) {
            this.zzeoy.setMessageReceivedCallbacks(this.zzepb, string2, messageReceivedCallback);
        }
    }

    public void removeMessageReceivedCallbacks(String string2) throws IOException, IllegalArgumentException {
        zzbp.zzfy((String)"Must be called from the main thread.");
        if (this.zzepb != null) {
            this.zzeoy.removeMessageReceivedCallbacks(this.zzepb, string2);
        }
    }

    public PendingResult<Status> sendMessage(String string2, String string3) {
        zzbp.zzfy((String)"Must be called from the main thread.");
        if (this.zzepb != null) {
            return this.zzeoy.sendMessage(this.zzepb, string2, string3);
        }
        return null;
    }

    public void addCastListener(Cast.Listener listener) {
        zzbp.zzfy((String)"Must be called from the main thread.");
        if (listener != null) {
            this.zzeow.add(listener);
        }
    }

    public void removeCastListener(Cast.Listener listener) {
        zzbp.zzfy((String)"Must be called from the main thread.");
        if (listener != null) {
            this.zzeow.remove(listener);
        }
    }

    private final void zzf(Bundle bundle) {
        zzd zzd2;
        this.zzepd = CastDevice.getFromBundle((Bundle)bundle);
        if (this.zzepd == null) {
            if (this.isResuming()) {
                this.notifyFailedToResumeSession(8);
                return;
            }
            this.notifyFailedToStartSession(8);
            return;
        }
        if (this.zzepb != null) {
            this.zzepb.disconnect();
            this.zzepb = null;
        }
        zzejd.zzb("Acquiring a connection to Google Play Services for %s", new Object[]{this.zzepd});
        zzd zzd3 = zzd2 = new zzd(this, null);
        zzd zzd4 = zzd2;
        zzc zzc2 = new zzc(this, null);
        CastOptions castOptions = this.zzeon;
        CastDevice castDevice = this.zzepd;
        Context context = this.zzeoh;
        Bundle bundle2 = new Bundle();
        bundle2.putBoolean("com.google.android.gms.cast.EXTRA_CAST_FRAMEWORK_NOTIFICATION_ENABLED", castOptions != null && castOptions.getCastMediaOptions() != null && castOptions.getCastMediaOptions().getNotificationOptions() != null);
        this.zzepb = new GoogleApiClient.Builder(context).addApi(Cast.API, (Api.ApiOptions.HasOptions)new Cast.CastOptions.Builder(castDevice, (Cast.Listener)zzc2).zze(bundle2).build()).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)zzd4).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)zzd3).build();
        this.zzepb.connect();
    }

    private final void zzbd(int n) {
        this.zzepa.zzbg(n);
        if (this.zzepb != null) {
            this.zzepb.disconnect();
            this.zzepb = null;
        }
        this.zzepd = null;
        if (this.zzepc != null) {
            try {
                this.zzepc.zzc(null);
            }
            catch (IOException iOException) {
                zzejd.zza((Throwable)iOException, "Exception when setting GoogleApiClient.", new Object[0]);
            }
            this.zzepc = null;
        }
        this.zzepe = null;
    }

    @Override
    public long getSessionRemainingTimeMs() {
        zzbp.zzfy((String)"Must be called from the main thread.");
        if (this.zzepc == null) {
            return 0L;
        }
        return this.zzepc.getStreamDuration() - this.zzepc.getApproximateStreamPosition();
    }

    final class zzb
    extends zzi {
        private /* synthetic */ CastSession zzepg;

        private zzb(CastSession castSession) {
            this.zzepg = castSession;
        }

        @Override
        public final void zzr(String string2, String string3) {
            this.zzepg.zzeoy.joinApplication(this.zzepg.zzepb, string2, string3).setResultCallback((ResultCallback)new zza(this.zzepg, "joinApplication"));
        }

        @Override
        public final void zza(String string2, LaunchOptions launchOptions) {
            this.zzepg.zzeoy.launchApplication(this.zzepg.zzepb, string2, launchOptions).setResultCallback((ResultCallback)new zza(this.zzepg, "launchApplication"));
        }

        @Override
        public final void zzez(String string2) {
            this.zzepg.zzeoy.stopApplication(this.zzepg.zzepb, string2);
        }

        @Override
        public final void zzbd(int n) {
            this.zzepg.zzbd(n);
        }

        /* synthetic */ zzb(CastSession castSession, com.google.android.gms.cast.framework.zzc zzc2) {
            this(castSession);
        }
    }

    final class zza
    implements ResultCallback<Cast.ApplicationConnectionResult> {
        private String zzepf;
        private /* synthetic */ CastSession zzepg;

        zza(CastSession castSession, String string2) {
            this.zzepg = castSession;
            this.zzepf = string2;
        }

        public final /* synthetic */ void onResult(@NonNull Result result) {
            Cast.ApplicationConnectionResult applicationConnectionResult = (Cast.ApplicationConnectionResult)result;
            zza zza2 = this;
            zza2.zzepg.zzepe = applicationConnectionResult;
            try {
                if (applicationConnectionResult.getStatus().isSuccess()) {
                    zzejd.zzb("%s() -> success result", new Object[]{zza2.zzepf});
                    zza2.zzepg.zzepc = new RemoteMediaClient(new zzazy(null, zzh.zzalc()), zza2.zzepg.zzeoy);
                    try {
                        zza2.zzepg.zzepc.zzc(zza2.zzepg.zzepb);
                        zza2.zzepg.zzepc.zzadd();
                        zza2.zzepg.zzepc.requestStatus();
                        zza2.zzepg.zzepa.zza(zza2.zzepg.zzepc, zza2.zzepg.getCastDevice());
                    }
                    catch (IOException iOException) {
                        zzejd.zza((Throwable)iOException, "Exception when setting GoogleApiClient.", new Object[0]);
                        zza2.zzepg.zzepc = null;
                    }
                    zza2.zzepg.zzeox.zza(applicationConnectionResult.getApplicationMetadata(), applicationConnectionResult.getApplicationStatus(), applicationConnectionResult.getSessionId(), applicationConnectionResult.getWasLaunched());
                    return;
                }
                zzejd.zzb("%s() -> failure result", new Object[]{zza2.zzepf});
                zza2.zzepg.zzeox.zzbe(applicationConnectionResult.getStatus().getStatusCode());
                return;
            }
            catch (RemoteException remoteException) {
                zzejd.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"methods", zzl.class.getSimpleName()});
                return;
            }
        }
    }

    final class zzc
    extends Cast.Listener {
        private /* synthetic */ CastSession zzepg;

        private zzc(CastSession castSession) {
            this.zzepg = castSession;
        }

        public final void onApplicationDisconnected(int n) {
            this.zzepg.zzbd(n);
            this.zzepg.notifySessionEnded(n);
            Iterator iterator = new HashSet(this.zzepg.zzeow).iterator();
            while (iterator.hasNext()) {
                ((Cast.Listener)iterator.next()).onApplicationDisconnected(n);
            }
        }

        public final void onApplicationStatusChanged() {
            Iterator iterator = new HashSet(this.zzepg.zzeow).iterator();
            while (iterator.hasNext()) {
                ((Cast.Listener)iterator.next()).onApplicationStatusChanged();
            }
        }

        public final void onApplicationMetadataChanged(ApplicationMetadata applicationMetadata) {
            Iterator iterator = new HashSet(this.zzepg.zzeow).iterator();
            while (iterator.hasNext()) {
                ((Cast.Listener)iterator.next()).onApplicationMetadataChanged(applicationMetadata);
            }
        }

        public final void onActiveInputStateChanged(int n) {
            Iterator iterator = new HashSet(this.zzepg.zzeow).iterator();
            while (iterator.hasNext()) {
                ((Cast.Listener)iterator.next()).onActiveInputStateChanged(n);
            }
        }

        public final void onStandbyStateChanged(int n) {
            Iterator iterator = new HashSet(this.zzepg.zzeow).iterator();
            while (iterator.hasNext()) {
                ((Cast.Listener)iterator.next()).onStandbyStateChanged(n);
            }
        }

        public final void onVolumeChanged() {
            Iterator iterator = new HashSet(this.zzepg.zzeow).iterator();
            while (iterator.hasNext()) {
                ((Cast.Listener)iterator.next()).onVolumeChanged();
            }
        }

        /* synthetic */ zzc(CastSession castSession, com.google.android.gms.cast.framework.zzc zzc2) {
            this(castSession);
        }
    }

    final class zzd
    implements GoogleApiClient.ConnectionCallbacks,
    GoogleApiClient.OnConnectionFailedListener {
        private /* synthetic */ CastSession zzepg;

        private zzd(CastSession castSession) {
            this.zzepg = castSession;
        }

        public final void onConnected(Bundle bundle) {
            try {
                if (this.zzepg.zzepc != null) {
                    try {
                        this.zzepg.zzepc.zzadd();
                        this.zzepg.zzepc.requestStatus();
                    }
                    catch (IOException iOException) {
                        zzejd.zza((Throwable)iOException, "Exception when setting GoogleApiClient.", new Object[0]);
                        this.zzepg.zzepc = null;
                    }
                }
                this.zzepg.zzeox.onConnected(bundle);
                return;
            }
            catch (RemoteException remoteException) {
                zzejd.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"onConnected", zzl.class.getSimpleName()});
                return;
            }
        }

        public final void onConnectionSuspended(int n) {
            try {
                this.zzepg.zzeox.onConnectionSuspended(n);
                return;
            }
            catch (RemoteException remoteException) {
                zzejd.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"onConnectionSuspended", zzl.class.getSimpleName()});
                return;
            }
        }

        public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            try {
                this.zzepg.zzeox.onConnectionFailed(connectionResult);
                return;
            }
            catch (RemoteException remoteException) {
                zzejd.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"onConnectionFailed", zzl.class.getSimpleName()});
                return;
            }
        }

        /* synthetic */ zzd(CastSession castSession, com.google.android.gms.cast.framework.zzc zzc2) {
            this(castSession);
        }
    }
}

