/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.internal.featurehighlight;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.Keep;
import com.google.android.gms.R;
import com.google.android.gms.internal.zzdff;

class InnerZoneDrawable
extends Drawable {
    private final Paint zzeqk = new Paint();
    private final Paint zzerk = new Paint();
    private final Rect zzeqp = new Rect();
    private final int zzerl;
    private final int zzerm;
    private float zzeql;
    private float zzern = 1.0f;
    private float centerX;
    private float centerY;
    private float zzero;
    private float zzerp;

    public InnerZoneDrawable(Context context) {
        Resources resources = context.getResources();
        this.zzerl = resources.getDimensionPixelSize(R.dimen.cast_libraries_material_featurehighlight_inner_radius);
        this.zzerm = resources.getInteger(R.integer.cast_libraries_material_featurehighlight_pulse_base_alpha);
        this.zzeqk.setAntiAlias(true);
        this.zzeqk.setStyle(Paint.Style.FILL);
        this.zzerk.setAntiAlias(true);
        this.zzerk.setStyle(Paint.Style.FILL);
        InnerZoneDrawable innerZoneDrawable = this;
        innerZoneDrawable.zzeqk.setColor(-1);
        innerZoneDrawable.zzerk.setColor(-1);
        innerZoneDrawable.invalidateSelf();
    }

    public void draw(Canvas canvas) {
        if (this.zzerp > 0.0f) {
            float f = this.zzeql * this.zzero;
            this.zzerk.setAlpha((int)((float)this.zzerm * this.zzerp));
            canvas.drawCircle(this.centerX, this.centerY, f, this.zzerk);
        }
        canvas.drawCircle(this.centerX, this.centerY, this.zzeql * this.zzern, this.zzeqk);
    }

    public void setAlpha(int n) {
        this.zzeqk.setAlpha(n);
        this.invalidateSelf();
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.zzeqk.setColorFilter(colorFilter);
        this.invalidateSelf();
    }

    public int getOpacity() {
        return -3;
    }

    @Keep
    public void setScale(float f) {
        this.zzern = f;
        this.invalidateSelf();
    }

    @Keep
    public void setPulseScale(float f) {
        this.zzero = f;
        this.invalidateSelf();
    }

    @Keep
    public void setPulseAlpha(float f) {
        this.zzerp = f;
        this.invalidateSelf();
    }

    public final void zzc(Rect rect) {
        this.zzeqp.set(rect);
        this.centerX = this.zzeqp.exactCenterX();
        this.centerY = this.zzeqp.exactCenterY();
        this.zzeql = Math.max((float)this.zzerl, Math.max((float)this.zzeqp.width() / 2.0f, (float)this.zzeqp.height() / 2.0f));
        this.invalidateSelf();
    }

    public final Animator zzacw() {
        PropertyValuesHolder propertyValuesHolder = PropertyValuesHolder.ofFloat((String)"scale", (float[])new float[]{0.0f});
        PropertyValuesHolder propertyValuesHolder2 = PropertyValuesHolder.ofInt((String)"alpha", (int[])new int[]{0});
        PropertyValuesHolder propertyValuesHolder3 = PropertyValuesHolder.ofFloat((String)"pulseScale", (float[])new float[]{0.0f});
        PropertyValuesHolder propertyValuesHolder4 = PropertyValuesHolder.ofFloat((String)"pulseAlpha", (float[])new float[]{0.0f});
        ObjectAnimator objectAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this), (PropertyValuesHolder[])new PropertyValuesHolder[]{propertyValuesHolder, propertyValuesHolder2, propertyValuesHolder3, propertyValuesHolder4});
        objectAnimator.setInterpolator((TimeInterpolator)zzdff.zzbjg());
        return objectAnimator.setDuration(200L);
    }
}

