/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Xfermode;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.google.android.gms.R;
import com.google.android.gms.cast.framework.IntroductoryOverlay;
import com.google.android.gms.internal.zzavu;
import com.google.android.gms.internal.zzavz;
import com.google.android.gms.internal.zzawb;

public final class zzavy
extends RelativeLayout
implements IntroductoryOverlay {
    private final boolean zzeqb;
    private Activity mActivity;
    private int zzeqg;
    private boolean zzeqd;
    private IntroductoryOverlay.OnOverlayDismissedListener zzepm;
    private final zzawb zzeqh;

    public zzavy(IntroductoryOverlay.Builder builder) {
        this(builder, null, R.attr.castIntroOverlayStyle);
    }

    private zzavy(IntroductoryOverlay.Builder builder, AttributeSet attributeSet, int n) {
        super((Context)builder.getActivity(), null, n);
        TypedArray typedArray;
        Object object;
        this.mActivity = builder.getActivity();
        this.zzeqb = builder.zzach();
        this.zzepm = builder.zzacf();
        TypedArray typedArray2 = this.mActivity.getTheme().obtainStyledAttributes(null, R.styleable.CastIntroOverlay, n, R.style.CastIntroOverlay);
        if (builder.zzace() != null) {
            Rect rect = new Rect();
            builder.zzace().getGlobalVisibleRect(rect);
            this.zzeqh = new zzawb(null);
            this.zzeqh.x = rect.centerX();
            this.zzeqh.y = rect.centerY();
            object = new PorterDuffXfermode(PorterDuff.Mode.MULTIPLY);
            typedArray = new Paint();
            typedArray.setColor(-1);
            typedArray.setAlpha(0);
            typedArray.setXfermode((Xfermode)object);
            typedArray.setAntiAlias(true);
            this.zzeqh.zzeqk = typedArray;
            this.zzeqh.zzeql = builder.zzack();
            if (this.zzeqh.zzeql == 0.0f) {
                this.zzeqh.zzeql = typedArray2.getDimension(R.styleable.CastIntroOverlay_castFocusRadius, 0.0f);
            }
        } else {
            this.zzeqh = null;
        }
        LayoutInflater.from((Context)this.mActivity).inflate(R.layout.cast_intro_overlay, (ViewGroup)this);
        this.zzeqg = builder.zzacg();
        if (this.zzeqg == 0) {
            this.zzeqg = typedArray2.getColor(R.styleable.CastIntroOverlay_castBackgroundColor, Color.argb((int)0, (int)0, (int)0, (int)0));
        }
        TextView textView = (TextView)this.findViewById(R.id.textTitle);
        if (!TextUtils.isEmpty((CharSequence)builder.zzaci())) {
            textView.setText((CharSequence)builder.zzaci());
            int n2 = typedArray2.getResourceId(R.styleable.CastIntroOverlay_castTitleTextAppearance, 0);
            if (n2 != 0) {
                textView.setTextAppearance((Context)this.mActivity, n2);
            }
        }
        typedArray = typedArray2;
        object = builder.zzacj();
        zzavy zzavy2 = this;
        Object object2 = object;
        if (TextUtils.isEmpty((CharSequence)object)) {
            object2 = typedArray.getString(R.styleable.CastIntroOverlay_castButtonText);
        }
        int n3 = typedArray.getColor(R.styleable.CastIntroOverlay_castButtonBackgroundColor, Color.argb((int)0, (int)0, (int)0, (int)0));
        Button button = (Button)zzavy2.findViewById(R.id.button);
        button.setText((CharSequence)object2);
        button.getBackground().setColorFilter(n3, PorterDuff.Mode.MULTIPLY);
        int n4 = typedArray.getResourceId(R.styleable.CastIntroOverlay_castButtonTextAppearance, 0);
        if (n4 != 0) {
            button.setTextAppearance((Context)zzavy2.mActivity, n4);
        }
        button.setOnClickListener((View.OnClickListener)new zzavz(zzavy2));
        typedArray2.recycle();
        this.setFitsSystemWindows(true);
    }

    @Override
    public final void show() {
        if (this.mActivity == null) {
            return;
        }
        if (zzavu.zzbq((Context)this.mActivity)) {
            return;
        }
        if (this.zzeqb && IntroductoryOverlay.zza.zzbo((Context)this.mActivity)) {
            this.mActivity = null;
            this.zzepm = null;
            return;
        }
        if (!this.zzeqd) {
            this.zzeqd = true;
            ((ViewGroup)this.mActivity.getWindow().getDecorView()).addView((View)this);
        }
    }

    @Override
    public final void remove() {
        if (this.mActivity != null) {
            ((ViewGroup)this.mActivity.getWindow().getDecorView()).removeView((View)this);
            this.mActivity = null;
        }
        this.zzepm = null;
    }

    protected final void dispatchDraw(Canvas canvas) {
        Bitmap bitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas2 = new Canvas(bitmap);
        canvas2.drawColor(this.zzeqg);
        if (this.zzeqh != null) {
            canvas2.drawCircle((float)this.zzeqh.x, (float)this.zzeqh.y, this.zzeqh.zzeql, this.zzeqh.zzeqk);
        }
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, null);
        bitmap.recycle();
        super.dispatchDraw(canvas);
    }

    public final boolean onTouchEvent(MotionEvent motionEvent) {
        return true;
    }

    protected final void onDetachedFromWindow() {
        if (this.mActivity != null) {
            this.mActivity = null;
        }
        super.onDetachedFromWindow();
    }

    private final void zzacq() {
        IntroductoryOverlay.zza.zzbn((Context)this.mActivity);
        if (this.zzepm != null) {
            this.zzepm.onOverlayDismissed();
            this.zzepm = null;
        }
        this.remove();
    }

    static /* synthetic */ void zza(zzavy zzavy2) {
        zzavy2.zzacq();
    }
}

