/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.view.View;
import android.widget.ImageView;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.media.CastMediaOptions;
import com.google.android.gms.cast.framework.media.ImageHints;
import com.google.android.gms.cast.framework.media.ImagePicker;
import com.google.android.gms.cast.framework.media.MediaUtils;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.uicontroller.UIController;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.internal.zzawe;
import com.google.android.gms.internal.zzawz;

public final class zzawy
extends UIController {
    private final ImageView zzevy;
    private final ImageHints zzeux;
    private final Bitmap zzewc;
    private final View zzewd;
    private final ImagePicker zzesg;
    private final zzawe zzewa;

    public zzawy(ImageView imageView, Context context, @NonNull ImageHints imageHints, int n, View view) {
        this.zzevy = imageView;
        this.zzeux = imageHints;
        this.zzewc = n != 0 ? BitmapFactory.decodeResource((Resources)context.getResources(), (int)n) : null;
        this.zzewd = view;
        CastMediaOptions castMediaOptions = CastContext.getSharedInstance(context).getCastOptions().getCastMediaOptions();
        this.zzesg = castMediaOptions != null ? castMediaOptions.getImagePicker() : null;
        this.zzewa = new zzawe(context.getApplicationContext());
    }

    @Override
    public final void onSessionConnected(CastSession castSession) {
        super.onSessionConnected(castSession);
        this.zzewa.zza(new zzawz(this));
        this.zzadq();
        this.zzadp();
    }

    @Override
    public final void onSessionEnded() {
        this.zzewa.clear();
        this.zzadq();
        super.onSessionEnded();
    }

    @Override
    public final void onMediaStatusUpdated() {
        this.zzadp();
    }

    private final void zzadp() {
        WebImage webImage;
        Uri uri;
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession()) {
            this.zzadq();
            return;
        }
        MediaInfo mediaInfo = remoteMediaClient.getMediaInfo();
        zzawy zzawy2 = this;
        if ((mediaInfo == null ? null : (uri = zzawy2.zzesg != null && (webImage = zzawy2.zzesg.onPickImage(mediaInfo.getMetadata(), zzawy2.zzeux)) != null && webImage.getUrl() != null ? webImage.getUrl() : MediaUtils.getImageUri(mediaInfo, 0))) == null) {
            this.zzadq();
            return;
        }
        this.zzewa.zzl(uri);
    }

    private final void zzadq() {
        if (this.zzewd != null) {
            this.zzewd.setVisibility(0);
            this.zzevy.setVisibility(4);
        }
        if (this.zzewc != null) {
            this.zzevy.setImageBitmap(this.zzewc);
        }
    }

    static /* synthetic */ View zza(zzawy zzawy2) {
        return zzawy2.zzewd;
    }

    static /* synthetic */ ImageView zzb(zzawy zzawy2) {
        return zzawy2.zzevy;
    }
}

