/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.v7.media.MediaRouteSelector;
import android.support.v7.media.MediaRouter;
import android.view.KeyEvent;
import com.google.android.gms.cast.framework.AppVisibilityListener;
import com.google.android.gms.cast.framework.CastOptions;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.CastStateListener;
import com.google.android.gms.cast.framework.MediaNotificationManager;
import com.google.android.gms.cast.framework.OptionsProvider;
import com.google.android.gms.cast.framework.PrecacheManager;
import com.google.android.gms.cast.framework.SessionManager;
import com.google.android.gms.cast.framework.SessionProvider;
import com.google.android.gms.cast.framework.zza;
import com.google.android.gms.cast.framework.zze;
import com.google.android.gms.cast.framework.zzj;
import com.google.android.gms.cast.framework.zzp;
import com.google.android.gms.cast.framework.zzv;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.internal.zzaxj;
import com.google.android.gms.internal.zzaxk;
import com.google.android.gms.internal.zzayb;
import com.google.android.gms.internal.zzbaw;
import com.google.android.gms.internal.zzbbv;
import com.google.android.gms.internal.zzbgc;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;

public final class CastContext {
    private static final zzbbv zzelw = new zzbbv("CastContext");
    public static final String OPTIONS_PROVIDER_CLASS_NAME_KEY = "com.google.android.gms.cast.framework.OPTIONS_PROVIDER_CLASS_NAME";
    private static CastContext zzera;
    private final Context zzerb;
    private final zzj zzerc;
    private final SessionManager zzerd;
    private final zze zzere;
    private final PrecacheManager zzerf;
    private final MediaNotificationManager zzerg;
    private final CastOptions zzerh;
    private zzayb zzeri;

    public static CastContext getSharedInstance(@NonNull Context context) throws IllegalStateException {
        zzbq.zzga((String)"Must be called from the main thread.");
        if (zzera == null) {
            OptionsProvider optionsProvider = CastContext.zzbs(context.getApplicationContext());
            zzera = new CastContext(context, optionsProvider.getCastOptions(context.getApplicationContext()), optionsProvider.getAdditionalSessionProviders(context.getApplicationContext()));
        }
        return zzera;
    }

    private static OptionsProvider zzbs(Context context) throws IllegalStateException {
        try {
            String string;
            Bundle bundle = zzbgc.zzcy((Context)context).getApplicationInfo((String)context.getPackageName(), (int)128).metaData;
            if (bundle == null) {
                zzelw.zzc("Bundle is null", new Object[0]);
            }
            if ((string = bundle.getString(OPTIONS_PROVIDER_CLASS_NAME_KEY)) == null) {
                throw new IllegalStateException("The fully qualified name of the implementation of OptionsProvider must be provided as a metadata in the AndroidManifest.xml with key com.google.android.gms.cast.framework.OPTIONS_PROVIDER_CLASS_NAME.");
            }
            return (OptionsProvider)Class.forName(string).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (PackageManager.NameNotFoundException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | NullPointerException | InvocationTargetException throwable) {
            throw new IllegalStateException("Failed to initialize CastContext.", throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    private CastContext(Context context, CastOptions castOptions, List<SessionProvider> list) {
        PrecacheManager precacheManager;
        void var7_12;
        this.zzerb = context.getApplicationContext();
        this.zzerh = castOptions;
        this.zzeri = new zzayb(MediaRouter.getInstance((Context)this.zzerb));
        HashMap<String, IBinder> hashMap = new HashMap<String, IBinder>();
        zzaxk zzaxk2 = new zzaxk(this.zzerb, castOptions, this.zzeri);
        hashMap.put(zzaxk2.getCategory(), zzaxk2.zzada());
        if (list != null) {
            for (SessionProvider object2 : list) {
                zzbq.checkNotNull((Object)object2, (Object)"Additional SessionProvider must not be null.");
                String string2 = zzbq.zzh((String)object2.getCategory(), (Object)"Category for SessionProvider must not be null or empty string.");
                zzbq.checkArgument((!hashMap.containsKey(string2) ? 1 : 0) != 0, (Object)String.format("SessionProvider for category %s already added", string2));
                hashMap.put(string2, object2.zzada());
            }
        }
        this.zzerc = zzaxj.zza(this.zzerb, castOptions, this.zzeri, hashMap);
        Object object3 = null;
        try {
            object3 = this.zzerc.zzaco();
        }
        catch (RemoteException remoteException) {
            zzelw.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getDiscoveryManagerImpl", zzj.class.getSimpleName()});
        }
        this.zzere = object3 == null ? null : new zze((zzp)object3);
        Object var7_10 = null;
        try {
            zzv zzv2 = this.zzerc.zzacn();
        }
        catch (RemoteException remoteException) {
            zzelw.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getSessionManagerImpl", zzj.class.getSimpleName()});
        }
        this.zzerd = var7_12 == null ? null : new SessionManager((zzv)var7_12, this.zzerb);
        this.zzerg = new MediaNotificationManager(this.zzerd);
        if (this.zzerd == null) {
            precacheManager = null;
        } else {
            Context context2 = this.zzerb;
            PrecacheManager precacheManager2 = new PrecacheManager(this.zzerh, this.zzerd, new zzbaw(context2));
            precacheManager = precacheManager2;
        }
        this.zzerf = precacheManager;
    }

    public final CastOptions getCastOptions() throws IllegalStateException {
        zzbq.zzga((String)"Must be called from the main thread.");
        return this.zzerh;
    }

    public final SessionManager getSessionManager() throws IllegalStateException {
        zzbq.zzga((String)"Must be called from the main thread.");
        return this.zzerd;
    }

    public final MediaRouteSelector getMergedSelector() throws IllegalStateException {
        zzbq.zzga((String)"Must be called from the main thread.");
        try {
            return MediaRouteSelector.fromBundle((Bundle)this.zzerc.zzacm());
        }
        catch (RemoteException remoteException) {
            zzelw.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getMergedSelectorAsBundle", zzj.class.getSimpleName()});
            return null;
        }
    }

    public final int getCastState() {
        zzbq.zzga((String)"Must be called from the main thread.");
        return this.zzerd.getCastState();
    }

    public final PrecacheManager getPrecacheManager() {
        zzbq.zzga((String)"Must be called from the main thread.");
        return this.zzerf;
    }

    public final boolean isAppVisible() throws IllegalStateException {
        zzbq.zzga((String)"Must be called from the main thread.");
        try {
            return this.zzerc.isAppVisible();
        }
        catch (RemoteException remoteException) {
            zzelw.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"isApplicationVisible", zzj.class.getSimpleName()});
            return false;
        }
    }

    public final MediaNotificationManager getMediaNotificationManager() {
        zzbq.zzga((String)"Must be called from the main thread.");
        return this.zzerg;
    }

    public final void addAppVisibilityListener(AppVisibilityListener appVisibilityListener) throws IllegalStateException, NullPointerException {
        zzbq.zzga((String)"Must be called from the main thread.");
        zzbq.checkNotNull((Object)appVisibilityListener);
        try {
            this.zzerc.zza(new zza(appVisibilityListener));
            return;
        }
        catch (RemoteException remoteException) {
            zzelw.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"addVisibilityChangeListener", zzj.class.getSimpleName()});
            return;
        }
    }

    public final void removeAppVisibilityListener(AppVisibilityListener appVisibilityListener) throws IllegalStateException {
        zzbq.zzga((String)"Must be called from the main thread.");
        if (appVisibilityListener == null) {
            return;
        }
        try {
            this.zzerc.zzb(new zza(appVisibilityListener));
            return;
        }
        catch (RemoteException remoteException) {
            zzelw.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"addVisibilityChangeListener", zzj.class.getSimpleName()});
            return;
        }
    }

    public final void addCastStateListener(CastStateListener castStateListener) throws IllegalStateException, NullPointerException {
        zzbq.zzga((String)"Must be called from the main thread.");
        zzbq.checkNotNull((Object)castStateListener);
        this.zzerd.addCastStateListener(castStateListener);
    }

    public final void removeCastStateListener(CastStateListener castStateListener) throws IllegalStateException {
        zzbq.zzga((String)"Must be called from the main thread.");
        if (castStateListener == null) {
            return;
        }
        this.zzerd.removeCastStateListener(castStateListener);
    }

    public final zze zzaci() {
        zzbq.zzga((String)"Must be called from the main thread.");
        return this.zzere;
    }

    public final boolean onDispatchVolumeKeyEventBeforeJellyBean(KeyEvent keyEvent) {
        zzbq.zzga((String)"Must be called from the main thread.");
        if (zzq.zzalx()) {
            return false;
        }
        CastSession castSession = this.zzerd.getCurrentCastSession();
        if (castSession == null || !castSession.isConnected()) {
            return false;
        }
        double d = this.getCastOptions().getVolumeDeltaBeforeIceCreamSandwich();
        boolean bl = keyEvent.getAction() == 0;
        switch (keyEvent.getKeyCode()) {
            case 24: {
                CastContext.zza(castSession, d, bl);
                return true;
            }
            case 25: {
                CastContext.zza(castSession, -d, bl);
                return true;
            }
        }
        return false;
    }

    private static boolean zza(CastSession castSession, double d, boolean bl) {
        if (bl) {
            try {
                double d2;
                double d3 = castSession.getVolume() + d;
                if (d2 > 1.0) {
                    d3 = 1.0;
                }
                castSession.setVolume(d3);
            }
            catch (IOException | IllegalStateException exception) {
                zzelw.zzc("Unable to call CastSession.setVolume(double).", new Object[]{exception});
            }
        }
        return true;
    }

    public final IObjectWrapper zzacj() {
        try {
            return this.zzerc.zzacp();
        }
        catch (RemoteException remoteException) {
            zzelw.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getWrappedThis", zzj.class.getSimpleName()});
            return null;
        }
    }
}

