/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.cast.LaunchOptions;
import com.google.android.gms.cast.framework.media.CastMediaOptions;
import com.google.android.gms.cast.framework.zzb;
import com.google.android.gms.internal.zzbej;
import com.google.android.gms.internal.zzbem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CastOptions
extends zzbej {
    public static final Parcelable.Creator<CastOptions> CREATOR = new zzb();
    private final String zzerj;
    private final List<String> zzerk;
    private final boolean zzerl;
    private final LaunchOptions zzenl;
    private final boolean zzerm;
    private final CastMediaOptions zzern;
    private final boolean zzero;
    private final double zzerp;

    CastOptions(String string2, List<String> list, boolean bl, LaunchOptions launchOptions, boolean bl2, CastMediaOptions castMediaOptions, boolean bl3, double d) {
        this.zzerj = TextUtils.isEmpty((CharSequence)string2) ? "" : string2;
        int n = list == null ? 0 : list.size();
        this.zzerk = new ArrayList<String>(n);
        if (n > 0) {
            this.zzerk.addAll(list);
        }
        this.zzerl = bl;
        this.zzenl = launchOptions == null ? new LaunchOptions() : launchOptions;
        this.zzerm = bl2;
        this.zzern = castMediaOptions;
        this.zzero = bl3;
        this.zzerp = d;
    }

    public String getReceiverApplicationId() {
        return this.zzerj;
    }

    public List<String> getSupportedNamespaces() {
        return Collections.unmodifiableList(this.zzerk);
    }

    public boolean getStopReceiverApplicationWhenEndingSession() {
        return this.zzerl;
    }

    public LaunchOptions getLaunchOptions() {
        return this.zzenl;
    }

    public boolean getResumeSavedSession() {
        return this.zzerm;
    }

    public CastMediaOptions getCastMediaOptions() {
        return this.zzern;
    }

    public boolean getEnableReconnectionService() {
        return this.zzero;
    }

    public double getVolumeDeltaBeforeIceCreamSandwich() {
        return this.zzerp;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        CastOptions castOptions = this;
        int n2 = zzbem.zze((Parcel)parcel2);
        zzbem.zza((Parcel)parcel2, (int)2, (String)castOptions.getReceiverApplicationId(), (boolean)false);
        zzbem.zzb((Parcel)parcel2, (int)3, castOptions.getSupportedNamespaces(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)4, (boolean)castOptions.getStopReceiverApplicationWhenEndingSession());
        zzbem.zza((Parcel)parcel2, (int)5, (Parcelable)castOptions.getLaunchOptions(), (int)n, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)6, (boolean)castOptions.getResumeSavedSession());
        zzbem.zza((Parcel)parcel2, (int)7, (Parcelable)castOptions.getCastMediaOptions(), (int)n, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)8, (boolean)castOptions.getEnableReconnectionService());
        zzbem.zza((Parcel)parcel2, (int)9, (double)castOptions.getVolumeDeltaBeforeIceCreamSandwich());
        zzbem.zzai((Parcel)parcel2, (int)n2);
    }

    public static final class Builder {
        private String zzerj;
        private List<String> zzerk = new ArrayList<String>();
        private boolean zzerl;
        private LaunchOptions zzenl = new LaunchOptions();
        private boolean zzerm = true;
        private CastMediaOptions zzern = new CastMediaOptions.Builder().build();
        private boolean zzero = true;
        private double zzerp = 0.05f;

        public Builder() {
        }

        public final Builder setReceiverApplicationId(String string2) {
            this.zzerj = string2;
            return this;
        }

        public final Builder setSupportedNamespaces(List<String> list) {
            this.zzerk = list;
            return this;
        }

        public final Builder setStopReceiverApplicationWhenEndingSession(boolean bl) {
            this.zzerl = bl;
            return this;
        }

        public final Builder setLaunchOptions(LaunchOptions launchOptions) {
            this.zzenl = launchOptions;
            return this;
        }

        public final Builder setResumeSavedSession(boolean bl) {
            this.zzerm = bl;
            return this;
        }

        public final Builder setCastMediaOptions(CastMediaOptions castMediaOptions) {
            this.zzern = castMediaOptions;
            return this;
        }

        public final Builder setEnableReconnectionService(boolean bl) {
            this.zzero = bl;
            return this;
        }

        public final Builder setVolumeDeltaBeforeIceCreamSandwich(double d) throws IllegalArgumentException {
            if (d <= 0.0 || d > 0.5) {
                throw new IllegalArgumentException("volumeDelta must be greater than 0 and less or equal to 0.5");
            }
            this.zzerp = d;
            return this;
        }

        public final CastOptions build() {
            return new CastOptions(this.zzerj, this.zzerk, this.zzerl, this.zzenl, this.zzerm, this.zzern, this.zzero, this.zzerp);
        }
    }
}

