/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.app.Activity;
import android.content.Context;
import android.preference.PreferenceManager;
import android.support.annotation.ColorRes;
import android.support.annotation.DimenRes;
import android.support.annotation.StringRes;
import android.support.v7.app.MediaRouteButton;
import android.view.MenuItem;
import android.view.View;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.internal.zzaxs;
import com.google.android.gms.internal.zzaxw;

public interface IntroductoryOverlay {
    public void show();

    public void remove();

    public static class Builder {
        private final Activity mActivity;
        private final View zzesd;
        private int zzese;
        private String zzesf;
        private OnOverlayDismissedListener zzesg;
        private boolean zzesh;
        private float zzesi;
        private String zzesj;

        public Builder(Activity activity, MenuItem menuItem) {
            this.mActivity = (Activity)zzbq.checkNotNull((Object)activity);
            this.zzesd = ((MenuItem)zzbq.checkNotNull((Object)menuItem)).getActionView();
        }

        public Builder(Activity activity, MediaRouteButton mediaRouteButton) {
            this.mActivity = (Activity)zzbq.checkNotNull((Object)activity);
            this.zzesd = (View)zzbq.checkNotNull((Object)mediaRouteButton);
        }

        public Builder setOverlayColor(@ColorRes int n) {
            this.zzese = this.mActivity.getResources().getColor(n);
            return this;
        }

        public Builder setTitleText(String string2) {
            this.zzesf = string2;
            return this;
        }

        public Builder setTitleText(@StringRes int n) {
            this.zzesf = this.mActivity.getResources().getString(n);
            return this;
        }

        public Builder setOnOverlayDismissedListener(OnOverlayDismissedListener onOverlayDismissedListener) {
            this.zzesg = onOverlayDismissedListener;
            return this;
        }

        public Builder setSingleTime() {
            this.zzesh = true;
            return this;
        }

        public Builder setFocusRadiusId(@DimenRes int n) {
            this.zzesi = this.mActivity.getResources().getDimension(n);
            return this;
        }

        public Builder setFocusRadius(float f) {
            this.zzesi = f;
            return this;
        }

        public Builder setButtonText(String string2) {
            this.zzesj = string2;
            return this;
        }

        public Builder setButtonText(@StringRes int n) {
            this.zzesj = this.mActivity.getResources().getString(n);
            return this;
        }

        public final Activity getActivity() {
            return this.mActivity;
        }

        public final View zzact() {
            return this.zzesd;
        }

        public final OnOverlayDismissedListener zzacu() {
            return this.zzesg;
        }

        public final int zzacv() {
            return this.zzese;
        }

        public final boolean zzacw() {
            return this.zzesh;
        }

        public final String zzacx() {
            return this.zzesf;
        }

        public final String zzacy() {
            return this.zzesj;
        }

        public final float zzacz() {
            return this.zzesi;
        }

        public IntroductoryOverlay build() {
            if (zzq.zzalx()) {
                return new zzaxs(this);
            }
            return new zzaxw(this);
        }
    }

    public static final class zza {
        public static void zzbt(Context context) {
            PreferenceManager.getDefaultSharedPreferences((Context)context).edit().putBoolean("googlecast-introOverlayShown", true).apply();
        }

        public static boolean zzbu(Context context) {
            return PreferenceManager.getDefaultSharedPreferences((Context)context).getBoolean("googlecast-introOverlayShown", false);
        }
    }

    public static interface OnOverlayDismissedListener {
        public void onOverlayDismissed();
    }
}

