/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import com.google.android.gms.cast.framework.zzac;
import com.google.android.gms.cast.framework.zzad;
import com.google.android.gms.cast.framework.zzt;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.internal.zzaxj;
import com.google.android.gms.internal.zzbbv;

public abstract class Session {
    private static final zzbbv zzelw = new zzbbv("Session");
    private final zzt zzesm;
    private final zza zzesn = new zza(this, null);

    protected Session(Context context, String string2, String string3) {
        this.zzesm = zzaxj.zza(context, string2, string3, this.zzesn);
    }

    protected abstract void start(Bundle var1);

    protected abstract void resume(Bundle var1);

    protected abstract void end(boolean var1);

    protected void onStarting(Bundle bundle) {
    }

    protected void onResuming(Bundle bundle) {
    }

    public long getSessionRemainingTimeMs() {
        zzbq.zzga((String)"Must be called from the main thread.");
        return 0L;
    }

    public final String getCategory() {
        zzbq.zzga((String)"Must be called from the main thread.");
        try {
            return this.zzesm.getCategory();
        }
        catch (RemoteException remoteException) {
            zzelw.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getCategory", zzt.class.getSimpleName()});
            return null;
        }
    }

    public final String getSessionId() {
        zzbq.zzga((String)"Must be called from the main thread.");
        try {
            return this.zzesm.getSessionId();
        }
        catch (RemoteException remoteException) {
            zzelw.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getSessionId", zzt.class.getSimpleName()});
            return null;
        }
    }

    public boolean isConnected() {
        zzbq.zzga((String)"Must be called from the main thread.");
        try {
            return this.zzesm.isConnected();
        }
        catch (RemoteException remoteException) {
            zzelw.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"isConnected", zzt.class.getSimpleName()});
            return false;
        }
    }

    public boolean isConnecting() {
        zzbq.zzga((String)"Must be called from the main thread.");
        try {
            return this.zzesm.isConnecting();
        }
        catch (RemoteException remoteException) {
            zzelw.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"isConnecting", zzt.class.getSimpleName()});
            return false;
        }
    }

    public boolean isDisconnecting() {
        zzbq.zzga((String)"Must be called from the main thread.");
        try {
            return this.zzesm.isDisconnecting();
        }
        catch (RemoteException remoteException) {
            zzelw.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"isDisconnecting", zzt.class.getSimpleName()});
            return false;
        }
    }

    public boolean isDisconnected() {
        zzbq.zzga((String)"Must be called from the main thread.");
        try {
            return this.zzesm.isDisconnected();
        }
        catch (RemoteException remoteException) {
            zzelw.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"isDisconnected", zzt.class.getSimpleName()});
            return true;
        }
    }

    public boolean isResuming() {
        zzbq.zzga((String)"Must be called from the main thread.");
        try {
            return this.zzesm.isResuming();
        }
        catch (RemoteException remoteException) {
            zzelw.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"isResuming", zzt.class.getSimpleName()});
            return false;
        }
    }

    public boolean isSuspended() {
        zzbq.zzga((String)"Must be called from the main thread.");
        try {
            return this.zzesm.isSuspended();
        }
        catch (RemoteException remoteException) {
            zzelw.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"isSuspended", zzt.class.getSimpleName()});
            return false;
        }
    }

    protected final void notifySessionStarted(String string2) {
        try {
            this.zzesm.notifySessionStarted(string2);
            return;
        }
        catch (RemoteException remoteException) {
            zzelw.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"notifySessionStarted", zzt.class.getSimpleName()});
            return;
        }
    }

    protected final void notifyFailedToStartSession(int n) {
        try {
            this.zzesm.notifyFailedToStartSession(n);
            return;
        }
        catch (RemoteException remoteException) {
            zzelw.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"notifyFailedToStartSession", zzt.class.getSimpleName()});
            return;
        }
    }

    protected final void notifySessionEnded(int n) {
        try {
            this.zzesm.notifySessionEnded(n);
            return;
        }
        catch (RemoteException remoteException) {
            zzelw.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"notifySessionEnded", zzt.class.getSimpleName()});
            return;
        }
    }

    protected final void notifySessionResumed(boolean bl) {
        try {
            this.zzesm.notifySessionResumed(bl);
            return;
        }
        catch (RemoteException remoteException) {
            zzelw.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"notifySessionResumed", zzt.class.getSimpleName()});
            return;
        }
    }

    protected final void notifyFailedToResumeSession(int n) {
        try {
            this.zzesm.notifyFailedToResumeSession(n);
            return;
        }
        catch (RemoteException remoteException) {
            zzelw.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"notifyFailedToResumeSession", zzt.class.getSimpleName()});
            return;
        }
    }

    protected final void notifySessionSuspended(int n) {
        try {
            this.zzesm.notifySessionSuspended(n);
            return;
        }
        catch (RemoteException remoteException) {
            zzelw.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"notifySessionSuspended", zzt.class.getSimpleName()});
            return;
        }
    }

    public final IObjectWrapper zzacq() {
        try {
            return this.zzesm.zzacq();
        }
        catch (RemoteException remoteException) {
            zzelw.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getWrappedObject", zzt.class.getSimpleName()});
            return null;
        }
    }

    final class zza
    extends zzac {
        private /* synthetic */ Session zzeso;

        private zza(Session session) {
            this.zzeso = session;
        }

        @Override
        public final IObjectWrapper zzacs() {
            return zzn.zzy((Object)this.zzeso);
        }

        @Override
        public final void onStarting(Bundle bundle) {
            this.zzeso.onStarting(bundle);
        }

        @Override
        public final void start(Bundle bundle) {
            this.zzeso.start(bundle);
        }

        @Override
        public final void onResuming(Bundle bundle) {
            this.zzeso.onResuming(bundle);
        }

        @Override
        public final void resume(Bundle bundle) {
            this.zzeso.resume(bundle);
        }

        @Override
        public final void end(boolean bl) {
            this.zzeso.end(bl);
        }

        @Override
        public final long getSessionRemainingTimeMs() {
            return this.zzeso.getSessionRemainingTimeMs();
        }

        /* synthetic */ zza(Session session, zzad zzad2) {
            this(session);
        }
    }
}

