/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.internal.featurehighlight;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.Keep;
import android.support.v4.graphics.ColorUtils;
import android.util.TypedValue;
import com.google.android.gms.R;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.internal.zzdlp;
import com.google.android.gms.internal.zzdlr;

class OuterHighlightDrawable
extends Drawable {
    private final int zzeuq;
    private final int zzeur;
    private final int zzeus;
    private final Rect zzetj = new Rect();
    private final Rect zzeuk = new Rect();
    private final Paint zzete = new Paint();
    private float zzetf;
    private float zzeuh = 1.0f;
    private float centerX;
    private float centerY;
    private float zzeut = 0.0f;
    private float zzeuu = 0.0f;
    private int zzeuv = 244;

    public OuterHighlightDrawable(Context context) {
        if (zzq.zzamc()) {
            Context context2 = context;
            TypedValue typedValue = new TypedValue();
            context2.getTheme().resolveAttribute(16843827, typedValue, true);
            this.setColor(ColorUtils.setAlphaComponent((int)typedValue.data, (int)244));
        } else {
            this.setColor(context.getResources().getColor(R.color.cast_libraries_material_featurehighlight_outer_highlight_default_color));
        }
        this.zzete.setAntiAlias(true);
        this.zzete.setStyle(Paint.Style.FILL);
        Resources resources = context.getResources();
        this.zzeuq = resources.getDimensionPixelSize(R.dimen.cast_libraries_material_featurehighlight_center_threshold);
        this.zzeur = resources.getDimensionPixelSize(R.dimen.cast_libraries_material_featurehighlight_center_horizontal_offset);
        this.zzeus = resources.getDimensionPixelSize(R.dimen.cast_libraries_material_featurehighlight_outer_padding);
    }

    public void draw(Canvas canvas) {
        canvas.drawCircle(this.centerX + this.zzeut, this.centerY + this.zzeuu, this.zzetf * this.zzeuh, this.zzete);
    }

    public void setAlpha(int n) {
        this.zzete.setAlpha(n);
        this.invalidateSelf();
    }

    public int getAlpha() {
        return this.zzete.getAlpha();
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.zzete.setColorFilter(colorFilter);
        this.invalidateSelf();
    }

    public int getOpacity() {
        return -3;
    }

    @ColorInt
    public final int getColor() {
        return this.zzete.getColor();
    }

    public final void setColor(@ColorInt int n) {
        this.zzete.setColor(n);
        this.zzeuv = this.zzete.getAlpha();
        this.invalidateSelf();
    }

    public final void zzb(Rect rect, Rect rect2) {
        this.zzetj.set(rect);
        this.zzeuk.set(rect2);
        float f = rect.exactCenterX();
        float f2 = rect.exactCenterY();
        Rect rect3 = this.getBounds();
        if (Math.min(f2 - (float)rect3.top, (float)rect3.bottom - f2) < (float)this.zzeuq) {
            this.centerX = f;
            this.centerY = f2;
        } else {
            boolean bl = f <= rect3.exactCenterX();
            this.centerX = bl ? rect2.exactCenterX() + (float)this.zzeur : rect2.exactCenterX() - (float)this.zzeur;
            this.centerY = rect2.exactCenterY();
        }
        this.zzetf = (float)this.zzeus + Math.max(OuterHighlightDrawable.zza(this.centerX, this.centerY, rect), OuterHighlightDrawable.zza(this.centerX, this.centerY, rect2));
        this.invalidateSelf();
    }

    @Keep
    public void setScale(float f) {
        this.zzeuh = f;
        this.invalidateSelf();
    }

    @Keep
    public void setTranslationX(float f) {
        this.zzeut = f;
        this.invalidateSelf();
    }

    @Keep
    public void setTranslationY(float f) {
        this.zzeuu = f;
        this.invalidateSelf();
    }

    public final float getCenterX() {
        return this.centerX;
    }

    public final float getCenterY() {
        return this.centerY;
    }

    public final boolean zzd(float f, float f2) {
        return zzdlr.zza(f, f2, this.centerX, this.centerY) < this.zzetf;
    }

    private static float zza(float f, float f2, Rect rect) {
        float f3;
        float f4 = rect.bottom;
        float f5 = rect.right;
        float f6 = rect.top;
        float f7 = rect.left;
        float f8 = f2;
        float f9 = f;
        float f10 = zzdlr.zza(f9, f8, f7, f4);
        float f11 = zzdlr.zza(f9, f8, f5, f4);
        float f12 = zzdlr.zza(f9, f8, f5, f6);
        float f13 = zzdlr.zza(f9, f8, f7, f6);
        return (float)Math.ceil(f3 > f12 && f13 > f11 && f13 > f10 ? f13 : (f12 > f11 && f12 > f10 ? f12 : (f11 > f10 ? f11 : f10)));
    }

    public final Animator zze(float f, float f2) {
        PropertyValuesHolder propertyValuesHolder = PropertyValuesHolder.ofFloat((String)"scale", (float[])new float[]{0.0f, 1.0f});
        PropertyValuesHolder propertyValuesHolder2 = PropertyValuesHolder.ofFloat((String)"translationX", (float[])new float[]{f, 0.0f});
        PropertyValuesHolder propertyValuesHolder3 = PropertyValuesHolder.ofFloat((String)"translationY", (float[])new float[]{f2, 0.0f});
        PropertyValuesHolder propertyValuesHolder4 = PropertyValuesHolder.ofInt((String)"alpha", (int[])new int[]{0, this.zzeuv});
        ObjectAnimator objectAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this), (PropertyValuesHolder[])new PropertyValuesHolder[]{propertyValuesHolder, propertyValuesHolder2, propertyValuesHolder3, propertyValuesHolder4});
        objectAnimator.setInterpolator((TimeInterpolator)zzdlp.zzbkd());
        return objectAnimator.setDuration(350L);
    }
}

