/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media.uicontroller;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.view.View;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.SeekBar;
import android.widget.TextView;
import com.google.android.gms.R;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.Session;
import com.google.android.gms.cast.framework.SessionManager;
import com.google.android.gms.cast.framework.SessionManagerListener;
import com.google.android.gms.cast.framework.media.ImageHints;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.uicontroller.UIController;
import com.google.android.gms.cast.framework.media.uicontroller.zza;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzays;
import com.google.android.gms.internal.zzayu;
import com.google.android.gms.internal.zzayw;
import com.google.android.gms.internal.zzayy;
import com.google.android.gms.internal.zzazc;
import com.google.android.gms.internal.zzazd;
import com.google.android.gms.internal.zzaze;
import com.google.android.gms.internal.zzazf;
import com.google.android.gms.internal.zzazi;
import com.google.android.gms.internal.zzazk;
import com.google.android.gms.internal.zzazl;
import com.google.android.gms.internal.zzazn;
import com.google.android.gms.internal.zzazp;
import com.google.android.gms.internal.zzazr;
import com.google.android.gms.internal.zzazt;
import com.google.android.gms.internal.zzazu;
import com.google.android.gms.internal.zzazv;
import com.google.android.gms.internal.zzazw;
import com.google.android.gms.internal.zzazx;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UIMediaController
implements SessionManagerListener<CastSession>,
RemoteMediaClient.Listener {
    private final Activity mActivity;
    private final SessionManager zzerd;
    private final Map<View, List<UIController>> zzeyo = new HashMap<View, List<UIController>>();
    private final Set<zzazv> zzeyp = new HashSet<zzazv>();
    private RemoteMediaClient.Listener zzeyq;
    private RemoteMediaClient zzerw;

    public UIMediaController(Activity activity) {
        this.mActivity = activity;
        this.zzerd = CastContext.getSharedInstance((Context)activity).getSessionManager();
        this.zzerd.addSessionManagerListener(this, CastSession.class);
        this.zza(this.zzerd.getCurrentCastSession());
    }

    public boolean isActive() {
        zzbq.zzga((String)"Must be called from the main thread.");
        return this.zzerw != null;
    }

    public RemoteMediaClient getRemoteMediaClient() {
        zzbq.zzga((String)"Must be called from the main thread.");
        return this.zzerw;
    }

    public void setPostRemoteMediaClientListener(RemoteMediaClient.Listener listener) {
        zzbq.zzga((String)"Must be called from the main thread.");
        this.zzeyq = listener;
    }

    public void dispose() {
        zzbq.zzga((String)"Must be called from the main thread.");
        this.zzaed();
        this.zzeyo.clear();
        this.zzerd.removeSessionManagerListener(this, CastSession.class);
        this.zzeyq = null;
    }

    public void bindImageViewToPlayPauseToggle(@NonNull ImageView imageView, @NonNull Drawable drawable2, @NonNull Drawable drawable3, Drawable drawable4, View view, boolean bl) {
        zzbq.zzga((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzazi(imageView, (Context)this.mActivity, drawable2, drawable3, drawable4, view, bl));
    }

    public void bindViewToSkipNext(View view, int n) {
        zzbq.zzga((String)"Must be called from the main thread.");
        this.zza(view, new zzazp(view, n));
    }

    public void bindViewToSkipPrev(View view, int n) {
        zzbq.zzga((String)"Must be called from the main thread.");
        this.zza(view, new zzazr(view, n));
    }

    public void bindViewToForward(View view, long l) {
        zzbq.zzga((String)"Must be called from the main thread.");
        this.zza(view, new zzazn(view, l));
    }

    public void bindViewToRewind(View view, long l) {
        zzbq.zzga((String)"Must be called from the main thread.");
        this.bindViewToForward(view, -l);
    }

    public void bindViewToLoadingIndicator(View view) {
        zzbq.zzga((String)"Must be called from the main thread.");
        this.zza(view, new zzazc(view));
    }

    public void bindProgressBar(ProgressBar progressBar) {
        this.bindProgressBar(progressBar, 1000L);
    }

    public void bindProgressBar(ProgressBar progressBar, long l) {
        zzbq.zzga((String)"Must be called from the main thread.");
        this.zza((View)progressBar, new zzazk(progressBar, l));
    }

    public void bindSeekBar(SeekBar seekBar) {
        this.bindSeekBar(seekBar, 1000L);
    }

    public void bindSeekBar(SeekBar seekBar, long l) {
        zzbq.zzga((String)"Must be called from the main thread.");
        zza zza2 = new zza(this);
        this.zza((View)seekBar, new zzazl(seekBar, l, zza2));
    }

    public void bindTextViewToStreamPosition(TextView textView, boolean bl) {
        this.bindTextViewToStreamPosition(textView, bl, 1000L);
    }

    public void bindTextViewToStreamPosition(TextView textView, boolean bl, long l) {
        zzbq.zzga((String)"Must be called from the main thread.");
        zzazv zzazv2 = new zzazv(textView, l, this.mActivity.getString(R.string.cast_invalid_stream_position_text));
        if (bl) {
            this.zzeyp.add(zzazv2);
        }
        this.zza((View)textView, zzazv2);
    }

    public void bindTextViewToStreamDuration(TextView textView) {
        zzbq.zzga((String)"Must be called from the main thread.");
        this.zza((View)textView, new zzazu(textView, this.mActivity.getString(R.string.cast_invalid_stream_duration_text), null));
    }

    public void bindTextViewToStreamDuration(TextView textView, View view) {
        zzbq.zzga((String)"Must be called from the main thread.");
        this.zza((View)textView, new zzazu(textView, this.mActivity.getString(R.string.cast_invalid_stream_duration_text), view));
    }

    public void bindViewToLaunchExpandedController(View view) {
        zzbq.zzga((String)"Must be called from the main thread.");
        this.zza(view, new zzayy(view, this.mActivity));
    }

    public void bindViewToClosedCaption(View view) {
        zzbq.zzga((String)"Must be called from the main thread.");
        this.zza(view, new zzays(view, this.mActivity));
    }

    public void bindImageViewToMuteToggle(ImageView imageView) {
        zzbq.zzga((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzazf(imageView, (Context)this.mActivity));
    }

    public void bindTextViewToMetadataOfCurrentItem(TextView textView, String string2) {
        zzbq.zzga((String)"Must be called from the main thread.");
        this.bindTextViewToMetadataOfCurrentItem(textView, Collections.singletonList(string2));
    }

    public void bindTextViewToMetadataOfCurrentItem(TextView textView, List<String> list) {
        zzbq.zzga((String)"Must be called from the main thread.");
        this.zza((View)textView, new zzaze(textView, list));
    }

    @Deprecated
    public void bindImageViewToImageOfCurrentItem(ImageView imageView, int n, @DrawableRes int n2) {
        zzbq.zzga((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzayw(imageView, (Context)this.mActivity, new ImageHints(n, 0, 0), n2, null));
    }

    @Deprecated
    public void bindImageViewToImageOfCurrentItem(ImageView imageView, int n, View view) {
        zzbq.zzga((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzayw(imageView, (Context)this.mActivity, new ImageHints(n, 0, 0), 0, view));
    }

    public void bindImageViewToImageOfCurrentItem(ImageView imageView, @NonNull ImageHints imageHints, @DrawableRes int n) {
        zzbq.zzga((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzayw(imageView, (Context)this.mActivity, imageHints, n, null));
    }

    public void bindImageViewToImageOfCurrentItem(ImageView imageView, @NonNull ImageHints imageHints, View view) {
        zzbq.zzga((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzayw(imageView, (Context)this.mActivity, imageHints, 0, view));
    }

    public void bindViewVisibilityToMediaSession(View view, int n) {
        zzbq.zzga((String)"Must be called from the main thread.");
        this.zza(view, new zzazx(view, n));
    }

    public void bindTextViewToMetadataOfPreloadedItem(TextView textView, String string2) {
        zzbq.zzga((String)"Must be called from the main thread.");
        this.bindTextViewToMetadataOfPreloadedItem(textView, Collections.singletonList(string2));
    }

    public void bindTextViewToMetadataOfPreloadedItem(TextView textView, List<String> list) {
        zzbq.zzga((String)"Must be called from the main thread.");
        this.zza((View)textView, new zzazd(textView, list));
    }

    @Deprecated
    public void bindImageViewToImageOfPreloadedItem(ImageView imageView, int n, @DrawableRes int n2) {
        zzbq.zzga((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzayu(imageView, (Context)this.mActivity, new ImageHints(n, 0, 0), n2));
    }

    public void bindImageViewToImageOfPreloadedItem(ImageView imageView, @NonNull ImageHints imageHints, @DrawableRes int n) {
        zzbq.zzga((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzayu(imageView, (Context)this.mActivity, imageHints, n));
    }

    public void bindViewVisibilityToPreloadingEvent(View view, int n) {
        zzbq.zzga((String)"Must be called from the main thread.");
        this.zza(view, new zzazw(view, n));
    }

    public void bindViewToUIController(View view, UIController uIController) {
        zzbq.zzga((String)"Must be called from the main thread.");
        this.zza(view, uIController);
    }

    public void bindTextViewToSmartSubtitle(TextView textView) {
        zzbq.zzga((String)"Must be called from the main thread.");
        this.zza((View)textView, new zzazt(textView));
    }

    @Override
    public void onSessionStarting(CastSession castSession) {
    }

    @Override
    public void onSessionStarted(CastSession castSession, String string2) {
        this.zza(castSession);
    }

    @Override
    public void onSessionResuming(CastSession castSession, String string2) {
    }

    @Override
    public void onSessionResumed(CastSession castSession, boolean bl) {
        this.zza(castSession);
    }

    @Override
    public void onSessionStartFailed(CastSession castSession, int n) {
        this.zzaed();
    }

    @Override
    public void onSessionEnding(CastSession castSession) {
    }

    @Override
    public void onSessionEnded(CastSession castSession, int n) {
        this.zzaed();
    }

    @Override
    public void onSessionResumeFailed(CastSession castSession, int n) {
        this.zzaed();
    }

    @Override
    public void onSessionSuspended(CastSession castSession, int n) {
    }

    @Override
    public void onStatusUpdated() {
        this.zzaee();
        if (this.zzeyq != null) {
            this.zzeyq.onStatusUpdated();
        }
    }

    @Override
    public void onMetadataUpdated() {
        this.zzaee();
        if (this.zzeyq != null) {
            this.zzeyq.onMetadataUpdated();
        }
    }

    @Override
    public void onQueueStatusUpdated() {
        this.zzaee();
        if (this.zzeyq != null) {
            this.zzeyq.onQueueStatusUpdated();
        }
    }

    @Override
    public void onPreloadStatusUpdated() {
        this.zzaee();
        if (this.zzeyq != null) {
            this.zzeyq.onPreloadStatusUpdated();
        }
    }

    @Override
    public void onAdBreakStatusUpdated() {
        this.zzaee();
        if (this.zzeyq != null) {
            this.zzeyq.onAdBreakStatusUpdated();
        }
    }

    @Override
    public void onSendingRemoteMediaRequest() {
        Iterator<List<UIController>> iterator = this.zzeyo.values().iterator();
        while (iterator.hasNext()) {
            Iterator<UIController> iterator2 = iterator.next().iterator();
            while (iterator2.hasNext()) {
                iterator2.next().onSendingRemoteMediaRequest();
            }
        }
        if (this.zzeyq != null) {
            this.zzeyq.onSendingRemoteMediaRequest();
        }
    }

    private final void zza(Session session) {
        if (this.isActive() || !(session instanceof CastSession) || !session.isConnected()) {
            return;
        }
        CastSession castSession = (CastSession)session;
        this.zzerw = castSession.getRemoteMediaClient();
        if (this.zzerw != null) {
            this.zzerw.addListener(this);
            Iterator<List<UIController>> iterator = this.zzeyo.values().iterator();
            while (iterator.hasNext()) {
                Iterator<UIController> iterator2 = iterator.next().iterator();
                while (iterator2.hasNext()) {
                    iterator2.next().onSessionConnected(castSession);
                }
            }
            this.zzaee();
        }
    }

    private final void zzaed() {
        if (!this.isActive()) {
            return;
        }
        Iterator<List<UIController>> iterator = this.zzeyo.values().iterator();
        while (iterator.hasNext()) {
            Iterator<UIController> iterator2 = iterator.next().iterator();
            while (iterator2.hasNext()) {
                iterator2.next().onSessionEnded();
            }
        }
        this.zzerw.removeListener(this);
        this.zzerw = null;
    }

    private final void zza(View view, UIController uIController) {
        List<UIController> list = this.zzeyo.get(view);
        if (list == null) {
            list = new ArrayList<UIController>();
            this.zzeyo.put(view, list);
        }
        list.add(uIController);
        if (this.isActive()) {
            uIController.onSessionConnected(this.zzerd.getCurrentCastSession());
            this.zzaee();
        }
    }

    private final void zzaee() {
        Iterator<List<UIController>> iterator = this.zzeyo.values().iterator();
        while (iterator.hasNext()) {
            Iterator<UIController> iterator2 = iterator.next().iterator();
            while (iterator2.hasNext()) {
                iterator2.next().onMediaStatusUpdated();
            }
        }
    }

    static /* synthetic */ Set zza(UIMediaController uIMediaController) {
        return uIMediaController.zzeyp;
    }
}

