/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media.widget;

import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Bundle;
import android.support.annotation.DrawableRes;
import android.support.v4.app.Fragment;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.google.android.gms.R;
import com.google.android.gms.cast.framework.media.ImageHints;
import com.google.android.gms.cast.framework.media.uicontroller.UIMediaController;
import com.google.android.gms.cast.framework.media.widget.ControlButtonsContainer;
import com.google.android.gms.cast.framework.media.widget.zzb;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzbbv;

public class MiniControllerFragment
extends Fragment
implements ControlButtonsContainer {
    private static final zzbbv zzelw = new zzbbv("MiniControllerFragment");
    private boolean zzfbm;
    private int zzfbn;
    private int zzfbo;
    private TextView zzfbp;
    private int zzfbq;
    private int zzfbr;
    private int zzfax;
    private int[] zzfbc;
    private ImageView[] zzfbd = new ImageView[3];
    private int zzfbs;
    @DrawableRes
    private int zzfao;
    @DrawableRes
    private int zzfap;
    @DrawableRes
    private int zzfaq;
    @DrawableRes
    private int zzfbt;
    @DrawableRes
    private int zzfbu;
    @DrawableRes
    private int zzfbv;
    @DrawableRes
    private int zzfar;
    @DrawableRes
    private int zzfas;
    @DrawableRes
    private int zzfat;
    @DrawableRes
    private int zzfau;
    @DrawableRes
    private int zzfav;
    @DrawableRes
    private int zzfaw;
    private UIMediaController zzfbj;

    public MiniControllerFragment() {
    }

    public void onInflate(Context context, AttributeSet attributeSet, Bundle bundle) {
        super.onInflate(context, attributeSet, bundle);
        AttributeSet attributeSet2 = attributeSet;
        Context context2 = context;
        MiniControllerFragment miniControllerFragment = this;
        if (miniControllerFragment.zzfbc == null) {
            TypedArray typedArray = context2.obtainStyledAttributes(attributeSet2, R.styleable.CastMiniController, R.attr.castMiniControllerStyle, R.style.CastMiniController);
            miniControllerFragment.zzfbm = typedArray.getBoolean(R.styleable.CastMiniController_castShowImageThumbnail, true);
            miniControllerFragment.zzfbn = typedArray.getResourceId(R.styleable.CastMiniController_castTitleTextAppearance, 0);
            miniControllerFragment.zzfbo = typedArray.getResourceId(R.styleable.CastMiniController_castSubtitleTextAppearance, 0);
            miniControllerFragment.zzfbq = typedArray.getResourceId(R.styleable.CastMiniController_castBackground, 0);
            miniControllerFragment.zzfbr = typedArray.getColor(R.styleable.CastMiniController_castProgressBarColor, 0);
            miniControllerFragment.zzfax = typedArray.getResourceId(R.styleable.CastMiniController_castButtonColor, 0);
            miniControllerFragment.zzfao = typedArray.getResourceId(R.styleable.CastMiniController_castPlayButtonDrawable, 0);
            miniControllerFragment.zzfap = typedArray.getResourceId(R.styleable.CastMiniController_castPauseButtonDrawable, 0);
            miniControllerFragment.zzfaq = typedArray.getResourceId(R.styleable.CastMiniController_castStopButtonDrawable, 0);
            miniControllerFragment.zzfbt = typedArray.getResourceId(R.styleable.CastMiniController_castPlayButtonDrawable, 0);
            miniControllerFragment.zzfbu = typedArray.getResourceId(R.styleable.CastMiniController_castPauseButtonDrawable, 0);
            miniControllerFragment.zzfbv = typedArray.getResourceId(R.styleable.CastMiniController_castStopButtonDrawable, 0);
            miniControllerFragment.zzfar = typedArray.getResourceId(R.styleable.CastMiniController_castSkipPreviousButtonDrawable, 0);
            miniControllerFragment.zzfas = typedArray.getResourceId(R.styleable.CastMiniController_castSkipNextButtonDrawable, 0);
            miniControllerFragment.zzfat = typedArray.getResourceId(R.styleable.CastMiniController_castRewind30ButtonDrawable, 0);
            miniControllerFragment.zzfau = typedArray.getResourceId(R.styleable.CastMiniController_castForward30ButtonDrawable, 0);
            miniControllerFragment.zzfav = typedArray.getResourceId(R.styleable.CastMiniController_castMuteToggleButtonDrawable, 0);
            miniControllerFragment.zzfaw = typedArray.getResourceId(R.styleable.CastMiniController_castClosedCaptionsButtonDrawable, 0);
            int n = typedArray.getResourceId(R.styleable.CastMiniController_castControlButtons, 0);
            if (n != 0) {
                TypedArray typedArray2 = context2.getResources().obtainTypedArray(n);
                zzbq.checkArgument((typedArray2.length() == 3 ? 1 : 0) != 0);
                miniControllerFragment.zzfbc = new int[typedArray2.length()];
                for (int i = 0; i < typedArray2.length(); ++i) {
                    miniControllerFragment.zzfbc[i] = typedArray2.getResourceId(i, 0);
                }
                typedArray2.recycle();
                if (miniControllerFragment.zzfbm) {
                    miniControllerFragment.zzfbc[0] = R.id.cast_button_type_empty;
                }
                miniControllerFragment.zzfbs = 0;
                int[] nArray = miniControllerFragment.zzfbc;
                int n2 = miniControllerFragment.zzfbc.length;
                for (int i = 0; i < n2; ++i) {
                    if (nArray[i] == R.id.cast_button_type_empty) continue;
                    ++miniControllerFragment.zzfbs;
                }
            } else {
                zzelw.zzf("Unable to read attribute castControlButtons.", new Object[0]);
                miniControllerFragment.zzfbc = new int[]{R.id.cast_button_type_empty, R.id.cast_button_type_empty, R.id.cast_button_type_empty};
            }
            typedArray.recycle();
        }
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        this.zzfbj = new UIMediaController((Activity)this.getActivity());
        View view = layoutInflater.inflate(R.layout.cast_mini_controller, viewGroup);
        view.setVisibility(8);
        this.zzfbj.bindViewVisibilityToMediaSession(view, 8);
        RelativeLayout relativeLayout = (RelativeLayout)view.findViewById(R.id.container_current);
        if (this.zzfbq != 0) {
            relativeLayout.setBackgroundResource(this.zzfbq);
        }
        ImageView imageView = (ImageView)view.findViewById(R.id.icon_view);
        TextView textView = (TextView)view.findViewById(R.id.title_view);
        if (this.zzfbn != 0) {
            textView.setTextAppearance((Context)this.getActivity(), this.zzfbn);
        }
        this.zzfbp = (TextView)view.findViewById(R.id.subtitle_view);
        if (this.zzfbo != 0) {
            this.zzfbp.setTextAppearance((Context)this.getActivity(), this.zzfbo);
        }
        ProgressBar progressBar = (ProgressBar)view.findViewById(R.id.progressBar);
        if (this.zzfbr != 0) {
            ((LayerDrawable)progressBar.getProgressDrawable()).setColorFilter(this.zzfbr, PorterDuff.Mode.SRC_IN);
        }
        this.zzfbj.bindTextViewToMetadataOfCurrentItem(textView, "com.google.android.gms.cast.metadata.TITLE");
        this.zzfbj.bindTextViewToSmartSubtitle(this.zzfbp);
        this.zzfbj.bindProgressBar(progressBar);
        this.zzfbj.bindViewToLaunchExpandedController((View)relativeLayout);
        if (this.zzfbm) {
            int n = this.getResources().getDimensionPixelSize(R.dimen.cast_mini_controller_icon_width);
            int n2 = this.getResources().getDimensionPixelSize(R.dimen.cast_mini_controller_icon_height);
            this.zzfbj.bindImageViewToImageOfCurrentItem(imageView, new ImageHints(2, n, n2), R.drawable.cast_album_art_placeholder);
        } else {
            imageView.setVisibility(8);
        }
        this.zzfbd[0] = (ImageView)relativeLayout.findViewById(R.id.button_0);
        this.zzfbd[1] = (ImageView)relativeLayout.findViewById(R.id.button_1);
        this.zzfbd[2] = (ImageView)relativeLayout.findViewById(R.id.button_2);
        this.zza(relativeLayout, R.id.button_0, 0);
        this.zza(relativeLayout, R.id.button_1, 1);
        this.zza(relativeLayout, R.id.button_2, 2);
        return view;
    }

    public void onDestroy() {
        if (this.zzfbj != null) {
            this.zzfbj.dispose();
            this.zzfbj = null;
        }
        super.onDestroy();
    }

    @Override
    public final int getButtonSlotCount() {
        return 3;
    }

    @Override
    public final int getButtonTypeAt(int n) throws IndexOutOfBoundsException {
        return this.zzfbc[n];
    }

    @Override
    public final ImageView getButtonImageViewAt(int n) throws IndexOutOfBoundsException {
        return this.zzfbd[n];
    }

    @Override
    public UIMediaController getUIMediaController() {
        return this.zzfbj;
    }

    private final void zza(RelativeLayout relativeLayout, int n, int n2) {
        ImageView imageView = (ImageView)relativeLayout.findViewById(n);
        int n3 = this.zzfbc[n2];
        if (n3 == R.id.cast_button_type_empty) {
            imageView.setVisibility(4);
            return;
        }
        if (n3 != R.id.cast_button_type_custom) {
            if (n3 == R.id.cast_button_type_play_pause_toggle) {
                int n4 = this.zzfao;
                int n5 = this.zzfap;
                int n6 = this.zzfaq;
                if (this.zzfbs == 1) {
                    n4 = this.zzfbt;
                    n5 = this.zzfbu;
                    n6 = this.zzfbv;
                }
                Drawable drawable2 = zzb.zza(this.getContext(), this.zzfax, n4);
                Drawable drawable3 = zzb.zza(this.getContext(), this.zzfax, n5);
                Drawable drawable4 = zzb.zza(this.getContext(), this.zzfax, n6);
                imageView.setImageDrawable(drawable3);
                int n7 = n;
                MiniControllerFragment miniControllerFragment = this;
                ProgressBar progressBar = new ProgressBar(miniControllerFragment.getContext());
                RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
                layoutParams.addRule(8, n7);
                layoutParams.addRule(6, n7);
                layoutParams.addRule(5, n7);
                layoutParams.addRule(7, n7);
                layoutParams.addRule(15);
                progressBar.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                progressBar.setVisibility(8);
                Drawable drawable5 = progressBar.getIndeterminateDrawable();
                if (miniControllerFragment.zzfbr != 0 && drawable5 != null) {
                    drawable5.setColorFilter(miniControllerFragment.zzfbr, PorterDuff.Mode.SRC_IN);
                }
                ProgressBar progressBar2 = progressBar;
                relativeLayout.addView((View)progressBar2);
                this.zzfbj.bindImageViewToPlayPauseToggle(imageView, drawable2, drawable3, drawable4, (View)progressBar2, true);
                return;
            }
            if (n3 == R.id.cast_button_type_skip_previous) {
                imageView.setImageDrawable(zzb.zza(this.getContext(), this.zzfax, this.zzfar));
                imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_skip_prev));
                this.zzfbj.bindViewToSkipPrev((View)imageView, 0);
                return;
            }
            if (n3 == R.id.cast_button_type_skip_next) {
                imageView.setImageDrawable(zzb.zza(this.getContext(), this.zzfax, this.zzfas));
                imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_skip_next));
                this.zzfbj.bindViewToSkipNext((View)imageView, 0);
                return;
            }
            if (n3 == R.id.cast_button_type_rewind_30_seconds) {
                imageView.setImageDrawable(zzb.zza(this.getContext(), this.zzfax, this.zzfat));
                imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_rewind_30));
                this.zzfbj.bindViewToRewind((View)imageView, 30000L);
                return;
            }
            if (n3 == R.id.cast_button_type_forward_30_seconds) {
                imageView.setImageDrawable(zzb.zza(this.getContext(), this.zzfax, this.zzfau));
                imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_forward_30));
                this.zzfbj.bindViewToForward((View)imageView, 30000L);
                return;
            }
            if (n3 == R.id.cast_button_type_mute_toggle) {
                imageView.setImageDrawable(zzb.zza(this.getContext(), this.zzfax, this.zzfav));
                this.zzfbj.bindImageViewToMuteToggle(imageView);
                return;
            }
            if (n3 == R.id.cast_button_type_closed_caption) {
                imageView.setImageDrawable(zzb.zza(this.getContext(), this.zzfax, this.zzfaw));
                this.zzfbj.bindViewToClosedCaption((View)imageView);
            }
        }
    }
}

