/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Xfermode;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.google.android.gms.R;
import com.google.android.gms.cast.framework.IntroductoryOverlay;
import com.google.android.gms.internal.zzaxs;
import com.google.android.gms.internal.zzaxx;
import com.google.android.gms.internal.zzaxz;

public final class zzaxw
extends RelativeLayout
implements IntroductoryOverlay {
    private final boolean zzesv;
    private Activity mActivity;
    private int zzeta;
    private boolean zzesx;
    private IntroductoryOverlay.OnOverlayDismissedListener zzesg;
    private final zzaxz zzetb;

    public zzaxw(IntroductoryOverlay.Builder builder) {
        this(builder, null, R.attr.castIntroOverlayStyle);
    }

    private zzaxw(IntroductoryOverlay.Builder builder, AttributeSet attributeSet, int n) {
        super((Context)builder.getActivity(), null, n);
        TypedArray typedArray;
        Object object;
        this.mActivity = builder.getActivity();
        this.zzesv = builder.zzacw();
        this.zzesg = builder.zzacu();
        TypedArray typedArray2 = this.mActivity.getTheme().obtainStyledAttributes(null, R.styleable.CastIntroOverlay, n, R.style.CastIntroOverlay);
        if (builder.zzact() != null) {
            Rect rect = new Rect();
            builder.zzact().getGlobalVisibleRect(rect);
            this.zzetb = new zzaxz(null);
            this.zzetb.x = rect.centerX();
            this.zzetb.y = rect.centerY();
            object = new PorterDuffXfermode(PorterDuff.Mode.MULTIPLY);
            typedArray = new Paint();
            typedArray.setColor(-1);
            typedArray.setAlpha(0);
            typedArray.setXfermode((Xfermode)object);
            typedArray.setAntiAlias(true);
            this.zzetb.zzete = typedArray;
            this.zzetb.zzetf = builder.zzacz();
            if (this.zzetb.zzetf == 0.0f) {
                this.zzetb.zzetf = typedArray2.getDimension(R.styleable.CastIntroOverlay_castFocusRadius, 0.0f);
            }
        } else {
            this.zzetb = null;
        }
        LayoutInflater.from((Context)this.mActivity).inflate(R.layout.cast_intro_overlay, (ViewGroup)this);
        this.zzeta = builder.zzacv();
        if (this.zzeta == 0) {
            this.zzeta = typedArray2.getColor(R.styleable.CastIntroOverlay_castBackgroundColor, Color.argb((int)0, (int)0, (int)0, (int)0));
        }
        TextView textView = (TextView)this.findViewById(R.id.textTitle);
        if (!TextUtils.isEmpty((CharSequence)builder.zzacx())) {
            textView.setText((CharSequence)builder.zzacx());
            int n2 = typedArray2.getResourceId(R.styleable.CastIntroOverlay_castTitleTextAppearance, 0);
            if (n2 != 0) {
                textView.setTextAppearance((Context)this.mActivity, n2);
            }
        }
        typedArray = typedArray2;
        object = builder.zzacy();
        zzaxw zzaxw2 = this;
        Object object2 = object;
        if (TextUtils.isEmpty((CharSequence)object)) {
            object2 = typedArray.getString(R.styleable.CastIntroOverlay_castButtonText);
        }
        int n3 = typedArray.getColor(R.styleable.CastIntroOverlay_castButtonBackgroundColor, Color.argb((int)0, (int)0, (int)0, (int)0));
        Button button = (Button)zzaxw2.findViewById(R.id.button);
        button.setText((CharSequence)object2);
        button.getBackground().setColorFilter(n3, PorterDuff.Mode.MULTIPLY);
        int n4 = typedArray.getResourceId(R.styleable.CastIntroOverlay_castButtonTextAppearance, 0);
        if (n4 != 0) {
            button.setTextAppearance((Context)zzaxw2.mActivity, n4);
        }
        button.setOnClickListener((View.OnClickListener)new zzaxx(zzaxw2));
        typedArray2.recycle();
        this.setFitsSystemWindows(true);
    }

    @Override
    public final void show() {
        if (this.mActivity == null) {
            return;
        }
        if (zzaxs.zzbw((Context)this.mActivity)) {
            return;
        }
        if (this.zzesv && IntroductoryOverlay.zza.zzbu((Context)this.mActivity)) {
            this.mActivity = null;
            this.zzesg = null;
            return;
        }
        if (!this.zzesx) {
            this.zzesx = true;
            ((ViewGroup)this.mActivity.getWindow().getDecorView()).addView((View)this);
        }
    }

    @Override
    public final void remove() {
        if (this.mActivity != null) {
            ((ViewGroup)this.mActivity.getWindow().getDecorView()).removeView((View)this);
            this.mActivity = null;
        }
        this.zzesg = null;
    }

    protected final void dispatchDraw(Canvas canvas) {
        Bitmap bitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas2 = new Canvas(bitmap);
        canvas2.drawColor(this.zzeta);
        if (this.zzetb != null) {
            canvas2.drawCircle((float)this.zzetb.x, (float)this.zzetb.y, this.zzetb.zzetf, this.zzetb.zzete);
        }
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, null);
        bitmap.recycle();
        super.dispatchDraw(canvas);
    }

    public final boolean onTouchEvent(MotionEvent motionEvent) {
        return true;
    }

    protected final void onDetachedFromWindow() {
        if (this.mActivity != null) {
            this.mActivity = null;
        }
        super.onDetachedFromWindow();
    }

    private final void zzadf() {
        IntroductoryOverlay.zza.zzbt((Context)this.mActivity);
        if (this.zzesg != null) {
            this.zzesg.onOverlayDismissed();
            this.zzesg = null;
        }
        this.remove();
    }

    static /* synthetic */ void zza(zzaxw zzaxw2) {
        zzaxw2.zzadf();
    }
}

