/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Bundle;
import android.support.v4.media.session.MediaSessionCompat;
import android.support.v7.media.MediaRouteSelector;
import android.support.v7.media.MediaRouter;
import com.google.android.gms.internal.zzaxp;
import com.google.android.gms.internal.zzaxq;
import com.google.android.gms.internal.zzaya;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class zzayb
extends zzaxp {
    private final MediaRouter zzems;
    private final Map<MediaRouteSelector, Set<MediaRouter.Callback>> zzeth = new HashMap<MediaRouteSelector, Set<MediaRouter.Callback>>();

    public zzayb(MediaRouter mediaRouter) {
        this.zzems = mediaRouter;
    }

    @Override
    public final void zza(Bundle bundle, zzaxq zzaxq2) {
        MediaRouteSelector mediaRouteSelector = MediaRouteSelector.fromBundle((Bundle)bundle);
        if (!this.zzeth.containsKey(mediaRouteSelector)) {
            this.zzeth.put(mediaRouteSelector, new HashSet());
        }
        this.zzeth.get(mediaRouteSelector).add(new zzaya(zzaxq2));
    }

    @Override
    public final void zza(Bundle bundle, int n) {
        MediaRouteSelector mediaRouteSelector = MediaRouteSelector.fromBundle((Bundle)bundle);
        for (MediaRouter.Callback callback : this.zzeth.get(mediaRouteSelector)) {
            this.zzems.addCallback(mediaRouteSelector, callback, n);
        }
    }

    @Override
    public final void zzh(Bundle bundle) {
        MediaRouteSelector mediaRouteSelector = MediaRouteSelector.fromBundle((Bundle)bundle);
        for (MediaRouter.Callback callback : this.zzeth.get(mediaRouteSelector)) {
            this.zzems.removeCallback(callback);
        }
    }

    @Override
    public final boolean zzb(Bundle bundle, int n) {
        return this.zzems.isRouteAvailable(MediaRouteSelector.fromBundle((Bundle)bundle), n);
    }

    @Override
    public final void zzfd(String string2) {
        for (MediaRouter.RouteInfo routeInfo : this.zzems.getRoutes()) {
            if (!routeInfo.getId().equals(string2)) continue;
            this.zzems.selectRoute(routeInfo);
            return;
        }
    }

    @Override
    public final void zzadb() {
        this.zzems.selectRoute(this.zzems.getDefaultRoute());
    }

    @Override
    public final boolean zzadc() {
        return this.zzems.getSelectedRoute().getId().equals(this.zzems.getDefaultRoute().getId());
    }

    @Override
    public final Bundle zzfe(String string2) {
        for (MediaRouter.RouteInfo routeInfo : this.zzems.getRoutes()) {
            if (!routeInfo.getId().equals(string2)) continue;
            return routeInfo.getExtras();
        }
        return null;
    }

    @Override
    public final String zzadd() {
        return this.zzems.getSelectedRoute().getId();
    }

    public final void setMediaSessionCompat(MediaSessionCompat mediaSessionCompat) {
        this.zzems.setMediaSessionCompat(mediaSessionCompat);
    }
}

