/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.app.Activity;
import android.content.Context;
import android.preference.PreferenceManager;
import android.support.annotation.ColorRes;
import android.support.annotation.DimenRes;
import android.support.annotation.StringRes;
import android.support.v7.app.MediaRouteButton;
import android.view.MenuItem;
import android.view.View;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.internal.zzaxs;
import com.google.android.gms.internal.zzaxw;

public interface IntroductoryOverlay {
    public void show();

    public void remove();

    public static class Builder {
        private final Activity mActivity;
        private final View zzert;
        private int zzeru;
        private String zzerv;
        private OnOverlayDismissedListener zzerw;
        private boolean zzerx;
        private float zzery;
        private String zzerz;

        public Builder(Activity activity, MenuItem menuItem) {
            this.mActivity = (Activity)zzbq.checkNotNull((Object)activity);
            this.zzert = ((MenuItem)zzbq.checkNotNull((Object)menuItem)).getActionView();
        }

        public Builder(Activity activity, MediaRouteButton mediaRouteButton) {
            this.mActivity = (Activity)zzbq.checkNotNull((Object)activity);
            this.zzert = (View)zzbq.checkNotNull((Object)mediaRouteButton);
        }

        public Builder setOverlayColor(@ColorRes int n) {
            this.zzeru = this.mActivity.getResources().getColor(n);
            return this;
        }

        public Builder setTitleText(String string2) {
            this.zzerv = string2;
            return this;
        }

        public Builder setTitleText(@StringRes int n) {
            this.zzerv = this.mActivity.getResources().getString(n);
            return this;
        }

        public Builder setOnOverlayDismissedListener(OnOverlayDismissedListener onOverlayDismissedListener) {
            this.zzerw = onOverlayDismissedListener;
            return this;
        }

        public Builder setSingleTime() {
            this.zzerx = true;
            return this;
        }

        public Builder setFocusRadiusId(@DimenRes int n) {
            this.zzery = this.mActivity.getResources().getDimension(n);
            return this;
        }

        public Builder setFocusRadius(float f) {
            this.zzery = f;
            return this;
        }

        public Builder setButtonText(String string2) {
            this.zzerz = string2;
            return this;
        }

        public Builder setButtonText(@StringRes int n) {
            this.zzerz = this.mActivity.getResources().getString(n);
            return this;
        }

        public final Activity getActivity() {
            return this.mActivity;
        }

        public final View zzacs() {
            return this.zzert;
        }

        public final OnOverlayDismissedListener zzact() {
            return this.zzerw;
        }

        public final int zzacu() {
            return this.zzeru;
        }

        public final boolean zzacv() {
            return this.zzerx;
        }

        public final String zzacw() {
            return this.zzerv;
        }

        public final String zzacx() {
            return this.zzerz;
        }

        public final float zzacy() {
            return this.zzery;
        }

        public IntroductoryOverlay build() {
            if (zzq.zzalw()) {
                return new zzaxs(this);
            }
            return new zzaxw(this);
        }
    }

    public static final class zza {
        public static void zzbt(Context context) {
            PreferenceManager.getDefaultSharedPreferences((Context)context).edit().putBoolean("googlecast-introOverlayShown", true).apply();
        }

        public static boolean zzbu(Context context) {
            return PreferenceManager.getDefaultSharedPreferences((Context)context).getBoolean("googlecast-introOverlayShown", false);
        }
    }

    public static interface OnOverlayDismissedListener {
        public void onOverlayDismissed();
    }
}

