/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import com.google.android.gms.cast.framework.zzac;
import com.google.android.gms.cast.framework.zzad;
import com.google.android.gms.cast.framework.zzt;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.internal.zzaxj;
import com.google.android.gms.internal.zzbbv;

public abstract class Session {
    private static final zzbbv zzelm = new zzbbv("Session");
    private final zzt zzesc;
    private final zza zzesd = new zza(this, null);

    protected Session(Context context, String string2, String string3) {
        this.zzesc = zzaxj.zza(context, string2, string3, this.zzesd);
    }

    protected abstract void start(Bundle var1);

    protected abstract void resume(Bundle var1);

    protected abstract void end(boolean var1);

    protected void onStarting(Bundle bundle) {
    }

    protected void onResuming(Bundle bundle) {
    }

    public long getSessionRemainingTimeMs() {
        zzbq.zzfz((String)"Must be called from the main thread.");
        return 0L;
    }

    public final String getCategory() {
        zzbq.zzfz((String)"Must be called from the main thread.");
        try {
            return this.zzesc.getCategory();
        }
        catch (RemoteException remoteException) {
            zzelm.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getCategory", zzt.class.getSimpleName()});
            return null;
        }
    }

    public final String getSessionId() {
        zzbq.zzfz((String)"Must be called from the main thread.");
        try {
            return this.zzesc.getSessionId();
        }
        catch (RemoteException remoteException) {
            zzelm.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getSessionId", zzt.class.getSimpleName()});
            return null;
        }
    }

    public boolean isConnected() {
        zzbq.zzfz((String)"Must be called from the main thread.");
        try {
            return this.zzesc.isConnected();
        }
        catch (RemoteException remoteException) {
            zzelm.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"isConnected", zzt.class.getSimpleName()});
            return false;
        }
    }

    public boolean isConnecting() {
        zzbq.zzfz((String)"Must be called from the main thread.");
        try {
            return this.zzesc.isConnecting();
        }
        catch (RemoteException remoteException) {
            zzelm.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"isConnecting", zzt.class.getSimpleName()});
            return false;
        }
    }

    public boolean isDisconnecting() {
        zzbq.zzfz((String)"Must be called from the main thread.");
        try {
            return this.zzesc.isDisconnecting();
        }
        catch (RemoteException remoteException) {
            zzelm.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"isDisconnecting", zzt.class.getSimpleName()});
            return false;
        }
    }

    public boolean isDisconnected() {
        zzbq.zzfz((String)"Must be called from the main thread.");
        try {
            return this.zzesc.isDisconnected();
        }
        catch (RemoteException remoteException) {
            zzelm.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"isDisconnected", zzt.class.getSimpleName()});
            return true;
        }
    }

    public boolean isResuming() {
        zzbq.zzfz((String)"Must be called from the main thread.");
        try {
            return this.zzesc.isResuming();
        }
        catch (RemoteException remoteException) {
            zzelm.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"isResuming", zzt.class.getSimpleName()});
            return false;
        }
    }

    public boolean isSuspended() {
        zzbq.zzfz((String)"Must be called from the main thread.");
        try {
            return this.zzesc.isSuspended();
        }
        catch (RemoteException remoteException) {
            zzelm.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"isSuspended", zzt.class.getSimpleName()});
            return false;
        }
    }

    protected final void notifySessionStarted(String string2) {
        try {
            this.zzesc.notifySessionStarted(string2);
            return;
        }
        catch (RemoteException remoteException) {
            zzelm.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"notifySessionStarted", zzt.class.getSimpleName()});
            return;
        }
    }

    protected final void notifyFailedToStartSession(int n) {
        try {
            this.zzesc.notifyFailedToStartSession(n);
            return;
        }
        catch (RemoteException remoteException) {
            zzelm.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"notifyFailedToStartSession", zzt.class.getSimpleName()});
            return;
        }
    }

    protected final void notifySessionEnded(int n) {
        try {
            this.zzesc.notifySessionEnded(n);
            return;
        }
        catch (RemoteException remoteException) {
            zzelm.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"notifySessionEnded", zzt.class.getSimpleName()});
            return;
        }
    }

    protected final void notifySessionResumed(boolean bl) {
        try {
            this.zzesc.notifySessionResumed(bl);
            return;
        }
        catch (RemoteException remoteException) {
            zzelm.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"notifySessionResumed", zzt.class.getSimpleName()});
            return;
        }
    }

    protected final void notifyFailedToResumeSession(int n) {
        try {
            this.zzesc.notifyFailedToResumeSession(n);
            return;
        }
        catch (RemoteException remoteException) {
            zzelm.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"notifyFailedToResumeSession", zzt.class.getSimpleName()});
            return;
        }
    }

    protected final void notifySessionSuspended(int n) {
        try {
            this.zzesc.notifySessionSuspended(n);
            return;
        }
        catch (RemoteException remoteException) {
            zzelm.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"notifySessionSuspended", zzt.class.getSimpleName()});
            return;
        }
    }

    public final IObjectWrapper zzacp() {
        try {
            return this.zzesc.zzacp();
        }
        catch (RemoteException remoteException) {
            zzelm.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getWrappedObject", zzt.class.getSimpleName()});
            return null;
        }
    }

    final class zza
    extends zzac {
        private /* synthetic */ Session zzese;

        private zza(Session session) {
            this.zzese = session;
        }

        @Override
        public final IObjectWrapper zzacr() {
            return zzn.zzy((Object)this.zzese);
        }

        @Override
        public final void onStarting(Bundle bundle) {
            this.zzese.onStarting(bundle);
        }

        @Override
        public final void start(Bundle bundle) {
            this.zzese.start(bundle);
        }

        @Override
        public final void onResuming(Bundle bundle) {
            this.zzese.onResuming(bundle);
        }

        @Override
        public final void resume(Bundle bundle) {
            this.zzese.resume(bundle);
        }

        @Override
        public final void end(boolean bl) {
            this.zzese.end(bl);
        }

        @Override
        public final long getSessionRemainingTimeMs() {
            return this.zzese.getSessionRemainingTimeMs();
        }

        /* synthetic */ zza(Session session, zzad zzad2) {
            this(session);
        }
    }
}

