/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Parcelable;
import android.support.v4.media.MediaMetadataCompat;
import android.support.v4.media.session.MediaSessionCompat;
import android.support.v4.media.session.PlaybackStateCompat;
import android.text.TextUtils;
import com.google.android.gms.R;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaMetadata;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.framework.CastOptions;
import com.google.android.gms.cast.framework.ReconnectionService;
import com.google.android.gms.cast.framework.media.MediaNotificationService;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.internal.zzayb;
import com.google.android.gms.internal.zzayc;
import com.google.android.gms.internal.zzayo;
import com.google.android.gms.internal.zzayp;
import com.google.android.gms.internal.zzayq;

public final class zzayn
implements RemoteMediaClient.Listener {
    private final Context zzeqr;
    private final CastOptions zzext;
    private final zzayb zzesk;
    private final ComponentName zzexu;
    private final zzayc zzexv;
    private final zzayc zzexw;
    private RemoteMediaClient zzerm;
    private CastDevice zzeks;
    private MediaSessionCompat zzexx;
    private MediaSessionCompat.Callback zzexy;
    private boolean zzexz;

    public zzayn(Context context, CastOptions castOptions, zzayb zzayb2) {
        this.zzeqr = context;
        this.zzext = castOptions;
        this.zzesk = zzayb2;
        this.zzexu = this.zzext.getCastMediaOptions() != null && !TextUtils.isEmpty((CharSequence)this.zzext.getCastMediaOptions().getExpandedControllerActivityClassName()) ? new ComponentName(this.zzeqr, this.zzext.getCastMediaOptions().getExpandedControllerActivityClassName()) : null;
        this.zzexv = new zzayc(this.zzeqr);
        this.zzexv.zza(new zzayo(this));
        this.zzexw = new zzayc(this.zzeqr);
        this.zzexw.zza(new zzayp(this));
    }

    public final void zza(RemoteMediaClient remoteMediaClient, CastDevice castDevice) {
        if (this.zzexz || this.zzext == null || this.zzext.getCastMediaOptions() == null || remoteMediaClient == null || castDevice == null) {
            return;
        }
        this.zzerm = remoteMediaClient;
        this.zzerm.addListener(this);
        this.zzeks = castDevice;
        if (!zzq.zzamb()) {
            ((AudioManager)this.zzeqr.getSystemService("audio")).requestAudioFocus(null, 3, 3);
        }
        ComponentName componentName = new ComponentName(this.zzeqr, this.zzext.getCastMediaOptions().getMediaIntentReceiverClassName());
        Intent intent = new Intent("android.intent.action.MEDIA_BUTTON");
        intent.setComponent(componentName);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.zzeqr, (int)0, (Intent)intent, (int)0);
        this.zzexx = new MediaSessionCompat(this.zzeqr, "CastMediaSession", componentName, pendingIntent);
        this.zzexx.setFlags(3);
        this.zza(0, null);
        if (this.zzeks != null && !TextUtils.isEmpty((CharSequence)this.zzeks.getFriendlyName())) {
            this.zzexx.setMetadata(new MediaMetadataCompat.Builder().putString("android.media.metadata.ALBUM_ARTIST", this.zzeqr.getResources().getString(R.string.cast_casting_to_device, new Object[]{this.zzeks.getFriendlyName()})).build());
        }
        this.zzexy = new zzayq(this);
        this.zzexx.setCallback(this.zzexy);
        this.zzexx.setActive(true);
        this.zzesk.setMediaSessionCompat(this.zzexx);
        this.zzexz = true;
        this.zzax(false);
    }

    public final void zzbi(int n) {
        if (!this.zzexz) {
            return;
        }
        this.zzexz = false;
        if (this.zzerm != null) {
            this.zzerm.removeListener(this);
        }
        if (!zzq.zzamb()) {
            ((AudioManager)this.zzeqr.getSystemService("audio")).abandonAudioFocus(null);
        }
        this.zzesk.setMediaSessionCompat(null);
        if (this.zzexv != null) {
            this.zzexv.clear();
        }
        if (this.zzexw != null) {
            this.zzexw.clear();
        }
        if (this.zzexx != null) {
            this.zzexx.setSessionActivity(null);
            this.zzexx.setCallback(null);
            this.zzexx.setMetadata(new MediaMetadataCompat.Builder().build());
            this.zza(0, null);
            this.zzexx.setActive(false);
            this.zzexx.release();
            this.zzexx = null;
        }
        this.zzerm = null;
        this.zzeks = null;
        this.zzexy = null;
        this.zzaea();
        if (n == 0) {
            this.zzaeb();
        }
    }

    @Override
    public final void onQueueStatusUpdated() {
        this.zzax(false);
    }

    @Override
    public final void onStatusUpdated() {
        this.zzax(false);
    }

    @Override
    public final void onMetadataUpdated() {
        this.zzax(false);
    }

    @Override
    public final void onPreloadStatusUpdated() {
        this.zzax(false);
    }

    @Override
    public final void onAdBreakStatusUpdated() {
        this.zzax(false);
    }

    @Override
    public final void onSendingRemoteMediaRequest() {
    }

    public final void zzax(boolean bl) {
        int n;
        if (this.zzerm == null) {
            return;
        }
        MediaStatus mediaStatus = this.zzerm.getMediaStatus();
        MediaInfo mediaInfo = mediaStatus == null ? null : mediaStatus.getMediaInfo();
        MediaMetadata mediaMetadata = mediaInfo == null ? null : mediaInfo.getMetadata();
        boolean bl2 = false;
        if (mediaStatus == null || mediaInfo == null || mediaMetadata == null) {
            n = 0;
        } else {
            switch (this.zzerm.getPlayerState()) {
                case 4: {
                    n = 6;
                    break;
                }
                case 2: {
                    n = 3;
                    break;
                }
                case 3: {
                    n = 2;
                    break;
                }
                case 1: {
                    int n2 = mediaStatus.getIdleReason();
                    boolean bl3 = this.zzerm.isLiveStream() && n2 == 2;
                    int n3 = mediaStatus.getLoadingItemId();
                    boolean bl4 = bl2 = n3 != 0 && (n2 == 1 || n2 == 3);
                    if (bl3) {
                        n = 2;
                        break;
                    }
                    MediaQueueItem mediaQueueItem = mediaStatus.getQueueItemById(n3);
                    if (mediaQueueItem != null) {
                        mediaInfo = mediaQueueItem.getMedia();
                        n = 6;
                        break;
                    }
                    n = 0;
                    break;
                }
                default: {
                    n = 0;
                }
            }
        }
        this.zza(n, mediaInfo);
        if (n == 0) {
            this.zzaea();
            this.zzaeb();
            return;
        }
        boolean bl5 = bl;
        zzayn zzayn2 = this;
        if (zzayn2.zzext.getCastMediaOptions().getNotificationOptions() != null && zzayn2.zzerm != null) {
            Intent intent = new Intent(zzayn2.zzeqr, MediaNotificationService.class);
            intent.putExtra("extra_media_notification_force_update", bl5);
            intent.setPackage(zzayn2.zzeqr.getPackageName());
            intent.setAction("com.google.android.gms.cast.framework.action.UPDATE_NOTIFICATION");
            intent.putExtra("extra_media_info", (Parcelable)zzayn2.zzerm.getMediaInfo());
            intent.putExtra("extra_remote_media_client_player_state", zzayn2.zzerm.getPlayerState());
            intent.putExtra("extra_cast_device", (Parcelable)zzayn2.zzeks);
            zzayn zzayn3 = zzayn2;
            intent.putExtra("extra_media_session_token", zzayn3.zzexx == null ? null : zzayn3.zzexx.getSessionToken());
            MediaStatus mediaStatus2 = zzayn2.zzerm.getMediaStatus();
            if (mediaStatus2 != null) {
                boolean bl6 = false;
                boolean bl7 = false;
                switch (mediaStatus2.getQueueRepeatMode()) {
                    case 1: 
                    case 2: 
                    case 3: {
                        bl6 = true;
                        bl7 = true;
                        break;
                    }
                    default: {
                        Integer n4 = mediaStatus2.getIndexById(mediaStatus2.getCurrentItemId());
                        if (n4 == null) break;
                        if (n4 > 0) {
                            bl7 = true;
                        }
                        if (n4 >= mediaStatus2.getQueueItemCount() - 1) break;
                        bl6 = true;
                    }
                }
                intent.putExtra("extra_can_skip_next", bl6);
                intent.putExtra("extra_can_skip_prev", bl7);
            }
            zzayn2.zzeqr.startService(intent);
        }
        if (!bl2) {
            zzayn2 = this;
            if (zzayn2.zzext.getEnableReconnectionService()) {
                Intent intent = new Intent(zzayn2.zzeqr, ReconnectionService.class);
                intent.setPackage(zzayn2.zzeqr.getPackageName());
                zzayn2.zzeqr.startService(intent);
            }
        }
    }

    private final void zza(int n, MediaInfo mediaInfo) {
        Intent intent;
        PendingIntent pendingIntent;
        if (n == 0) {
            this.zzexx.setPlaybackState(new PlaybackStateCompat.Builder().setState(0, 0L, 1.0f).build());
            this.zzexx.setMetadata(new MediaMetadataCompat.Builder().build());
            return;
        }
        long l = mediaInfo.getStreamType() == 2 ? 5L : 512L;
        this.zzexx.setPlaybackState(new PlaybackStateCompat.Builder().setState(n, 0L, 1.0f).setActions(l).build());
        zzayn zzayn2 = this;
        if (zzayn2.zzexu == null) {
            pendingIntent = null;
        } else {
            intent = new Intent();
            intent.setComponent(zzayn2.zzexu);
            pendingIntent = PendingIntent.getActivity((Context)zzayn2.zzeqr, (int)0, (Intent)intent, (int)0x8000000);
        }
        this.zzexx.setSessionActivity(pendingIntent);
        intent = mediaInfo;
        zzayn2 = this;
        MediaMetadata mediaMetadata = intent.getMetadata();
        MediaMetadataCompat.Builder builder = zzayn2.zzadz().putString("android.media.metadata.TITLE", mediaMetadata.getString("com.google.android.gms.cast.metadata.TITLE")).putString("android.media.metadata.DISPLAY_TITLE", mediaMetadata.getString("com.google.android.gms.cast.metadata.TITLE")).putString("android.media.metadata.DISPLAY_SUBTITLE", mediaMetadata.getString("com.google.android.gms.cast.metadata.SUBTITLE")).putLong("android.media.metadata.DURATION", intent.getStreamDuration());
        zzayn2.zzexx.setMetadata(builder.build());
        Uri uri = zzayn2.zza(mediaMetadata, 0);
        if (uri != null) {
            zzayn2.zzexv.zzl(uri);
        } else {
            zzayn2.zza((Bitmap)null, 0);
        }
        Uri uri2 = zzayn2.zza(mediaMetadata, 3);
        if (uri2 != null) {
            zzayn2.zzexw.zzl(uri2);
            return;
        }
        zzayn2.zza((Bitmap)null, 3);
    }

    private final void zza(Bitmap bitmap, int n) {
        if (n == 0) {
            if (bitmap != null) {
                this.zzexx.setMetadata(this.zzadz().putBitmap("android.media.metadata.DISPLAY_ICON", bitmap).build());
                return;
            }
            Bitmap bitmap2 = Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap2.eraseColor(0);
            this.zzexx.setMetadata(this.zzadz().putBitmap("android.media.metadata.DISPLAY_ICON", bitmap2).build());
            return;
        }
        if (n == 3) {
            this.zzexx.setMetadata(this.zzadz().putBitmap("android.media.metadata.ALBUM_ART", bitmap).build());
        }
    }

    private final Uri zza(MediaMetadata mediaMetadata, int n) {
        WebImage webImage;
        if ((this.zzext.getCastMediaOptions().getImagePicker() != null ? this.zzext.getCastMediaOptions().getImagePicker().onPickImage(mediaMetadata, n) : (webImage = mediaMetadata.hasImages() ? (WebImage)mediaMetadata.getImages().get(0) : null)) == null) {
            return null;
        }
        return webImage.getUrl();
    }

    private final MediaMetadataCompat.Builder zzadz() {
        MediaMetadataCompat mediaMetadataCompat = this.zzexx.getController().getMetadata();
        if (mediaMetadataCompat == null) {
            return new MediaMetadataCompat.Builder();
        }
        return new MediaMetadataCompat.Builder(mediaMetadataCompat);
    }

    private final void zzaea() {
        if (this.zzext.getCastMediaOptions().getNotificationOptions() == null) {
            return;
        }
        Intent intent = new Intent(this.zzeqr, MediaNotificationService.class);
        intent.setPackage(this.zzeqr.getPackageName());
        intent.setAction("com.google.android.gms.cast.framework.action.UPDATE_NOTIFICATION");
        this.zzeqr.stopService(intent);
    }

    private final void zzaeb() {
        if (!this.zzext.getEnableReconnectionService()) {
            return;
        }
        Intent intent = new Intent(this.zzeqr, ReconnectionService.class);
        intent.setPackage(this.zzeqr.getPackageName());
        this.zzeqr.stopService(intent);
    }

    static /* synthetic */ void zza(zzayn zzayn2, Bitmap bitmap, int n) {
        zzayn2.zza(bitmap, n);
    }

    static /* synthetic */ RemoteMediaClient zza(zzayn zzayn2) {
        return zzayn2.zzerm;
    }
}

