/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.view.View;
import android.widget.ImageView;
import com.google.android.gms.R;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.uicontroller.UIController;
import com.google.android.gms.internal.zzazj;

public final class zzazi
extends UIController {
    private final ImageView zzeym;
    private final View zzezb;
    private final boolean zzezc;
    private final Drawable zzezd;
    private final String zzeze;
    private final Drawable zzezf;
    private final String zzezg;
    private final Drawable zzezh;
    private final String zzezi;
    private final View.OnClickListener zzeyk;

    public zzazi(@NonNull ImageView imageView, Context context, @NonNull Drawable drawable2, @NonNull Drawable drawable3, Drawable drawable4, View view, boolean bl) {
        this.zzeym = imageView;
        this.zzezd = drawable2;
        this.zzezf = drawable3;
        this.zzezh = drawable4 != null ? drawable4 : drawable3;
        this.zzeze = context.getString(R.string.cast_play);
        this.zzezg = context.getString(R.string.cast_pause);
        this.zzezi = context.getString(R.string.cast_stop);
        this.zzezb = view;
        this.zzezc = bl;
        this.zzeyk = new zzazj(this);
    }

    @Override
    public final void onSessionConnected(CastSession castSession) {
        super.onSessionConnected(castSession);
        this.zzeym.setOnClickListener(this.zzeyk);
        this.zzaee();
    }

    @Override
    public final void onSessionEnded() {
        this.zzeym.setOnClickListener(null);
        super.onSessionEnded();
    }

    @Override
    public final void onMediaStatusUpdated() {
        this.zzaee();
    }

    @Override
    public final void onSendingRemoteMediaRequest() {
        this.zzaz(true);
    }

    private final void zzaee() {
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession()) {
            this.zzeym.setEnabled(false);
            return;
        }
        if (remoteMediaClient.isPaused()) {
            this.zza(this.zzezd, this.zzeze);
            return;
        }
        if (remoteMediaClient.isPlaying()) {
            if (remoteMediaClient.isLiveStream()) {
                this.zza(this.zzezh, this.zzezi);
                return;
            }
            this.zza(this.zzezf, this.zzezg);
            return;
        }
        if (remoteMediaClient.isBuffering()) {
            this.zzaz(false);
            return;
        }
        if (remoteMediaClient.isLoadingNextItem()) {
            this.zzaz(true);
        }
    }

    private final void zza(Drawable drawable2, String string2) {
        this.zzeym.setImageDrawable(drawable2);
        this.zzeym.setContentDescription((CharSequence)string2);
        this.zzeym.setVisibility(0);
        this.zzeym.setEnabled(true);
        if (this.zzezb != null) {
            this.zzezb.setVisibility(8);
        }
    }

    private final void zzaz(boolean bl) {
        if (this.zzezb != null) {
            this.zzezb.setVisibility(0);
        }
        this.zzeym.setVisibility(this.zzezc ? 4 : 0);
        this.zzeym.setEnabled(!bl);
    }

    static /* synthetic */ RemoteMediaClient zza(zzazi zzazi2) {
        return zzazi2.getRemoteMediaClient();
    }
}

