/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.cast.LaunchOptions;
import com.google.android.gms.cast.framework.media.CastMediaOptions;
import com.google.android.gms.cast.framework.zzb;
import com.google.android.gms.internal.zzbfm;
import com.google.android.gms.internal.zzbfp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CastOptions
extends zzbfm {
    public static final Parcelable.Creator<CastOptions> CREATOR = new zzb();
    private final String zzeuc;
    private final List<String> zzeud;
    private final boolean zzeue;
    private final LaunchOptions zzeqb;
    private final boolean zzeuf;
    private final CastMediaOptions zzeug;
    private final boolean zzeuh;
    private final double zzeui;

    CastOptions(String string2, List<String> list, boolean bl, LaunchOptions launchOptions, boolean bl2, CastMediaOptions castMediaOptions, boolean bl3, double d) {
        this.zzeuc = TextUtils.isEmpty((CharSequence)string2) ? "" : string2;
        int n = list == null ? 0 : list.size();
        this.zzeud = new ArrayList<String>(n);
        if (n > 0) {
            this.zzeud.addAll(list);
        }
        this.zzeue = bl;
        this.zzeqb = launchOptions == null ? new LaunchOptions() : launchOptions;
        this.zzeuf = bl2;
        this.zzeug = castMediaOptions;
        this.zzeuh = bl3;
        this.zzeui = d;
    }

    public String getReceiverApplicationId() {
        return this.zzeuc;
    }

    public List<String> getSupportedNamespaces() {
        return Collections.unmodifiableList(this.zzeud);
    }

    public boolean getStopReceiverApplicationWhenEndingSession() {
        return this.zzeue;
    }

    public LaunchOptions getLaunchOptions() {
        return this.zzeqb;
    }

    public boolean getResumeSavedSession() {
        return this.zzeuf;
    }

    public CastMediaOptions getCastMediaOptions() {
        return this.zzeug;
    }

    public boolean getEnableReconnectionService() {
        return this.zzeuh;
    }

    public double getVolumeDeltaBeforeIceCreamSandwich() {
        return this.zzeui;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        CastOptions castOptions = this;
        int n2 = zzbfp.zze((Parcel)parcel2);
        zzbfp.zza((Parcel)parcel2, (int)2, (String)castOptions.getReceiverApplicationId(), (boolean)false);
        zzbfp.zzb((Parcel)parcel2, (int)3, castOptions.getSupportedNamespaces(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)4, (boolean)castOptions.getStopReceiverApplicationWhenEndingSession());
        zzbfp.zza((Parcel)parcel2, (int)5, (Parcelable)castOptions.getLaunchOptions(), (int)n, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)6, (boolean)castOptions.getResumeSavedSession());
        zzbfp.zza((Parcel)parcel2, (int)7, (Parcelable)castOptions.getCastMediaOptions(), (int)n, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)8, (boolean)castOptions.getEnableReconnectionService());
        zzbfp.zza((Parcel)parcel2, (int)9, (double)castOptions.getVolumeDeltaBeforeIceCreamSandwich());
        zzbfp.zzai((Parcel)parcel2, (int)n2);
    }

    public static final class Builder {
        private String zzeuc;
        private List<String> zzeud = new ArrayList<String>();
        private boolean zzeue;
        private LaunchOptions zzeqb = new LaunchOptions();
        private boolean zzeuf = true;
        private CastMediaOptions zzeug = new CastMediaOptions.Builder().build();
        private boolean zzeuh = true;
        private double zzeui = 0.05f;

        public Builder() {
        }

        public final Builder setReceiverApplicationId(String string2) {
            this.zzeuc = string2;
            return this;
        }

        public final Builder setSupportedNamespaces(List<String> list) {
            this.zzeud = list;
            return this;
        }

        public final Builder setStopReceiverApplicationWhenEndingSession(boolean bl) {
            this.zzeue = bl;
            return this;
        }

        public final Builder setLaunchOptions(LaunchOptions launchOptions) {
            this.zzeqb = launchOptions;
            return this;
        }

        public final Builder setResumeSavedSession(boolean bl) {
            this.zzeuf = bl;
            return this;
        }

        public final Builder setCastMediaOptions(CastMediaOptions castMediaOptions) {
            this.zzeug = castMediaOptions;
            return this;
        }

        public final Builder setEnableReconnectionService(boolean bl) {
            this.zzeuh = bl;
            return this;
        }

        public final Builder setVolumeDeltaBeforeIceCreamSandwich(double d) throws IllegalArgumentException {
            if (d <= 0.0 || d > 0.5) {
                throw new IllegalArgumentException("volumeDelta must be greater than 0 and less or equal to 0.5");
            }
            this.zzeui = d;
            return this;
        }

        public final CastOptions build() {
            return new CastOptions(this.zzeuc, this.zzeud, this.zzeue, this.zzeqb, this.zzeuf, this.zzeug, this.zzeuh, this.zzeui);
        }
    }
}

